/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVObject;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;

public abstract class DBVUtils {
    @Nullable
    public static DBVTransformSettings getTransformSettings(@NotNull DBDAttributeBinding binding, boolean create) {
        DBVEntityAttribute vAttr;
        DBVEntity vEntity;
        DBSEntityAttribute entityAttribute = binding.getEntityAttribute();
        if (entityAttribute != null && (vEntity = DBVUtils.findVirtualEntity(entityAttribute.getParentObject(), create)) != null && (vAttr = vEntity.getVirtualAttribute(binding, create)) != null) {
            return DBVUtils.getTransformSettings(vAttr, create);
        }
        return null;
    }

    @Nullable
    public static DBVTransformSettings getTransformSettings(@NotNull DBVEntityAttribute attribute, boolean create) {
        if (attribute.getTransformSettings() != null) {
            return attribute.getTransformSettings();
        }
        if (create) {
            attribute.setTransformSettings(new DBVTransformSettings());
            return attribute.getTransformSettings();
        }
        DBVObject object = attribute.getParentObject();
        while (object != null) {
            if (object.getTransformSettings() != null) {
                return object.getTransformSettings();
            }
            object = ((DBVObject)object).getParentObject();
        }
        return null;
    }

    @NotNull
    public static Map<String, String> getAttributeTransformersOptions(@NotNull DBDAttributeBinding binding) {
        Map<String, String> options = null;
        DBVTransformSettings transformSettings = DBVUtils.getTransformSettings(binding, false);
        if (transformSettings != null) {
            options = transformSettings.getTransformOptions();
        }
        if (options != null) {
            return options;
        }
        return Collections.emptyMap();
    }

    @Nullable
    public static DBVEntity findVirtualEntity(@NotNull DBSEntity source, boolean create) {
        return source.getDataSource().getContainer().getVirtualModel().findEntity(source, create);
    }

    @Nullable
    public static DBDAttributeTransformer[] findAttributeTransformers(@NotNull DBDAttributeBinding binding, @Nullable Boolean custom) {
        DBVTransformSettings transformSettings;
        DBVEntityAttribute vAttr;
        DBVEntity vEntity;
        DBPDataSource dataSource = binding.getDataSource();
        DBPDataSourceContainer container = dataSource.getContainer();
        List<? extends DBDAttributeTransformerDescriptor> tdList = container.getPlatform().getValueHandlerRegistry().findTransformers(dataSource, binding.getAttribute(), custom);
        if (tdList == null || tdList.isEmpty()) {
            return null;
        }
        boolean filtered = false;
        DBSEntityAttribute entityAttribute = binding.getEntityAttribute();
        if (entityAttribute != null && (vEntity = DBVUtils.findVirtualEntity(entityAttribute.getParentObject(), false)) != null && (vAttr = vEntity.getVirtualAttribute(binding, false)) != null && (transformSettings = DBVUtils.getTransformSettings(vAttr, false)) != null) {
            filtered = transformSettings.filterTransformers(tdList);
        }
        if (!filtered) {
            int i = 0;
            while (i < tdList.size()) {
                if (tdList.get(i).isCustom() || !tdList.get(i).isApplicableByDefault()) {
                    tdList.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (tdList.isEmpty()) {
            return null;
        }
        DBDAttributeTransformer[] result = new DBDAttributeTransformer[tdList.size()];
        int i = 0;
        while (i < tdList.size()) {
            result[i] = (DBDAttributeTransformer)tdList.get(i).getInstance();
            ++i;
        }
        return result;
    }

    public static String getDictionaryDescriptionColumns(DBRProgressMonitor monitor, DBSEntityAttribute attribute) throws DBException {
        DBVEntity dictionary = DBVUtils.findVirtualEntity(attribute.getParentObject(), false);
        String descColumns = null;
        if (dictionary != null) {
            descColumns = dictionary.getDescriptionColumnNames();
        }
        if (descColumns == null) {
            descColumns = DBVEntity.getDefaultDescriptionColumn(monitor, attribute);
        }
        return descColumns;
    }

    @NotNull
    public static List<DBDLabelValuePair> readDictionaryRows(DBCSession session, DBSEntityAttribute valueAttribute, DBDValueHandler valueHandler, DBCResultSet dbResult) throws DBCException {
        ArrayList<DBDLabelValuePair> values = new ArrayList<DBDLabelValuePair>();
        List<DBCAttributeMetaData> metaColumns = dbResult.getMeta().getAttributes();
        ArrayList<DBDValueHandler> colHandlers = new ArrayList<DBDValueHandler>(metaColumns.size());
        for (DBCAttributeMetaData col : metaColumns) {
            colHandlers.add(DBUtils.findValueHandler(session, (DBSTypedObject)col));
        }
        while (dbResult.nextRow()) {
            if (session.getProgressMonitor().isCanceled()) break;
            Object keyValue = valueHandler.fetchValueObject(session, dbResult, valueAttribute, 0);
            if (keyValue == null) continue;
            String keyLabel = valueHandler.getValueDisplayString(valueAttribute, keyValue, DBDDisplayFormat.NATIVE);
            if (metaColumns.size() > 1) {
                keyLabel = "";
                int i = 1;
                while (i < colHandlers.size()) {
                    Object descValue = ((DBDValueHandler)colHandlers.get(i)).fetchValueObject(session, dbResult, metaColumns.get(i), i);
                    if (!keyLabel.isEmpty()) {
                        keyLabel = String.valueOf(keyLabel) + " ";
                    }
                    keyLabel = String.valueOf(keyLabel) + ((DBDValueHandler)colHandlers.get(i)).getValueDisplayString(metaColumns.get(i), descValue, DBDDisplayFormat.NATIVE);
                    ++i;
                }
            }
            values.add(new DBDLabelValuePair(keyLabel, keyValue));
        }
        return values;
    }
}

