/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.BlockCanceler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class AbstractJob
extends Job {
    private static final Log log = Log.getLog(AbstractJob.class);
    public static final int TIMEOUT_BEFORE_BLOCK_CANCEL = 250;
    private DBRProgressMonitor progressMonitor;
    private volatile boolean finished = false;
    private volatile boolean blockCanceled = false;
    private AbstractJob attachedJob = null;
    protected static final ThreadLocal<AbstractJob> CURRENT_JOB = new ThreadLocal();

    protected AbstractJob(String name) {
        super(name);
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected Thread getActiveThread() {
        Thread thread = this.getThread();
        return thread == null ? Thread.currentThread() : thread;
    }

    public void setAttachedJob(AbstractJob attachedJob) {
        this.attachedJob = attachedJob;
    }

    public final IStatus runDirectly(DBRProgressMonitor monitor) {
        this.progressMonitor = monitor;
        this.blockCanceled = false;
        try {
            IStatus result;
            this.finished = false;
            try {
                result = this.run(this.progressMonitor);
            }
            catch (Throwable e) {
                result = GeneralUtils.makeExceptionStatus(e);
            }
            IStatus iStatus = result;
            return iStatus;
        }
        finally {
            this.finished = true;
        }
    }

    protected final IStatus run(IProgressMonitor monitor) {
        this.progressMonitor = RuntimeUtils.makeMonitor(monitor);
        this.blockCanceled = false;
        CURRENT_JOB.set(this);
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        try {
            this.finished = false;
            RuntimeUtils.setThreadName(this.getName());
            IStatus iStatus = this.run(this.progressMonitor);
            return iStatus;
        }
        catch (Throwable e) {
            log.error(e);
            IStatus iStatus = GeneralUtils.makeExceptionStatus(e);
            return iStatus;
        }
        finally {
            CURRENT_JOB.remove();
            this.finished = true;
            currentThread.setName(oldThreadName);
        }
    }

    protected abstract IStatus run(DBRProgressMonitor var1);

    protected void canceling() {
        if (this.attachedJob != null) {
            this.attachedJob.canceling();
            return;
        }
        if (!this.blockCanceled) {
            Job cancelJob = new Job("Cancel block"){
                {
                    this.setSystem(true);
                    this.setUser(false);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (!AbstractJob.this.finished && !AbstractJob.this.blockCanceled) {
                        try {
                            BlockCanceler.cancelBlock(AbstractJob.this.progressMonitor, AbstractJob.this.getActiveThread());
                        }
                        catch (DBException e) {
                            return GeneralUtils.makeExceptionStatus(e);
                        }
                        catch (Throwable e) {
                            log.debug("Cancel error", e);
                            return Status.CANCEL_STATUS;
                        }
                        AbstractJob.this.blockCanceled = true;
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                cancelJob.schedule(250L);
            }
            catch (Exception e) {
                log.debug(e);
            }
        }
    }
}

