/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm;

import java.util.Collections;
import java.util.List;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.qm.QMController;
import org.jkiss.dbeaver.model.qm.QMExecutionHandler;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMTransactionState;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;

public class QMUtils {
    private static DBPPlatform application;
    private static QMExecutionHandler defaultHandler;

    public static void initApplication(DBPPlatform application) {
        QMUtils.application = application;
    }

    public static QMExecutionHandler getDefaultHandler() {
        if (defaultHandler == null) {
            defaultHandler = application.getQueryManager().getDefaultHandler();
        }
        return defaultHandler;
    }

    public static void registerHandler(QMExecutionHandler handler) {
        application.getQueryManager().registerHandler(handler);
    }

    public static void unregisterHandler(QMExecutionHandler handler) {
        application.getQueryManager().unregisterHandler(handler);
    }

    public static void registerMetaListener(QMMetaListener metaListener) {
        application.getQueryManager().registerMetaListener(metaListener);
    }

    public static void unregisterMetaListener(QMMetaListener metaListener) {
        application.getQueryManager().unregisterMetaListener(metaListener);
    }

    public static List<QMMetaEvent> getPastMetaEvents() {
        if (application == null) {
            return Collections.emptyList();
        }
        QMController queryManager = application.getQueryManager();
        return queryManager == null ? Collections.emptyList() : queryManager.getPastMetaEvents();
    }

    public static boolean isTransactionActive(DBCExecutionContext executionContext) {
        QMMTransactionInfo txnInfo;
        if (executionContext == null || application == null) {
            return false;
        }
        QMMSessionInfo sessionInfo = QMUtils.getCurrentSession(executionContext);
        if (sessionInfo != null && sessionInfo.isTransactional() && (txnInfo = sessionInfo.getTransaction()) != null) {
            QMMStatementExecuteInfo execInfo;
            QMMTransactionSavepointInfo sp = txnInfo.getCurrentSavepoint();
            QMMStatementExecuteInfo exec = execInfo = sp.getLastExecute();
            while (exec != null && exec.getSavepoint() == sp) {
                if (exec.isTransactional()) {
                    return true;
                }
                exec = exec.getPrevious();
            }
        }
        return false;
    }

    public static QMMSessionInfo getCurrentSession(DBCExecutionContext executionContext) {
        return application.getQueryManager().getMetaCollector().getSessionInfo(executionContext);
    }

    public static QMMTransactionSavepointInfo getCurrentTransaction(DBCExecutionContext executionContext) {
        QMMTransactionInfo txnInfo;
        QMMSessionInfo sessionInfo = QMUtils.getCurrentSession(executionContext);
        if (sessionInfo != null && !sessionInfo.isClosed() && sessionInfo.isTransactional() && (txnInfo = sessionInfo.getTransaction()) != null) {
            return txnInfo.getCurrentSavepoint();
        }
        return null;
    }

    public static QMTransactionState getTransactionState(DBCExecutionContext executionContext) {
        boolean txnMode;
        int execCount = 0;
        int updateCount = 0;
        long txnStartTime = 0L;
        if (executionContext == null || application == null) {
            txnMode = false;
        } else {
            QMMSessionInfo sessionInfo = QMUtils.getCurrentSession(executionContext);
            if (sessionInfo == null || sessionInfo.isClosed()) {
                txnMode = false;
            } else if (sessionInfo.isTransactional()) {
                QMMTransactionInfo txnInfo = sessionInfo.getTransaction();
                if (txnInfo != null) {
                    QMMStatementExecuteInfo execInfo;
                    txnMode = true;
                    QMMTransactionSavepointInfo sp = txnInfo.getCurrentSavepoint();
                    QMMStatementExecuteInfo exec = execInfo = sp.getLastExecute();
                    while (exec != null && exec.getSavepoint() == sp) {
                        ++execCount;
                        DBCExecutionPurpose purpose = exec.getStatement().getPurpose();
                        if (exec.isTransactional() && !exec.hasError() && purpose != DBCExecutionPurpose.META && purpose != DBCExecutionPurpose.UTIL) {
                            txnStartTime = exec.getOpenTime();
                            ++updateCount;
                        }
                        exec = exec.getPrevious();
                    }
                } else {
                    txnMode = false;
                }
            } else {
                txnMode = false;
            }
        }
        return new QMTransactionState(execCount, updateCount, txnMode, txnStartTime);
    }
}

