/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBPToolTipObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseObject;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public abstract class DBNDatabaseNode
extends DBNNode
implements DBSWrapper,
DBPContextProvider,
IDataSourceContainerProvider {
    private static final DBNDatabaseNode[] EMPTY_NODES = new DBNDatabaseNode[0];
    private volatile boolean locked;
    protected volatile DBNDatabaseNode[] childNodes;
    private boolean filtered;

    protected DBNDatabaseNode(DBNNode parentNode) {
        super(parentNode);
    }

    protected void registerNode() {
        DBNModel model = this.getModel();
        if (model != null) {
            model.addNode(this);
        }
    }

    protected void unregisterNode(boolean reflect) {
        DBNModel model = this.getModel();
        if (model != null) {
            model.removeNode(this, reflect);
        }
    }

    @Override
    void dispose(boolean reflect) {
        this.clearChildren(reflect);
        super.dispose(reflect);
    }

    @Override
    public String getNodeType() {
        return this.getObject() == null ? "" : this.getMeta().getNodeType(this.getObject().getDataSource());
    }

    @Override
    public String getNodeName() {
        DBSObject object = this.getObject();
        if (object == null) {
            return "[NULL]";
        }
        String objectName = object instanceof DBPOverloadedObject ? ((DBPOverloadedObject)((Object)object)).getOverloadedName() : object.getName();
        if (CommonUtils.isEmpty((String)objectName) && CommonUtils.isEmpty((String)(objectName = object.toString()))) {
            objectName = String.valueOf(object.getClass().getName()) + "@" + object.hashCode();
        }
        return objectName;
    }

    @Override
    public String getNodeBriefInfo() {
        if (this.getObject() instanceof DBPToolTipObject) {
            return ((DBPToolTipObject)((Object)this.getObject())).getObjectToolTip();
        }
        return super.getNodeBriefInfo();
    }

    @Override
    public String getNodeFullName() {
        if (this.getObject() instanceof DBPQualifiedObject) {
            return ((DBPQualifiedObject)((Object)this.getObject())).getFullyQualifiedName(DBPEvaluationContext.UI);
        }
        return super.getNodeFullName();
    }

    @Override
    public String getNodeDescription() {
        return this.getObject() == null ? null : this.getObject().getDescription();
    }

    @Override
    public DBPImage getNodeIcon() {
        DBXTreeNode meta;
        DBSObject object = this.getObject();
        DBPImage image = DBValueFormatting.getObjectImage(object, false);
        if (image == null && (meta = this.getMeta()) != null) {
            image = meta.getIcon(this);
        }
        if (image != null && object instanceof DBPStatefulObject) {
            image = DBNModel.getStateOverlayImage(image, ((DBPStatefulObject)((Object)object)).getObjectState());
        }
        return image;
    }

    @Override
    public boolean allowsChildren() {
        return !this.isDisposed() && this.getMeta().hasChildren(this);
    }

    @Override
    public boolean allowsNavigableChildren() {
        return !this.isDisposed() && this.getMeta().hasChildren(this, true);
    }

    public boolean hasChildren(DBRProgressMonitor monitor, DBXTreeNode childType) throws DBException {
        if (this.isDisposed()) {
            return false;
        }
        Object[] children = this.getChildren(monitor);
        if (!ArrayUtils.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (((DBNDatabaseNode)child).getMeta() == childType) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public synchronized DBNDatabaseNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.childNodes == null && this.hasChildren(false) && this.initializeNode(monitor, null)) {
            ArrayList<DBNDatabaseNode> tmpList = new ArrayList<DBNDatabaseNode>();
            this.loadChildren(monitor, this.getMeta(), null, tmpList, true);
            if (!monitor.isCanceled()) {
                this.childNodes = tmpList.isEmpty() ? EMPTY_NODES : tmpList.toArray(new DBNDatabaseNode[tmpList.size()]);
                this.afterChildRead();
            }
        }
        return this.childNodes;
    }

    protected void afterChildRead() {
    }

    DBNDatabaseNode[] getChildNodes() {
        return this.childNodes;
    }

    boolean hasChildItem(DBSObject object) {
        if (this.childNodes != null) {
            DBNDatabaseNode[] dBNDatabaseNodeArray = this.childNodes;
            int n = this.childNodes.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                if (child.getObject() == object) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildItem(DBSObject object) {
        DBXTreeItem metaChildren = this.getItemsMeta();
        if (metaChildren != null) {
            DBNDatabaseItem newChild = new DBNDatabaseItem(this, metaChildren, object, false);
            DBNDatabaseNode dBNDatabaseNode = this;
            synchronized (dBNDatabaseNode) {
                this.childNodes = (DBNDatabaseNode[])ArrayUtils.add(DBNDatabaseNode.class, (Object[])this.childNodes, (Object)newChild);
            }
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, DBNEvent.NodeChange.LOAD, newChild));
        } else {
            log.error("Cannot add child item to " + this.getNodeName() + ". Conditions doesn't met");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChildItem(DBSObject object) {
        DBNNode childNode = null;
        DBNDatabaseNode dBNDatabaseNode = this;
        synchronized (dBNDatabaseNode) {
            if (!ArrayUtils.isEmpty((Object[])this.childNodes)) {
                int i = 0;
                while (i < this.childNodes.length) {
                    DBNDatabaseNode child = this.childNodes[i];
                    if (child.getObject() == object) {
                        childNode = child;
                        this.childNodes = (DBNDatabaseNode[])ArrayUtils.remove(DBNDatabaseNode.class, (Object[])this.childNodes, (int)i);
                        break;
                    }
                    ++i;
                }
            }
        }
        if (childNode != null) {
            childNode.dispose(true);
        }
    }

    @Override
    void clearNode(boolean reflect) {
        this.clearChildren(reflect);
    }

    public void updateChildrenOrder(boolean reflect) {
        try {
            this.refreshNodeContent(new VoidProgressMonitor(), this.getObject(), this, reflect);
        }
        catch (DBException e) {
            log.error("Error reordering node children", e);
        }
    }

    public boolean needsInitialization() {
        return this.childNodes == null && this.hasChildren(false);
    }

    @Override
    public boolean isLocked() {
        return this.locked || super.isLocked();
    }

    public boolean initializeNode(DBRProgressMonitor monitor, DBRProgressListener onFinish) {
        if (onFinish != null) {
            onFinish.onTaskFinished(Status.OK_STATUS);
        }
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        if (this.isLocked()) {
            log.warn("Attempt to refresh locked node '" + this.getNodeName() + "'");
            return null;
        }
        DBSObject object = this.getObject();
        if (object instanceof DBPRefreshableObject) {
            if (object.isPersisted()) {
                DBSObject newObject = ((DBPRefreshableObject)object).refreshObject(monitor);
                if (newObject == null) {
                    if (this.parentNode instanceof DBNDatabaseNode) {
                        ((DBNDatabaseNode)this.parentNode).removeChildItem(object);
                    }
                    return null;
                }
                this.refreshNodeContent(monitor, newObject, source, true);
                return this;
            }
            this.getModel().fireNodeUpdate(source, this, DBNEvent.NodeChange.REFRESH);
            return this;
        }
        return super.refreshNode(monitor, source);
    }

    private void refreshNodeContent(DBRProgressMonitor monitor, DBSObject newObject, Object source, boolean reflect) throws DBException {
        if (this.isDisposed()) {
            return;
        }
        this.locked = true;
        DBNModel model = this.getModel();
        try {
            if (newObject != this.getObject()) {
                this.reloadObject(monitor, newObject);
            }
            this.reloadChildren(monitor, reflect);
            if (reflect) {
                model.fireNodeUpdate(source, this, DBNEvent.NodeChange.REFRESH);
            }
        }
        finally {
            this.locked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearChildren(boolean reflect) {
        DBNDatabaseNode[] childrenCopy;
        DBNDatabaseNode dBNDatabaseNode = this;
        synchronized (dBNDatabaseNode) {
            childrenCopy = this.childNodes == null ? null : Arrays.copyOf(this.childNodes, this.childNodes.length);
            this.childNodes = null;
        }
        if (childrenCopy != null) {
            DBNDatabaseNode[] dBNDatabaseNodeArray = childrenCopy;
            int n = childrenCopy.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                ((DBNNode)child).dispose(reflect);
                ++n2;
            }
        }
    }

    private void loadChildren(DBRProgressMonitor monitor, DBXTreeNode meta, DBNDatabaseNode[] oldList, List<DBNDatabaseNode> toList, boolean reflect) throws DBException {
        if (monitor.isCanceled()) {
            return;
        }
        this.filtered = false;
        List<DBXTreeNode> childMetas = meta.getChildren(this);
        if (CommonUtils.isEmpty(childMetas)) {
            return;
        }
        monitor.beginTask(ModelMessages.model_navigator_load_items_, childMetas.size());
        for (DBXTreeNode child : childMetas) {
            int n;
            int n2;
            DBNDatabaseNode[] dBNDatabaseNodeArray;
            if (monitor.isCanceled()) break;
            monitor.subTask(String.valueOf(ModelMessages.model_navigator_load_) + " " + child.getChildrenType(this.getObject().getDataSource()));
            if (child instanceof DBXTreeItem) {
                DBXTreeItem item = (DBXTreeItem)child;
                boolean isLoaded = this.loadTreeItems(monitor, item, oldList, toList, reflect);
                if (!isLoaded && item.isOptional() && item.getRecursiveLink() == null) {
                    this.loadChildren(monitor, item, oldList, toList, reflect);
                }
            } else if (child instanceof DBXTreeFolder) {
                if (oldList == null) {
                    toList.add(new DBNDatabaseFolder(this, (DBXTreeFolder)child));
                } else {
                    dBNDatabaseNodeArray = oldList;
                    n2 = oldList.length;
                    n = 0;
                    while (n < n2) {
                        DBNDatabaseNode oldFolder = dBNDatabaseNodeArray[n];
                        if (oldFolder.getMeta() == child) {
                            oldFolder.reloadChildren(monitor, reflect);
                            toList.add(oldFolder);
                            break;
                        }
                        ++n;
                    }
                }
            } else if (child instanceof DBXTreeObject) {
                if (oldList == null) {
                    toList.add(new DBNDatabaseObject(this, (DBXTreeObject)child));
                } else {
                    dBNDatabaseNodeArray = oldList;
                    n2 = oldList.length;
                    n = 0;
                    while (n < n2) {
                        DBNDatabaseNode oldObject = dBNDatabaseNodeArray[n];
                        if (oldObject.getMeta() == child) {
                            oldObject.reloadChildren(monitor, reflect);
                            toList.add(oldObject);
                            break;
                        }
                        ++n;
                    }
                }
            } else {
                log.warn("Unsupported meta node type: " + child);
            }
            monitor.worked(1);
        }
        monitor.done();
        if (reflect && this.filtered) {
            this.getModel().fireNodeUpdate(this, this, DBNEvent.NodeChange.REFRESH);
        }
    }

    private boolean loadTreeItems(DBRProgressMonitor monitor, DBXTreeItem meta, DBNDatabaseNode[] oldList, List<DBNDatabaseNode> toList, boolean reflect) throws DBException {
        if (this.isDisposed()) {
            return false;
        }
        Object valueObject = this.getValueObject();
        if (valueObject == null) {
            return false;
        }
        String propertyName = meta.getPropertyName();
        PropertyValueReader valueReader = new PropertyValueReader(monitor, propertyName, valueObject);
        DBUtils.tryExecuteRecover(monitor, this.getDataSource(), valueReader);
        Object propertyValue = valueReader.propertyValue;
        if (propertyValue == null) {
            return false;
        }
        if (!(propertyValue instanceof Collection)) {
            log.warn("Bad property '" + propertyName + "' value: " + propertyValue.getClass().getName());
            return false;
        }
        DBSObjectFilter filter = this.getNodeFilter(meta, false);
        this.filtered = filter != null && !filter.isNotApplicable();
        Collection itemList = (Collection)propertyValue;
        if (itemList.isEmpty()) {
            return false;
        }
        if (this.isDisposed()) {
            return false;
        }
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        boolean showSystem = dataSourceContainer == null || dataSourceContainer.isShowSystemObjects();
        for (Object childItem : itemList) {
            if (childItem == null) continue;
            if (!(childItem instanceof DBSObject)) {
                log.warn("Bad item type: " + childItem.getClass().getName());
                continue;
            }
            if (DBUtils.isHiddenObject(childItem) || !showSystem && childItem instanceof DBPSystemObject && ((DBPSystemObject)childItem).isSystem() || filter != null && !filter.matches(((DBSObject)childItem).getName())) continue;
            DBSObject object = (DBSObject)childItem;
            boolean added = false;
            if (oldList != null) {
                DBNDatabaseNode[] dBNDatabaseNodeArray = oldList;
                int n = oldList.length;
                int n2 = 0;
                while (n2 < n) {
                    DBNDatabaseNode oldChild = dBNDatabaseNodeArray[n2];
                    if (oldChild.getMeta() == meta && DBNDatabaseNode.equalObjects(oldChild.getObject(), object)) {
                        oldChild.reloadObject(monitor, object);
                        if (oldChild.hasChildren(false) && !oldChild.needsInitialization()) {
                            oldChild.reloadChildren(monitor, reflect);
                        }
                        if (reflect) {
                            this.getModel().fireNodeUpdate(this, oldChild, DBNEvent.NodeChange.REFRESH);
                        }
                        toList.add(oldChild);
                        added = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (added) continue;
            DBNDatabaseItem treeItem = new DBNDatabaseItem(this, meta, object, oldList != null);
            toList.add(treeItem);
        }
        if (oldList != null) {
            DBNDatabaseNode[] dBNDatabaseNodeArray = oldList;
            int n = oldList.length;
            int n3 = 0;
            while (n3 < n) {
                DBNDatabaseNode oldChild = dBNDatabaseNodeArray[n3];
                if (oldChild.getMeta() == meta) {
                    boolean found = false;
                    for (Object childItem : itemList) {
                        if (!(childItem instanceof DBSObject) || !DBNDatabaseNode.equalObjects(oldChild.getObject(), (DBSObject)childItem)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        oldChild.dispose(true);
                    }
                }
                ++n3;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public DBCExecutionContext getExecutionContext() {
        DBPDataSource dataSource = this.getDataSource();
        return dataSource == null ? null : dataSource.getDefaultContext(true);
    }

    @Override
    @NotNull
    public DBPDataSourceContainer getDataSourceContainer() {
        DBNNode p = this.getParentNode();
        while (p != null) {
            if (p instanceof DBNDataSource) {
                return ((DBNDataSource)p).getDataSourceContainer();
            }
            p = p.getParentNode();
        }
        throw new IllegalStateException("No parent datasource node");
    }

    public DBPDataSource getDataSource() {
        DBSObject object = this.getObject();
        return object == null ? null : object.getDataSource();
    }

    public DBSObjectFilter getNodeFilter(DBXTreeItem meta, boolean firstMatch) {
        Class<?> childrenClass;
        DBPDataSourceContainer dataSource = this.getDataSourceContainer();
        if (dataSource != null && this instanceof DBNContainer && (childrenClass = this.getChildrenClass(meta)) != null) {
            Object valueObject = this.getValueObject();
            DBSObject parentObject = null;
            if (valueObject instanceof DBSObject && !(valueObject instanceof DBPDataSource)) {
                parentObject = (DBSObject)valueObject;
            }
            return dataSource.getObjectFilter(childrenClass, parentObject, firstMatch);
        }
        return null;
    }

    public void setNodeFilter(DBXTreeItem meta, DBSObjectFilter filter) {
        DBPDataSourceContainer dataSource = this.getDataSourceContainer();
        if (dataSource != null && this instanceof DBNContainer) {
            Class<?> childrenClass = this.getChildrenClass(meta);
            if (childrenClass != null) {
                Object parentObject = this.getValueObject();
                if (parentObject instanceof DBPDataSource) {
                    parentObject = null;
                }
                dataSource.setObjectFilter(this.getChildrenClass(meta), (DBSObject)parentObject, filter);
                dataSource.persistConfiguration();
            }
        } else {
            log.error("No active datasource - can't save filter configuration");
        }
    }

    @Override
    public boolean isFiltered() {
        return this.filtered;
    }

    @Override
    public String getNodeItemPath() {
        StringBuilder pathName = new StringBuilder(100);
        DBNNode node = this;
        while (node instanceof DBNDatabaseNode) {
            if (node instanceof DBNDataSource) {
                if (pathName.length() > 0) {
                    pathName.insert(0, '/');
                }
                pathName.insert(0, ((DBNDataSource)node).getDataSourceContainer().getId());
            } else if (node instanceof DBNDatabaseFolder) {
                String type;
                if (pathName.length() > 0) {
                    pathName.insert(0, '/');
                }
                if (CommonUtils.isEmpty((String)(type = ((DBNDatabaseFolder)node).getMeta().getType()))) {
                    type = node.getName();
                }
                pathName.insert(0, type);
            }
            if (node instanceof DBNDatabaseItem || node instanceof DBNDatabaseObject) {
                if (pathName.length() > 0) {
                    pathName.insert(0, '/');
                }
                pathName.insert(0, node.getNodeName().replace('/', '_'));
            }
            node = node.getParentNode();
        }
        pathName.insert(0, DBNNode.NodePathType.database.getPrefix());
        return pathName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadChildren(DBRProgressMonitor monitor, boolean reflect) throws DBException {
        DBNDatabaseNode[] oldChildren;
        DBNDatabaseNode dBNDatabaseNode = this;
        synchronized (dBNDatabaseNode) {
            if (this.childNodes == null) {
                return;
            }
            oldChildren = Arrays.copyOf(this.childNodes, this.childNodes.length);
        }
        ArrayList<DBNDatabaseNode> newChildren = new ArrayList<DBNDatabaseNode>();
        this.loadChildren(monitor, this.getMeta(), oldChildren, newChildren, reflect);
        DBNDatabaseNode dBNDatabaseNode2 = this;
        synchronized (dBNDatabaseNode2) {
            this.childNodes = newChildren.toArray(new DBNDatabaseNode[newChildren.size()]);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean equalObjects(DBSObject object1, DBSObject object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 != null && object2 != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (object1.getClass() != object2.getClass() || !CommonUtils.equalObjects((Object)DBUtils.getObjectUniqueName(object1), (Object)DBUtils.getObjectUniqueName(object2))) {
                return false;
            }
            object1 = object1.getParentObject();
            object2 = object2.getParentObject();
lbl9:
            // 2 sources

            ** while (object1 != null && object2 != null)
        }
lbl10:
        // 1 sources

        return true;
    }

    public abstract Object getValueObject();

    public abstract DBXTreeNode getMeta();

    public DBXTreeItem getItemsMeta() {
        List<DBXTreeNode> metaChildren = this.getMeta().getChildren(this);
        if (metaChildren != null && metaChildren.size() == 1 && metaChildren.get(0) instanceof DBXTreeItem) {
            return (DBXTreeItem)metaChildren.get(0);
        }
        return null;
    }

    protected abstract void reloadObject(DBRProgressMonitor var1, DBSObject var2);

    public List<Class<?>> getChildrenTypes(DBXTreeNode useMeta) {
        List<DBXTreeNode> childMetas;
        List<DBXTreeNode> list = childMetas = useMeta == null ? this.getMeta().getChildren(this) : Collections.singletonList(useMeta);
        if (CommonUtils.isEmpty(childMetas)) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (DBXTreeNode childMeta : childMetas) {
            Class<?> childrenType;
            if (!(childMeta instanceof DBXTreeItem) || (childrenType = this.getChildrenClass((DBXTreeItem)childMeta)) == null) continue;
            result.add(childrenType);
        }
        return result;
    }

    protected Class<?> getChildrenClass(DBXTreeItem childMeta) {
        Object valueObject = this.getValueObject();
        if (valueObject == null) {
            return null;
        }
        String propertyName = childMeta.getPropertyName();
        Method getter = DBNDatabaseNode.findPropertyReadMethod(valueObject.getClass(), propertyName);
        if (getter == null) {
            return null;
        }
        Type propType = getter.getGenericReturnType();
        return BeanUtils.getCollectionType((Type)propType);
    }

    public IProject getOwnerProject() {
        DBNNode node = this.getParentNode();
        while (node != null) {
            if (node instanceof DBNProject) {
                return ((DBNProject)node).getProject();
            }
            node = node.getParentNode();
        }
        return null;
    }

    private static Object extractPropertyValue(DBRProgressMonitor monitor, Object object, String propertyName) throws DBException {
        Method getter;
        block8: {
            if (object == null) {
                return null;
            }
            getter = DBNDatabaseNode.findPropertyReadMethod(object.getClass(), propertyName);
            if (getter != null) break block8;
            log.warn("Can't find property '" + propertyName + "' read method in '" + object.getClass().getName() + "'");
            return null;
        }
        try {
            Class<?>[] paramTypes = getter.getParameterTypes();
            if (paramTypes.length == 0) {
                return getter.invoke(object, new Object[0]);
            }
            if (paramTypes.length == 1 && paramTypes[0] == DBRProgressMonitor.class) {
                return getter.invoke(object, monitor);
            }
            log.warn("Can't read property '" + propertyName + "' - bad method signature: " + getter.toString());
            return null;
        }
        catch (IllegalAccessException ex) {
            log.warn("Error accessing items " + propertyName, ex);
            return null;
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof DBException) {
                throw (DBException)ex.getTargetException();
            }
            throw new DBException("Can't read " + propertyName, ex.getTargetException());
        }
    }

    public static Method findPropertyReadMethod(Class<?> clazz, String propertyName) {
        String methodName = BeanUtils.propertyNameToMethodName((String)propertyName);
        return DBNDatabaseNode.findPropertyGetter(clazz, "get" + methodName, "is" + methodName);
    }

    private static Method findPropertyGetter(Class<?> clazz, String getName, String isName) {
        Method[] methods;
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameterTypes;
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) && !method.getReturnType().equals(Void.TYPE) && (method.getName().equals(getName) || method.getName().equals(isName) && method.getReturnType().equals(Boolean.TYPE)) && ((parameterTypes = method.getParameterTypes()).length == 0 || parameterTypes.length == 1 && parameterTypes[0] == DBRProgressMonitor.class)) {
                return method;
            }
            ++n2;
        }
        return clazz == Object.class ? null : DBNDatabaseNode.findPropertyGetter(clazz.getSuperclass(), getName, isName);
    }

    private static class PropertyValueReader
    implements DBRRunnableWithProgress {
        private final DBRProgressMonitor monitor;
        private final String propertyName;
        private final Object valueObject;
        private Object propertyValue;

        PropertyValueReader(DBRProgressMonitor monitor, String propertyName, Object valueObject) {
            this.monitor = monitor;
            this.propertyName = propertyName;
            this.valueObject = valueObject;
        }

        @Override
        public void run(DBRProgressMonitor param) throws InvocationTargetException, InterruptedException {
            try {
                this.propertyValue = DBNDatabaseNode.extractPropertyValue(this.monitor, this.valueObject, this.propertyName);
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

