/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSActionTiming;
import org.jkiss.dbeaver.model.struct.rdb.DBSManipulationType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;

public abstract class AbstractTrigger
implements DBSTrigger,
DBPQualifiedObject,
DBPSaveableObject {
    protected String name;
    private DBSActionTiming actionTiming;
    private DBSManipulationType manipulationType;
    private String description;
    private boolean persisted;

    protected AbstractTrigger(boolean persisted) {
        this.persisted = persisted;
    }

    protected AbstractTrigger(String name, String description, boolean persisted) {
        this.name = name;
        this.description = description;
        this.persisted = persisted;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    protected void setName(String tableName) {
        this.name = tableName;
    }

    @Property(viewable=true, editable=true, order=2, listProvider=TriggerTimingListProvider.class)
    public DBSActionTiming getActionTiming() {
        return this.actionTiming;
    }

    public void setActionTiming(DBSActionTiming actionTiming) {
        this.actionTiming = actionTiming;
    }

    @Property(viewable=true, editable=true, order=3, listProvider=TriggerTypeListProvider.class)
    public DBSManipulationType getManipulationType() {
        return this.manipulationType;
    }

    public void setManipulationType(DBSManipulationType manipulationType) {
        this.manipulationType = manipulationType;
    }

    @Override
    @Property(viewable=true, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public static class TriggerTimingListProvider
    implements IPropertyValueListProvider {
        @Override
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(Object object) {
            return new Object[]{DBSActionTiming.BEFORE, DBSActionTiming.AFTER};
        }
    }

    public static class TriggerTypeListProvider
    implements IPropertyValueListProvider {
        @Override
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(Object object) {
            return new Object[]{DBSManipulationType.INSERT, DBSManipulationType.UPDATE, DBSManipulationType.DELETE};
        }
    }
}

