/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class SQLTableManager<OBJECT_TYPE extends JDBCTable, CONTAINER_TYPE extends DBSObjectContainer>
extends SQLStructEditor<OBJECT_TYPE, CONTAINER_TYPE> {
    private static final String BASE_TABLE_NAME = "NewTable";

    @Override
    public long getMakerOptions(DBPDataSource dataSource) {
        long options = 4L;
        if (dataSource instanceof SQLDataSource && ((SQLDataSource)dataSource).getSQLDialect().supportsTableDropCascade()) {
            options |= 8L;
        }
        return options;
    }

    @Override
    protected final void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand objectChangeCommand, Map<String, Object> options) {
        throw new IllegalStateException("addObjectCreateActions should never be called in struct editor");
    }

    @Override
    protected void addStructObjectCreateActions(List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) {
        JDBCTable table = (JDBCTable)command.getObject();
        SQLObjectEditor.NestedObjectCommand tableProps = command.getObjectCommands().get(table);
        if (tableProps == null) {
            log.warn("Object change command not found");
            return;
        }
        String tableName = CommonUtils.getOption(options, (String)"useFQN", (boolean)true) ? table.getFullyQualifiedName(DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier(table);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder createQuery = new StringBuilder(100);
        createQuery.append("CREATE TABLE ").append(tableName).append(" (").append(lineSeparator);
        boolean hasNestedDeclarations = false;
        Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands = this.getNestedOrderedCommands(command);
        for (SQLObjectEditor.NestedObjectCommand nestedCommand : orderedCommands) {
            if (nestedCommand.getObject() == table || this.excludeFromDDL(nestedCommand, orderedCommands)) continue;
            String nestedDeclaration = nestedCommand.getNestedDeclaration(table, options);
            if (!CommonUtils.isEmpty((String)nestedDeclaration)) {
                if (hasNestedDeclarations) {
                    createQuery.append(",").append(lineSeparator);
                }
                createQuery.append("\t").append(nestedDeclaration);
                hasNestedDeclarations = true;
                continue;
            }
            DBEPersistAction[] nestedActions = nestedCommand.getPersistActions(options);
            if (nestedActions == null) continue;
            Collections.addAll(actions, nestedActions);
        }
        createQuery.append(lineSeparator).append(")");
        this.appendTableModifiers(table, tableProps, createQuery);
        actions.add(0, new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, createQuery.toString()));
    }

    protected boolean excludeFromDDL(SQLObjectEditor.NestedObjectCommand command, Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands) {
        return false;
    }

    @Override
    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        JDBCTable object = (JDBCTable)command.getObject();
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + (object.isView() ? "VIEW" : "TABLE") + " " + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + (!object.isView() && CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }

    protected void appendTableModifiers(OBJECT_TYPE table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl) {
    }

    protected void setTableName(DBRProgressMonitor monitor, CONTAINER_TYPE container, OBJECT_TYPE table) throws DBException {
        ((AbstractTable)table).setName(this.getNewChildName(monitor, container));
    }

    protected String getNewChildName(DBRProgressMonitor monitor, CONTAINER_TYPE container) throws DBException {
        return this.getNewChildName(monitor, container, BASE_TABLE_NAME);
    }

    protected String getNewChildName(DBRProgressMonitor monitor, CONTAINER_TYPE container, String baseName) throws DBException {
        int i = 0;
        String tableName;
        DBSObject child;
        while ((child = container.getChild(monitor, tableName = DBObjectNameCaseTransformer.transformName(container.getDataSource(), i == 0 ? baseName : String.valueOf(baseName) + "_" + i))) != null) {
            ++i;
        }
        return tableName;
    }

    public DBEPersistAction[] getTableDDL(DBRProgressMonitor monitor, OBJECT_TYPE table, Map<String, Object> options) throws DBException {
        DBERegistry editorsRegistry = ((AbstractTable)table).getDataSource().getContainer().getPlatform().getEditorsRegistry();
        SQLObjectEditor<DBSEntityAttribute, DBSEntityAttribute> tcm = this.getObjectEditor(editorsRegistry, DBSEntityAttribute.class);
        SQLObjectEditor<DBSTableConstraint, DBSTableConstraint> pkm = this.getObjectEditor(editorsRegistry, DBSTableConstraint.class);
        SQLObjectEditor<DBSTableForeignKey, DBSTableForeignKey> fkm = this.getObjectEditor(editorsRegistry, DBSTableForeignKey.class);
        SQLObjectEditor<DBSTableIndex, DBSTableIndex> im = this.getObjectEditor(editorsRegistry, DBSTableIndex.class);
        SQLObjectEditor.ObjectCreateCommand command = this.makeCreateCommand((DBSObject)table);
        if (tcm != null) {
            for (DBSEntityAttribute column : CommonUtils.safeCollection(table.getAttributes(monitor))) {
                if (DBUtils.isHiddenObject(column)) continue;
                ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(tcm.makeCreateCommand(column));
            }
        }
        if (pkm != null) {
            try {
                for (DBSTableConstraint constraint : CommonUtils.safeCollection(table.getConstraints(monitor))) {
                    if (DBUtils.isHiddenObject(constraint)) continue;
                    ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(pkm.makeCreateCommand(constraint));
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        if (fkm != null) {
            try {
                for (DBSEntityAssociation foreignKey : CommonUtils.safeCollection(table.getAssociations(monitor))) {
                    if (!(foreignKey instanceof DBSTableForeignKey) || DBUtils.isHiddenObject(foreignKey)) continue;
                    ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(fkm.makeCreateCommand((DBSTableForeignKey)foreignKey));
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        if (im != null) {
            try {
                for (DBSTableIndex index : CommonUtils.safeCollection(table.getIndexes(monitor))) {
                    if (DBUtils.isHiddenObject(index)) continue;
                    ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(im.makeCreateCommand(index));
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        return ((SQLStructEditor.StructCreateCommand)command).getPersistActions(options);
    }
}

