/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableIndex;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.utils.CommonUtils;

public abstract class SQLIndexManager<OBJECT_TYPE extends JDBCTableIndex<? extends DBSObjectContainer, TABLE_TYPE>, TABLE_TYPE extends JDBCTable>
extends SQLObjectEditor<OBJECT_TYPE, TABLE_TYPE> {
    @Override
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Override
    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        DBSTable table = ((JDBCTableIndex)command.getObject()).getTable();
        JDBCTableIndex index = (JDBCTableIndex)command.getObject();
        String indexName = DBUtils.getQuotedIdentifier(index.getDataSource(), index.getName());
        index.setName(indexName);
        String tableName = CommonUtils.getOption(options, (String)"useFQN", (boolean)true) ? table.getFullyQualifiedName(DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier(table);
        StringBuilder decl = new StringBuilder(40);
        decl.append("CREATE");
        this.appendIndexModifiers(index, decl);
        decl.append(" INDEX ").append(indexName);
        this.appendIndexType(index, decl);
        decl.append(" ON ").append(tableName).append(" (");
        try {
            boolean firstColumn = true;
            for (DBSTableIndexColumn indexColumn : CommonUtils.safeCollection(((JDBCTableIndex)command.getObject()).getAttributeReferences(new VoidProgressMonitor()))) {
                if (!firstColumn) {
                    decl.append(",");
                }
                firstColumn = false;
                decl.append(DBUtils.getQuotedIdentifier(indexColumn));
                this.appendIndexColumnModifiers(decl, indexColumn);
            }
        }
        catch (DBException e) {
            log.error(e);
        }
        decl.append(")");
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_index, decl.toString()));
    }

    protected void appendIndexType(OBJECT_TYPE index, StringBuilder decl) {
    }

    protected void appendIndexModifiers(OBJECT_TYPE index, StringBuilder decl) {
        if (index.isUnique()) {
            decl.append(" UNIQUE");
        }
    }

    protected void appendIndexColumnModifiers(StringBuilder decl, DBSTableIndexColumn indexColumn) {
        if (!indexColumn.isAscending()) {
            decl.append(" DESC");
        }
    }

    @Override
    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_index, this.getDropIndexPattern((JDBCTableIndex)command.getObject()).replace("%TABLE%", ((JDBCTableIndex)command.getObject()).getTable().getFullyQualifiedName(DBPEvaluationContext.DDL)).replace("%INDEX%", ((JDBCTableIndex)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)).replace("%INDEX_SHORT%", ((JDBCTableIndex)command.getObject()).getName())));
    }

    protected String getDropIndexPattern(OBJECT_TYPE index) {
        return "DROP INDEX %INDEX%";
    }
}

