/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class SQLConstraintManager<OBJECT_TYPE extends JDBCTableConstraint<TABLE_TYPE>, TABLE_TYPE extends JDBCTable>
extends SQLObjectEditor<OBJECT_TYPE, TABLE_TYPE> {
    @Override
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Override
    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        JDBCTable table = (JDBCTable)((JDBCTableConstraint)command.getObject()).getTable();
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_constraint, "ALTER TABLE " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD " + this.getNestedDeclaration((TABLE_TYPE)table, (DBECommandAbstract<OBJECT_TYPE>)command, options)));
    }

    @Override
    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_constraint, this.getDropConstraintPattern((JDBCTableConstraint)command.getObject()).replace("%TABLE%", ((JDBCTable)((JDBCTableConstraint)command.getObject()).getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL)).replace("%CONSTRAINT%", DBUtils.getQuotedIdentifier((DBSObject)command.getObject()))));
    }

    @Override
    public StringBuilder getNestedDeclaration(TABLE_TYPE owner, DBECommandAbstract<OBJECT_TYPE> command, Map<String, Object> options) {
        JDBCTableConstraint constraint = (JDBCTableConstraint)command.getObject();
        String constraintName = DBUtils.getQuotedIdentifier(constraint.getDataSource(), constraint.getName());
        boolean legacySyntax = this.isLegacyConstraintsSyntax(owner);
        StringBuilder decl = new StringBuilder(40);
        if (!legacySyntax || !constraint.isPersisted()) {
            decl.append("CONSTRAINT ");
        }
        if (!legacySyntax) {
            decl.append(constraintName).append(" ");
        }
        decl.append(this.getAddConstraintTypeClause(constraint));
        this.appendConstraintDefinition(decl, command);
        if (legacySyntax) {
            decl.append(" CONSTRAINT ").append(constraintName);
        }
        return decl;
    }

    protected void appendConstraintDefinition(StringBuilder decl, DBECommandAbstract<OBJECT_TYPE> command) {
        decl.append(" (");
        try {
            List<? extends DBSEntityAttributeRef> attrs = ((JDBCTableConstraint)command.getObject()).getAttributeReferences(new VoidProgressMonitor());
            if (attrs != null) {
                boolean firstColumn = true;
                for (DBSEntityAttributeRef dBSEntityAttributeRef : attrs) {
                    DBSEntityAttribute attribute = dBSEntityAttributeRef.getAttribute();
                    if (attribute == null) continue;
                    if (!firstColumn) {
                        decl.append(",");
                    }
                    firstColumn = false;
                    decl.append(DBUtils.getQuotedIdentifier(attribute));
                }
            }
        }
        catch (DBException e) {
            log.warn("Can't obtain attribute references", e);
        }
        decl.append(")");
    }

    @NotNull
    protected String getAddConstraintTypeClause(OBJECT_TYPE constraint) {
        return ((AbstractTableConstraint)constraint).getConstraintType().getName().toUpperCase(Locale.ENGLISH);
    }

    protected String getDropConstraintPattern(OBJECT_TYPE constraint) {
        return "ALTER TABLE %TABLE% DROP CONSTRAINT %CONSTRAINT%";
    }

    protected boolean isLegacyConstraintsSyntax(TABLE_TYPE owner) {
        return false;
    }
}

