/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;

public abstract class JDBCTableForeignKey<TABLE extends JDBCTable, PRIMARY_KEY extends DBSEntityReferrer>
extends JDBCTableConstraint<TABLE>
implements DBSTableForeignKey {
    @Nullable
    protected PRIMARY_KEY referencedKey;
    protected DBSForeignKeyModifyRule deleteRule;
    protected DBSForeignKeyModifyRule updateRule;

    public JDBCTableForeignKey(@NotNull TABLE table, @NotNull String name, @Nullable String description, @Nullable PRIMARY_KEY referencedKey, DBSForeignKeyModifyRule deleteRule, DBSForeignKeyModifyRule updateRule, boolean persisted) {
        super(table, name, description, DBSEntityConstraintType.FOREIGN_KEY, persisted);
        this.referencedKey = referencedKey;
        this.deleteRule = deleteRule;
        this.updateRule = updateRule;
    }

    public JDBCTableForeignKey(@NotNull DBRProgressMonitor monitor, @NotNull TABLE table, @NotNull DBSEntityAssociation source, boolean persisted) throws DBException {
        super(table, source, persisted);
        DBSEntity refEntity;
        DBSEntityConstraint srcRefConstraint = source.getReferencedConstraint();
        if (srcRefConstraint != null && (refEntity = srcRefConstraint.getParentObject()) != null) {
            if (srcRefConstraint instanceof JDBCTableConstraint && refEntity.getParentObject() == ((AbstractTable)table).getParentObject()) {
                this.referencedKey = (DBSEntityReferrer)srcRefConstraint;
            } else {
                DBSObject refTable = ((AbstractTable)table).getContainer().getChild(monitor, refEntity.getName());
                if (refTable instanceof DBSEntity) {
                    List<DBSEntityAttribute> refAttrs = DBUtils.getEntityAttributes(monitor, this.referencedKey);
                    this.referencedKey = (DBSEntityReferrer)DBUtils.findEntityConstraint(monitor, (DBSEntity)refTable, refAttrs);
                }
            }
        }
        if (source instanceof DBSTableForeignKey) {
            this.deleteRule = ((DBSTableForeignKey)source).getDeleteRule();
            this.updateRule = ((DBSTableForeignKey)source).getUpdateRule();
        } else {
            this.deleteRule = DBSForeignKeyModifyRule.NO_ACTION;
            this.updateRule = DBSForeignKeyModifyRule.NO_ACTION;
        }
    }

    @Property(viewable=true, order=3)
    @Nullable
    public TABLE getReferencedTable() {
        return (TABLE)(this.referencedKey == null ? null : (JDBCTable)this.referencedKey.getParentObject());
    }

    @Property(id="reference", viewable=true, order=4)
    @Nullable
    public PRIMARY_KEY getReferencedConstraint() {
        return this.referencedKey;
    }

    @Override
    @Property(viewable=true, editable=true, listProvider=ConstraintModifyRuleListProvider.class, order=5)
    @NotNull
    public DBSForeignKeyModifyRule getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(DBSForeignKeyModifyRule deleteRule) {
        this.deleteRule = deleteRule;
    }

    @Override
    @Property(viewable=true, editable=true, listProvider=ConstraintModifyRuleListProvider.class, order=6)
    @NotNull
    public DBSForeignKeyModifyRule getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(DBSForeignKeyModifyRule updateRule) {
        this.updateRule = updateRule;
    }

    public TABLE getAssociatedEntity() {
        return this.getReferencedTable();
    }

    public static class ConstraintModifyRuleListProvider
    implements IPropertyValueListProvider<JDBCTableForeignKey> {
        @Override
        public boolean allowCustomValue() {
            return false;
        }

        @Override
        public Object[] getPossibleValues(JDBCTableForeignKey foreignKey) {
            return new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT};
        }
    }
}

