/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractExecutionContext<DATASOURCE extends DBPDataSource>
implements DBCExecutionContext {
    private static final Log log = Log.getLog(AbstractExecutionContext.class);
    private static long idSequence = 0L;
    @NotNull
    protected final DATASOURCE dataSource;
    protected final String purpose;
    protected final long id;

    public AbstractExecutionContext(@NotNull DATASOURCE dataSource, String purpose) {
        this.dataSource = dataSource;
        this.purpose = purpose;
        this.id = AbstractExecutionContext.generateContextId();
    }

    public static synchronized long generateContextId() {
        return idSequence++;
    }

    @Override
    public long getContextId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getContextName() {
        return this.purpose;
    }

    @NotNull
    public DATASOURCE getDataSource() {
        return this.dataSource;
    }

    protected void initContextBootstrap(@NotNull DBRProgressMonitor monitor, boolean autoCommit) throws DBCException {
        QMUtils.getDefaultHandler().handleContextOpen(this, !autoCommit);
        DBPConnectionBootstrap bootstrap = this.dataSource.getContainer().getConnectionConfiguration().getBootstrap();
        List<String> initQueries = bootstrap.getInitQueries();
        if (!CommonUtils.isEmpty(initQueries)) {
            monitor.subTask("Run bootstrap queries");
            Throwable throwable = null;
            Object var6_7 = null;
            try (DBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Run bootstrap queries");){
                for (String query : initQueries) {
                    query = GeneralUtils.replaceVariables(query, this.getDataSource().getContainer().getVariablesResolver());
                    try {
                        Throwable throwable2 = null;
                        Object var11_15 = null;
                        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.SCRIPT, query, false, false, false);){
                            dbStat.executeStatement();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        String message = "Error executing bootstrap query: " + query;
                        if (bootstrap.isIgnoreErrors()) {
                            log.warn(message);
                            continue;
                        }
                        throw new DBCException(message, e, (DBPDataSource)this.dataSource);
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    protected void closeContext() {
        QMUtils.getDefaultHandler().handleContextClose(this);
    }

    public String toString() {
        String dsName = this.dataSource instanceof DBPNamedObject ? this.dataSource.getName() : this.dataSource.toString();
        return String.valueOf(dsName) + " - " + this.purpose;
    }
}

