/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreArrayValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreBitStringValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreGeometryValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreHStoreValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreJSONValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreRefCursorValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreStructValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgresMoneyValueHandler;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDPreferences;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreValueHandlerProvider
implements DBDValueHandlerProvider {
    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDPreferences preferences, DBSTypedObject typedObject) {
        int typeID = typedObject.getTypeID();
        if (typeID == 2003) {
            return PostgreArrayValueHandler.INSTANCE;
        }
        if (typeID == 2002) {
            return PostgreStructValueHandler.INSTANCE;
        }
        switch (typedObject.getTypeName()) {
            case "json": 
            case "jsonb": {
                return PostgreJSONValueHandler.INSTANCE;
            }
            case "hstore": {
                return PostgreHStoreValueHandler.INSTANCE;
            }
            case "bit": {
                return PostgreBitStringValueHandler.INSTANCE;
            }
            case "refcursor": {
                return PostgreRefCursorValueHandler.INSTANCE;
            }
            case "money": {
                return PostgresMoneyValueHandler.INSTANCE;
            }
            case "geometry": {
                return PostgreGeometryValueHandler.INSTANCE;
            }
        }
        return null;
    }
}

