/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermission;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePermission;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;

public abstract class PostgreTableBase
extends JDBCTable<PostgreDataSource, PostgreSchema>
implements PostgreClass,
PostgreScriptObject,
PostgrePermissionsOwner,
DBPNamedObject2 {
    private long oid;
    private long ownerId;
    private String description;
    private boolean isPartition;

    protected PostgreTableBase(PostgreSchema catalog) {
        super((DBSObjectContainer)catalog, false);
    }

    protected PostgreTableBase(PostgreSchema catalog, ResultSet dbResult) {
        super((DBSObjectContainer)catalog, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname"), true);
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relowner");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.isPartition = ((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(10, 0) && JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"relispartition");
    }

    public PostgreTableBase(PostgreSchema container, DBSEntity source, boolean persisted) {
        super((DBSObjectContainer)container, source, persisted);
        if (source instanceof PostgreTableBase) {
            this.description = ((PostgreTableBase)source).description;
            this.isPartition = ((PostgreTableBase)source).isPartition;
        }
    }

    public JDBCStructCache<PostgreSchema, ? extends PostgreClass, ? extends PostgreAttribute> getCache() {
        return ((PostgreSchema)this.getContainer()).tableCache;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreSchema)this.getContainer()).getDatabase();
    }

    @Override
    @Property(viewable=true, editable=false, updatable=false, order=9)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, editable=true, updatable=true, order=11)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Property(viewable=true, editable=false, updatable=false, order=10)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return (PostgreRole)PostgreUtils.getObjectById(monitor, this.getDatabase().roleCache, this.getDatabase(), this.ownerId);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @NotNull
    public PostgreSchema getSchema() {
        DBSObject parentObject = super.getParentObject();
        assert (parentObject != null);
        return (PostgreSchema)parentObject;
    }

    public Collection<PostgreTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((PostgreSchema)this.getContainer()).tableCache.getChildren(monitor, (PostgreSchema)this.getContainer(), this);
    }

    public List<PostgreTableColumn> getCachedAttributes() {
        DBSObjectCache childrenCache = ((PostgreSchema)this.getContainer()).tableCache.getChildrenCache(this);
        if (childrenCache != null) {
            return childrenCache.getCachedObjects();
        }
        return Collections.emptyList();
    }

    public PostgreTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (PostgreTableColumn)((PostgreSchema)this.getContainer()).tableCache.getChild(monitor, (PostgreSchema)this.getContainer(), this, attributeName);
    }

    public Collection<PostgreTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public PostgreTableConstraintBase getConstraint(@NotNull DBRProgressMonitor monitor, String ukName) throws DBException {
        return null;
    }

    @Association
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Association
    public synchronized Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((PostgreSchema)this.getContainer()).constraintCache.clearObjectCache(this);
        ((PostgreSchema)this.getContainer()).indexCache.clearObjectCache(this);
        return ((PostgreSchema)this.getContainer()).tableCache.refreshObject(monitor, (PostgreSchema)this.getContainer(), this);
    }

    @Override
    public Collection<PostgrePermission> getPermissions(DBRProgressMonitor monitor) throws DBException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read table privileges");
            try {
                ArrayList<PostgrePermission> arrayList;
                JDBCPreparedStatement dbStat;
                block36: {
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    dbStat = session.prepareStatement(this instanceof PostgreSequence ? "SELECT * FROM information_schema.usage_privileges WHERE object_catalog=? AND object_schema=? AND object_name=? AND object_type='SEQUENCE'" : "SELECT * FROM information_schema.table_privileges WHERE table_catalog=? AND table_schema=? AND table_name=?");
                    dbStat.setString(1, this.getDatabase().getName());
                    dbStat.setString(2, this.getSchema().getName());
                    dbStat.setString(3, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    JDBCResultSet dbResult = dbStat.executeQuery();
                    try {
                        LinkedHashMap<String, ArrayList<PostgrePrivilege>> privs = new LinkedHashMap<String, ArrayList<PostgrePrivilege>>();
                        while (dbResult.next()) {
                            PostgrePrivilege privilege = new PostgrePrivilege((ResultSet)dbResult);
                            ArrayList<PostgrePrivilege> privList = (ArrayList<PostgrePrivilege>)privs.get(privilege.getGrantee());
                            if (privList == null) {
                                privList = new ArrayList<PostgrePrivilege>();
                                privs.put(privilege.getGrantee(), privList);
                            }
                            privList.add(privilege);
                        }
                        ArrayList<PostgrePermission> result = new ArrayList<PostgrePermission>(privs.size());
                        for (List priv : privs.values()) {
                            result.add(new PostgreTablePermission(this, ((PostgrePrivilege)priv.get(0)).getGrantee(), priv));
                        }
                        Collections.sort(result);
                        arrayList = result;
                        if (dbResult == null) break block36;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                if (throwable3 == null) {
                                    throwable3 = throwable5;
                                } else if (throwable3 != throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable6) {
                                try {
                                    if (dbStat != null) {
                                        dbStat.close();
                                    }
                                    throw throwable6;
                                }
                                catch (Throwable throwable7) {
                                    try {
                                        if (throwable2 == null) {
                                            throwable2 = throwable7;
                                        } else if (throwable2 != throwable7) {
                                            throwable2.addSuppressed(throwable7);
                                        }
                                        throw throwable2;
                                    }
                                    catch (SQLException e) {
                                        throw new DBException((Throwable)e, this.getDataSource());
                                    }
                                }
                            }
                        }
                    }
                    dbResult.close();
                }
                if (dbStat != null) {
                    dbStat.close();
                }
                if (session != null) {
                    session.close();
                }
                return arrayList;
            }
            catch (Throwable throwable8) {
                if (session != null) {
                    session.close();
                }
                throw throwable8;
            }
        }
        catch (Throwable throwable9) {
            if (throwable == null) {
                throwable = throwable9;
            } else if (throwable != throwable9) {
                throwable.addSuppressed(throwable9);
            }
            throw throwable;
        }
    }

    public boolean isPartition() {
        return this.isPartition;
    }
}

