/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractProcedure;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreProcedure
extends AbstractProcedure<PostgreDataSource, PostgreSchema>
implements PostgreObject,
PostgreScriptObject,
DBPUniqueObject,
DBPOverloadedObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(PostgreProcedure.class);
    private static final String CAT_FLAGS = "Flags";
    private static final String CAT_PROPS = "Properties";
    private static final String CAT_STATS = "Statistics";
    private long oid;
    private String procSrc;
    private String body;
    private long ownerId;
    private long languageId;
    private float execCost;
    private float estRows;
    private PostgreDataType varArrayType;
    private String procTransform;
    private boolean isAggregate;
    private boolean isWindow;
    private boolean isSecurityDefiner;
    private boolean leakproof;
    private boolean isStrict;
    private boolean returnsSet;
    private ProcedureVolatile procVolatile;
    private PostgreDataType returnType;
    private Object[] argDefaults;
    private int[] transformTypes;
    private String[] config;
    private String overloadedName;
    private List<PostgreProcedureParameter> params = new ArrayList<PostgreProcedureParameter>();

    public PostgreProcedure(PostgreSchema schema) {
        super((DBSObjectContainer)schema, false);
    }

    public PostgreProcedure(PostgreSchema schema, ResultSet dbResult) {
        super((DBSObjectContainer)schema, true);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proname"));
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"proowner");
        this.languageId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"prolang");
        this.execCost = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"procost");
        this.estRows = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"prorows");
        Object[] allArgTypes = (Long[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"proallargtypes");
        String[] argNames = (String[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"proargnames");
        if (!ArrayUtils.isEmpty((Object[])allArgTypes)) {
            String[] argModes = (String[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"proargmodes");
            int i = 0;
            while (i < allArgTypes.length) {
                Object paramType = allArgTypes[i];
                PostgreDataType dataType = ((PostgreSchema)this.container).getDatabase().getDataType(((Long)paramType).intValue());
                if (dataType == null) {
                    log.warn((Object)("Parameter data type [" + paramType + "] not found"));
                } else {
                    String paramName = argNames == null || argNames.length < allArgTypes.length ? "$" + (i + 1) : argNames[i];
                    ArgumentMode mode = ArgumentMode.i;
                    if (argModes != null && argModes.length == allArgTypes.length) {
                        try {
                            mode = ArgumentMode.valueOf(argModes[i]);
                        }
                        catch (IllegalArgumentException e) {
                            log.debug((Object)e);
                        }
                    }
                    PostgreProcedureParameter param = new PostgreProcedureParameter(this, paramName, dataType, mode == null ? DBSProcedureParameterKind.IN : mode.getParameterKind(), i + 1);
                    this.params.add(param);
                }
                ++i;
            }
        } else {
            long[] inArgTypes = PostgreUtils.getIdVector(JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"proargtypes"));
            if (!ArrayUtils.isEmpty((long[])inArgTypes)) {
                int i = 0;
                while (i < inArgTypes.length) {
                    Long paramType = inArgTypes[i];
                    PostgreDataType dataType = ((PostgreSchema)this.container).getDatabase().getDataType(paramType.intValue());
                    if (dataType == null) {
                        log.warn((Object)("Parameter data type [" + paramType + "] not found"));
                    } else {
                        String paramName = argNames == null || argNames.length < inArgTypes.length ? "$" + (i + 1) : argNames[i];
                        PostgreProcedureParameter param = new PostgreProcedureParameter(this, paramName, dataType, DBSProcedureParameterKind.IN, i + 1);
                        this.params.add(param);
                    }
                    ++i;
                }
            }
        }
        this.overloadedName = this.makeOverloadedName(false);
        long varTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"provariadic");
        if (varTypeId != 0L) {
            this.varArrayType = ((PostgreSchema)this.container).getDatabase().getDataType(varTypeId);
        }
        this.procTransform = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"protransform");
        this.isAggregate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proisagg");
        this.isWindow = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proiswindow");
        this.isSecurityDefiner = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"prosecdef");
        this.leakproof = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proleakproof");
        this.isStrict = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proisstrict");
        this.returnsSet = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proretset");
        try {
            this.procVolatile = ProcedureVolatile.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"provolatile"));
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)e);
        }
        long retTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"prorettype");
        if (retTypeId != 0L) {
            this.returnType = ((PostgreSchema)this.container).getDatabase().getDataType(retTypeId);
        }
        this.procSrc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"prosrc");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreSchema)this.container).getDatabase();
    }

    @Override
    @Property(order=5)
    public long getObjectId() {
        return this.oid;
    }

    public DBSProcedureType getProcedureType() {
        return DBSProcedureType.FUNCTION;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getBody() {
        return this.body;
    }

    public Collection<PostgreProcedureParameter> getParameters(DBRProgressMonitor monitor) throws DBException {
        return this.params;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @NotNull
    public String getOverloadedName() {
        return this.overloadedName;
    }

    @NotNull
    public String getUniqueName() {
        return this.overloadedName;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (CommonUtils.getOption(options, (String)"debugger.source")) {
            if (this.procSrc == null) {
                try {
                    Throwable throwable = null;
                    Object var4_9 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read procedure body");){
                        this.procSrc = JDBCUtils.queryString((JDBCSession)session, (String)"SELECT prosrc FROM pg_proc where oid = ?", (Object[])new Object[]{this.getObjectId()});
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Error reading procedure body", (Throwable)e);
                }
            }
            return this.procSrc;
        }
        if (this.body == null) {
            if (!this.isPersisted()) {
                this.body = "CREATE OR REPLACE FUNCTION " + this.getFullQualifiedSignature() + GeneralUtils.getDefaultLineSeparator() + "RETURNS INT" + GeneralUtils.getDefaultLineSeparator() + "LANGUAGE sql " + GeneralUtils.getDefaultLineSeparator() + "AS $function$ " + GeneralUtils.getDefaultLineSeparator() + " $function$";
            } else if (this.oid == 0L || this.isAggregate) {
                this.body = this.procSrc;
            } else {
                try {
                    Throwable e = null;
                    Object var4_11 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read procedure body");){
                        this.body = JDBCUtils.queryString((JDBCSession)session, (String)("SELECT pg_get_functiondef(" + this.getObjectId() + ")"), (Object[])new Object[0]);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (SQLException e) {
                    if (!CommonUtils.isEmpty((String)this.procSrc)) {
                        log.debug((Object)"Error reading procedure body", (Throwable)e);
                        this.body = this.procSrc;
                    }
                    throw new DBException("Error reading procedure body", (Throwable)e);
                }
            }
        }
        return this.body;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.body = sourceText;
    }

    @Property(category="Properties", order=10)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return (PostgreRole)PostgreUtils.getObjectById(monitor, ((PostgreSchema)this.container).getDatabase().roleCache, ((PostgreSchema)this.container).getDatabase(), this.ownerId);
    }

    @Property(category="Properties", viewable=true, order=11)
    public PostgreLanguage getLanguage(DBRProgressMonitor monitor) throws DBException {
        return (PostgreLanguage)PostgreUtils.getObjectById(monitor, ((PostgreSchema)this.container).getDatabase().languageCache, ((PostgreSchema)this.container).getDatabase(), this.languageId);
    }

    @Property(category="Properties", viewable=true, order=12)
    public PostgreDataType getReturnType() {
        return this.returnType;
    }

    @Property(category="Properties", viewable=false, order=13)
    public PostgreDataType getVarArrayType() {
        return this.varArrayType;
    }

    @Property(category="Properties", viewable=false, order=14)
    public String getProcTransform() {
        return this.procTransform;
    }

    @Property(category="Statistics", viewable=false, order=30)
    public float getExecCost() {
        return this.execCost;
    }

    @Property(category="Statistics", viewable=false, order=31)
    public float getEstRows() {
        return this.estRows;
    }

    @Property(category="Flags", viewable=true, order=100)
    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Property(category="Flags", viewable=true, order=101)
    public boolean isWindow() {
        return this.isWindow;
    }

    @Property(category="Flags", viewable=true, order=102)
    public boolean isSecurityDefiner() {
        return this.isSecurityDefiner;
    }

    @Property(category="Flags", viewable=true, order=103)
    public boolean isLeakproof() {
        return this.leakproof;
    }

    @Property(category="Flags", viewable=true, order=104)
    public boolean isStrict() {
        return this.isStrict;
    }

    @Property(category="Flags", viewable=true, order=105)
    public boolean isReturnsSet() {
        return this.returnsSet;
    }

    @Property(category="Flags", viewable=true, order=106)
    public ProcedureVolatile getProcVolatile() {
        return this.procVolatile;
    }

    private String makeOverloadedName(boolean quote) {
        String selfName;
        String string = selfName = quote ? DBUtils.getQuotedIdentifier((DBSObject)this) : this.name;
        if (!CommonUtils.isEmpty(this.params)) {
            StringBuilder paramsSignature = new StringBuilder(64);
            paramsSignature.append("(");
            boolean hasParam = false;
            for (PostgreProcedureParameter param : this.params) {
                if (param.getParameterKind() != DBSProcedureParameterKind.IN && param.getParameterKind() != DBSProcedureParameterKind.INOUT) continue;
                if (hasParam) {
                    paramsSignature.append(',');
                }
                hasParam = true;
                PostgreDataType dataType = param.getParameterType();
                PostgreSchema typeContainer = (PostgreSchema)dataType.getParentObject();
                if (typeContainer == null || typeContainer == this.getContainer() || typeContainer.isCatalogSchema()) {
                    paramsSignature.append(dataType.getName());
                    continue;
                }
                paramsSignature.append(dataType.getFullyQualifiedName(DBPEvaluationContext.DDL));
            }
            paramsSignature.append(")");
            return String.valueOf(selfName) + paramsSignature.toString();
        }
        return String.valueOf(selfName) + "()";
    }

    @Property(viewable=true, editable=true, updatable=true, order=200)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public String getFullQualifiedSignature() {
        return String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)this.getContainer())) + "." + this.makeOverloadedName(true);
    }

    public String getProcedureTypeName() {
        return this.isAggregate ? "AGGREGATE" : "FUNCTION";
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.body = null;
        this.procSrc = null;
        return this;
    }

    public String toString() {
        return this.overloadedName == null ? this.name : this.overloadedName;
    }

    public static enum ArgumentMode {
        i(DBSProcedureParameterKind.IN),
        o(DBSProcedureParameterKind.OUT),
        b(DBSProcedureParameterKind.INOUT),
        v(DBSProcedureParameterKind.RESULTSET),
        t(DBSProcedureParameterKind.TABLE),
        u(DBSProcedureParameterKind.UNKNOWN);

        private final DBSProcedureParameterKind parameterKind;

        private ArgumentMode(DBSProcedureParameterKind parameterKind) {
            this.parameterKind = parameterKind;
        }

        public DBSProcedureParameterKind getParameterKind() {
            return this.parameterKind;
        }
    }

    public static enum ProcedureVolatile {
        i,
        s,
        v;

    }
}

