/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.CreateProcedurePage;
import org.jkiss.utils.CommonUtils;

public class PostgreProcedureManager
extends SQLObjectEditor<PostgreProcedure, PostgreSchema> {
    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreProcedure> getObjectsCache(PostgreProcedure object) {
        return ((PostgreSchema)object.getContainer()).proceduresCache;
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        if (CommonUtils.isEmpty((String)((PostgreProcedure)command.getObject()).getName())) {
            throw new DBException("Procedure name cannot be empty");
        }
    }

    protected PostgreProcedure createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final PostgreSchema parent, Object copyFrom) {
        return (PostgreProcedure)new UITask<PostgreProcedure>(){

            protected PostgreProcedure runTask() {
                CreateProcedurePage editPage = new CreateProcedurePage((DBSObjectContainer)parent);
                if (!editPage.edit()) {
                    return null;
                }
                PostgreProcedure newProcedure = new PostgreProcedure(parent);
                newProcedure.setName(editPage.getProcedureName());
                return newProcedure;
            }
        }.execute();
    }

    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (PostgreProcedure)command.getObject());
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceProcedureQuery(actionList, (PostgreProcedure)command.getObject());
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        String objectType = ((PostgreProcedure)command.getObject()).getProcedureTypeName();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop procedure", "DROP " + objectType + " " + ((PostgreProcedure)command.getObject()).getFullQualifiedSignature()));
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actions, PostgreProcedure procedure) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create procedure", procedure.getBody(), true));
    }

    protected void addObjectExtraActions(List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreProcedure, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        if (command.getProperty((Object)"description") != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment procedure", "COMMENT ON " + ((PostgreProcedure)command.getObject()).getProcedureTypeName() + " " + ((PostgreProcedure)command.getObject()).getFullQualifiedSignature() + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((PostgreProcedure)command.getObject()).getDescription())));
        }
    }
}

