/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Map;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermission;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRolePermission;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePermission;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreCommandGrantPrivilege
extends DBECommandAbstract<PostgrePermissionsOwner> {
    private boolean grant;
    private PostgrePermission permission;
    private PostgrePrivilegeType privilege;

    public PostgreCommandGrantPrivilege(PostgrePermissionsOwner user, boolean grant, PostgrePermission permission, PostgrePrivilegeType privilege) {
        super((DBPObject)user, grant ? PostgreMessages.edit_command_grant_privilege_action_grant_privilege : PostgreMessages.edit_command_grant_privilege_action_revoke_privilege);
        this.grant = grant;
        this.permission = permission;
        this.privilege = privilege;
    }

    public void updateModel() {
    }

    public DBEPersistAction[] getPersistActions(Map<String, Object> options) {
        String tableName;
        String roleName;
        String privName;
        String string = privName = this.privilege == null ? PostgrePrivilegeType.ALL.name() : this.privilege.name();
        if (this.getObject() instanceof PostgreRole) {
            roleName = DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)this.getObject()));
            tableName = ((PostgreRolePermission)this.permission).getFullTableName();
        } else {
            roleName = DBUtils.getQuotedIdentifier((DBPDataSource)((PostgrePermissionsOwner)this.getObject()).getDataSource(), (String)((PostgreTablePermission)this.permission).getGrantee());
            tableName = ((PostgreTableBase)this.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        }
        String grantScript = "GRANT " + privName + " ON " + tableName + " TO " + roleName;
        String revokeScript = "REVOKE " + privName + " ON " + tableName + " FROM " + roleName;
        return new DBEPersistAction[]{new SQLDatabasePersistAction(PostgreMessages.edit_command_grant_privilege_action_grant_privilege, this.grant ? grantScript : revokeScript)};
    }

    public DBECommand<?> merge(DBECommand<?> prevCommand, Map<Object, Object> userParams) {
        if (prevCommand instanceof PostgreCommandGrantPrivilege) {
            PostgreCommandGrantPrivilege prevGrant = (PostgreCommandGrantPrivilege)prevCommand;
            if (prevGrant.permission == this.permission && prevGrant.privilege == this.privilege) {
                if (prevGrant.grant == this.grant) {
                    return prevCommand;
                }
                return null;
            }
        }
        return super.merge(prevCommand, userParams);
    }
}

