/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.ext.postgresql.PostgreServerHome;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPClientHome;
import org.jkiss.dbeaver.model.connection.DBPClientManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.utils.WinRegistry;
import org.jkiss.utils.CommonUtils;

public class PostgreDataSourceProvider
extends JDBCDataSourceProvider
implements DBPClientManager {
    private static Map<String, String> connectionsProps = new HashMap<String, String>();
    private static Map<String, PostgreServerHome> localServers = null;

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    public long getFeatures() {
        return 3L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:postgresql://").append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url.append(connectionInfo.getDatabaseName());
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new PostgreDataSource(monitor, container);
    }

    public Collection<String> findClientHomeIds() {
        PostgreDataSourceProvider.findLocalClients();
        LinkedHashSet<String> homes = new LinkedHashSet<String>();
        for (PostgreServerHome home : localServers.values()) {
            homes.add(home.getHomeId());
        }
        return homes;
    }

    public String getDefaultClientHomeId() {
        PostgreDataSourceProvider.findLocalClients();
        return localServers.isEmpty() ? null : localServers.values().iterator().next().getHomeId();
    }

    public DBPClientHome getClientHome(String homeId) {
        return PostgreDataSourceProvider.getServerHome(homeId);
    }

    public static PostgreServerHome getServerHome(String homeId) {
        PostgreDataSourceProvider.findLocalClients();
        PostgreServerHome home = localServers.get(homeId);
        return home == null ? new PostgreServerHome(homeId, homeId, null, null, null) : home;
    }

    public static synchronized void findLocalClients() {
        if (localServers != null) {
            return;
        }
        localServers = new LinkedHashMap<String, PostgreServerHome>();
        OSDescriptor localSystem = DBeaverCore.getInstance().getLocalSystem();
        if (localSystem.isWindows()) {
            try {
                List homeKeys = WinRegistry.readStringSubKeys((int)-2147483646, (String)"SOFTWARE\\PostgreSQL\\Installations");
                if (homeKeys != null) {
                    block2: for (String homeKey : homeKeys) {
                        Map valuesMap = WinRegistry.readStringValues((int)-2147483646, (String)("SOFTWARE\\PostgreSQL\\Installations\\" + homeKey));
                        if (valuesMap == null) continue;
                        for (String key : valuesMap.keySet()) {
                            if (!"Base Directory".equalsIgnoreCase(key)) continue;
                            String baseDir = CommonUtils.removeTrailingSlash((String)((String)valuesMap.get("Base Directory")));
                            String version = (String)valuesMap.get("Version");
                            String branding = (String)valuesMap.get("Branding");
                            String dataDir = (String)valuesMap.get("Data Directory");
                            localServers.put(homeKey, new PostgreServerHome(homeKey, baseDir, version, branding, dataDir));
                            continue block2;
                        }
                    }
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Error reading Windows registry", e);
            }
        }
    }
}

