/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.views;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageOracle
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.oracle.general";
    private Text explainTableText;
    private Button rowidSupportCheck;
    private Button enableDbmsOuputCheck;
    private Button readAllSynonymsCheck;

    public PrefPageOracle() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBeaverCore.getGlobalPreferenceStore()));
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("oracle.explain.table") || store.contains("oracle.support.rowid") || store.contains("oracle.dbms.output") || store.contains("oracle.read.all.synonyms");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group planGroup = UIUtils.createControlGroup((Composite)composite, (String)"Execution plan", (int)2, (int)768, (int)0);
        Label descLabel = new Label((Composite)planGroup, 64);
        descLabel.setText("By default plan table in current or SYS schema will be used.\nYou may set some particular fully qualified plan table name here.");
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        descLabel.setLayoutData((Object)gd);
        this.explainTableText = UIUtils.createLabelText((Composite)planGroup, (String)"Plan table", (String)"", (int)2048, (Object)new GridData(768));
        planGroup = UIUtils.createControlGroup((Composite)composite, (String)"Misc", (int)2, (int)768, (int)0);
        this.rowidSupportCheck = UIUtils.createLabelCheckbox((Composite)planGroup, (String)"Use ROWID to identify rows", (boolean)true);
        this.enableDbmsOuputCheck = UIUtils.createLabelCheckbox((Composite)planGroup, (String)"Enable DBMS Output", (boolean)true);
        this.readAllSynonymsCheck = UIUtils.createLabelCheckbox((Composite)planGroup, (String)"Read all synonyms", (String)"If unchecked Java classes and package bodies will be skipped", (boolean)true);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.explainTableText.setText(store.getString("oracle.explain.table"));
        this.rowidSupportCheck.setSelection(store.getBoolean("oracle.support.rowid"));
        this.enableDbmsOuputCheck.setSelection(store.getBoolean("oracle.dbms.output"));
        this.readAllSynonymsCheck.setSelection(store.getBoolean("oracle.read.all.synonyms"));
    }

    protected void savePreferences(DBPPreferenceStore store) {
        store.setValue("oracle.explain.table", this.explainTableText.getText());
        store.setValue("oracle.support.rowid", this.rowidSupportCheck.getSelection());
        store.setValue("oracle.dbms.output", this.enableDbmsOuputCheck.getSelection());
        store.setValue("oracle.read.all.synonyms", this.readAllSynonymsCheck.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("oracle.explain.table");
        store.setToDefault("oracle.support.rowid");
        store.setToDefault("oracle.dbms.output");
        store.setToDefault("oracle.read.all.synonyms");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

