/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataFile;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleGlobalObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleSegment;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.utils.CommonUtils;

public class OracleTablespace
extends OracleGlobalObject
implements DBPRefreshableObject {
    private String name;
    private long blockSize;
    private long initialExtent;
    private long nextExtent;
    private long minExtents;
    private long maxExtents;
    private long pctIncrease;
    private long minExtLen;
    private Status status;
    private Contents contents;
    private Logging logging;
    private boolean forceLogging;
    private ExtentManagement extentManagement;
    private AllocationType allocationType;
    private boolean pluggedIn;
    private SegmentSpaceManagement segmentSpaceManagement;
    private boolean defTableCompression;
    private Retention retention;
    private boolean bigFile;
    final FileCache fileCache = new FileCache();
    final SegmentCache segmentCache = new SegmentCache();

    protected OracleTablespace(OracleDataSource dataSource, ResultSet dbResult) {
        super(dataSource, true);
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLESPACE_NAME");
        this.blockSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BLOCK_SIZE");
        this.initialExtent = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INITIAL_EXTENT");
        this.nextExtent = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NEXT_EXTENT");
        this.minExtents = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MIN_EXTENTS");
        this.maxExtents = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_EXTENTS");
        this.pctIncrease = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"PCT_INCREASE");
        this.minExtLen = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MIN_EXTLEN");
        this.status = (Status)CommonUtils.valueOf(Status.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"), (boolean)true);
        this.contents = (Contents)CommonUtils.valueOf(Contents.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONTENTS"), (boolean)true);
        this.logging = (Logging)CommonUtils.valueOf(Logging.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOGGING"), (boolean)true);
        this.forceLogging = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"FORCE_LOGGING", (String)"Y");
        this.extentManagement = (ExtentManagement)CommonUtils.valueOf(ExtentManagement.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EXTENT_MANAGEMENT"), (boolean)true);
        this.allocationType = (AllocationType)CommonUtils.valueOf(AllocationType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ALLOCATION_TYPE"), (boolean)true);
        this.pluggedIn = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"PLUGGED_IN", (String)"Y");
        this.segmentSpaceManagement = (SegmentSpaceManagement)CommonUtils.valueOf(SegmentSpaceManagement.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SEGMENT_SPACE_MANAGEMENT"), (boolean)true);
        this.defTableCompression = "ENABLED".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEF_TAB_COMPRESSION"));
        this.retention = (Retention)CommonUtils.valueOf(Retention.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RETENTION"), (boolean)true);
        this.bigFile = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"BIGFILE", (String)"Y");
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, editable=true, order=2)
    public long getBlockSize() {
        return this.blockSize;
    }

    @Property(editable=true, order=3)
    public long getInitialExtent() {
        return this.initialExtent;
    }

    @Property(editable=true, order=4)
    public long getNextExtent() {
        return this.nextExtent;
    }

    @Property(editable=true, order=5)
    public long getMinExtents() {
        return this.minExtents;
    }

    @Property(editable=true, order=6)
    public long getMaxExtents() {
        return this.maxExtents;
    }

    @Property(editable=true, order=7)
    public long getPctIncrease() {
        return this.pctIncrease;
    }

    @Property(editable=true, order=8)
    public long getMinExtLen() {
        return this.minExtLen;
    }

    @Property(viewable=true, editable=true, order=9)
    public Status getStatus() {
        return this.status;
    }

    @Property(editable=true, order=10)
    public Contents getContents() {
        return this.contents;
    }

    @Property(editable=true, order=11)
    public Logging isLogging() {
        return this.logging;
    }

    @Property(editable=true, order=12)
    public boolean isForceLogging() {
        return this.forceLogging;
    }

    @Property(editable=true, order=13)
    public ExtentManagement getExtentManagement() {
        return this.extentManagement;
    }

    @Property(editable=true, order=14)
    public AllocationType getAllocationType() {
        return this.allocationType;
    }

    @Property(editable=true, order=15)
    public boolean isPluggedIn() {
        return this.pluggedIn;
    }

    @Property(editable=true, order=16)
    public SegmentSpaceManagement getSegmentSpaceManagement() {
        return this.segmentSpaceManagement;
    }

    @Property(editable=true, order=17)
    public boolean isDefTableCompression() {
        return this.defTableCompression;
    }

    @Property(editable=true, order=18)
    public Retention getRetention() {
        return this.retention;
    }

    @Property(editable=true, order=19)
    public boolean isBigFile() {
        return this.bigFile;
    }

    @Association
    public Collection<OracleDataFile> getFiles(DBRProgressMonitor monitor) throws DBException {
        return this.fileCache.getAllObjects(monitor, this);
    }

    public OracleDataFile getFile(DBRProgressMonitor monitor, long relativeFileNo) throws DBException {
        for (OracleDataFile file : this.fileCache.getAllObjects(monitor, this)) {
            if (file.getRelativeNo() != relativeFileNo) continue;
            return file;
        }
        return null;
    }

    @Association
    public Collection<OracleSegment<OracleTablespace>> getSegments(DBRProgressMonitor monitor) throws DBException {
        return this.segmentCache.getAllObjects(monitor, this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.fileCache.clearCache();
        this.segmentCache.clearCache();
        return this;
    }

    static Object resolveTablespaceReference(DBRProgressMonitor monitor, DBSObjectLazy<OracleDataSource> referrer, @Nullable Object propertyId) throws DBException {
        OracleDataSource dataSource = (OracleDataSource)referrer.getDataSource();
        if (!dataSource.isAdmin()) {
            return referrer.getLazyReference(propertyId);
        }
        return OracleUtils.resolveLazyReference(monitor, dataSource, dataSource.tablespaceCache, referrer, propertyId);
    }

    public static enum AllocationType {
        SYSTEM,
        UNIFORM,
        USER;

    }

    public static enum Contents {
        PERMANENT,
        TEMPORARY,
        UNDO;

    }

    public static enum ExtentManagement {
        DICTIONARY,
        LOCAL;

    }

    static class FileCache
    extends JDBCObjectCache<OracleTablespace, OracleDataFile> {
        FileCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleTablespace owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM SYS.DBA_" + (owner.getContents() == Contents.TEMPORARY ? "TEMP" : "DATA") + "_FILES WHERE TABLESPACE_NAME=? ORDER BY FILE_NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleDataFile fetchObject(@NotNull JDBCSession session, @NotNull OracleTablespace owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleDataFile(owner, (ResultSet)resultSet, owner.getContents() == Contents.TEMPORARY);
        }
    }

    public static enum Logging {
        LOGGING,
        NOLOGGING;

    }

    public static enum Retention {
        GUARANTEE,
        NOGUARANTEE,
        NOT_APPLY;

    }

    static class SegmentCache
    extends JDBCObjectCache<OracleTablespace, OracleSegment<OracleTablespace>> {
        SegmentCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleTablespace owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getAdminViewPrefix(owner.getDataSource()) + "SEGMENTS WHERE TABLESPACE_NAME=? ORDER BY SEGMENT_NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleSegment<OracleTablespace> fetchObject(@NotNull JDBCSession session, @NotNull OracleTablespace owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleSegment<OracleTablespace>(session.getProgressMonitor(), owner, (ResultSet)resultSet);
        }
    }

    public static enum SegmentSpaceManagement {
        MANUAL,
        AUTO;

    }

    public static enum Status {
        ONLINE,
        OFFLINE,
        READ_ONLY;

    }

    public static class TablespaceReferenceValidator
    implements IPropertyCacheValidator<DBSObjectLazy<OracleDataSource>> {
        public boolean isPropertyCached(DBSObjectLazy<OracleDataSource> object, Object propertyId) {
            return object.getLazyReference(propertyId) instanceof OracleTablespace || object.getLazyReference(propertyId) == null || ((OracleDataSource)object.getDataSource()).tablespaceCache.isFullyCached() || !((OracleDataSource)object.getDataSource()).isAdmin();
        }
    }
}

