/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class OracleTableColumnManager
extends SQLTableColumnManager<OracleTableColumn, OracleTableBase>
implements DBEObjectRenamer<OracleTableColumn> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTableColumn> getObjectsCache(OracleTableColumn object) {
        return ((OracleSchema)((OracleTableBase)object.getParentObject()).getContainer()).tableCache.getChildrenCache((OracleTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(OracleTableColumn column) {
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.DefaultModifier, this.NullNotNullModifierConditional};
    }

    protected OracleTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, OracleTableBase parent, Object copyFrom) {
        DBSDataType columnType = OracleTableColumnManager.findBestDataType((DBPDataSource)parent.getDataSource(), (String[])new String[]{"varchar2"});
        OracleTableColumn column = new OracleTableColumn(parent);
        column.setName(this.getNewColumnName(monitor, context, parent));
        column.setDataType((OracleDataType)columnType);
        column.setTypeName(columnType == null ? "INTEGER" : columnType.getName());
        column.setMaxLength(columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0);
        column.setValueType(columnType == null ? 4 : columnType.getTypeID());
        column.setOrdinalPosition(-1);
        return column;
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        boolean hasComment;
        OracleTableColumn column = (OracleTableColumn)command.getObject();
        boolean bl = hasComment = command.getProperty((Object)"comment") != null;
        if (!hasComment || command.getProperties().size() > 1) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify column", "ALTER TABLE " + ((OracleTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " MODIFY " + this.getNestedDeclaration((OracleTableBase)column.getTable(), (DBECommandAbstract)command, options)));
        }
        if (hasComment) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Comment column", "COMMENT ON COLUMN " + ((OracleTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS '" + column.getComment((DBRProgressMonitor)new VoidProgressMonitor()) + "'"));
        }
    }

    public void renameObject(DBECommandContext commandContext, OracleTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }

    protected void addObjectRenameActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        OracleTableColumn column = (OracleTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + ((OracleTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }
}

