/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.Collections;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndexColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class OracleIndexManager
extends SQLIndexManager<OracleTableIndex, OracleTablePhysical> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTableIndex> getObjectsCache(OracleTableIndex object) {
        return ((OracleTablePhysical)object.getParentObject()).getSchema().indexCache;
    }

    protected OracleTableIndex createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final OracleTablePhysical parent, Object from) {
        return (OracleTableIndex)((Object)new UITask<OracleTableIndex>(){

            protected OracleTableIndex runTask() {
                EditIndexPage editPage = new EditIndexPage(OracleMessages.edit_oracle_index_manager_dialog_title, (DBSTable)parent, Collections.singletonList(DBSIndexType.OTHER));
                if (!editPage.edit()) {
                    return null;
                }
                StringBuilder idxName = new StringBuilder(64);
                idxName.append(CommonUtils.escapeIdentifier((String)parent.getName())).append("_").append(CommonUtils.escapeIdentifier((String)((DBSEntityAttribute)editPage.getSelectedAttributes().iterator().next()).getName())).append("_IDX");
                OracleTableIndex index = new OracleTableIndex(parent.getSchema(), parent, DBObjectNameCaseTransformer.transformName((DBPDataSource)parent.getDataSource(), (String)idxName.toString()), editPage.isUnique(), editPage.getIndexType());
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    index.addColumn(new OracleTableIndexColumn(index, (OracleTableColumn)tableColumn, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty(tableColumn, "desc")), null));
                }
                return index;
            }
        }.execute());
    }

    protected String getDropIndexPattern(OracleTableIndex index) {
        return "ALTER TABLE %TABLE% DROP INDEX %INDEX_SHORT%";
    }
}

