/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import org.jkiss.dbeaver.ext.oracle.data.OracleBFILEValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleBLOBValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleCLOBValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleObjectValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleTimestampValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleXMLValueHandler;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDPreferences;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class OracleValueHandlerProvider
implements DBDValueHandlerProvider {
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDPreferences preferences, DBSTypedObject typedObject) {
        String typeName = typedObject.getTypeName();
        if (typedObject.getTypeID() == 2004) {
            return OracleBLOBValueHandler.INSTANCE;
        }
        if (typedObject.getTypeID() == 2005 || typedObject.getTypeID() == 2011) {
            return OracleCLOBValueHandler.INSTANCE;
        }
        if ("XMLTYPE".equals(typeName) || "SYS.XMLTYPE".equals(typeName)) {
            return OracleXMLValueHandler.INSTANCE;
        }
        if ("BFILE".equals(typeName)) {
            return OracleBFILEValueHandler.INSTANCE;
        }
        if (typedObject.getTypeID() == 2002) {
            return OracleObjectValueHandler.INSTANCE;
        }
        if (typeName.contains("TIMESTAMP") || typedObject.getDataKind() == DBPDataKind.DATETIME) {
            return new OracleTimestampValueHandler(preferences.getDataFormatterProfile());
        }
        return null;
    }
}

