/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLInformation;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class MySQLEngine
extends MySQLInformation {
    private String name;
    private String description;
    private Support support;
    private boolean supportsTransactions;
    private boolean supportsXA;
    private boolean supportsSavepoints;

    public MySQLEngine(MySQLDataSource dataSource, ResultSet dbResult) throws SQLException {
        super(dataSource);
        this.loadInfo(dbResult);
    }

    public MySQLEngine(MySQLDataSource dataSource, String name) {
        super(dataSource);
        this.name = name;
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ENGINE");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMMENT");
        this.support = Support.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SUPPORT"));
        this.supportsTransactions = "YES".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TRANSACTIONS"));
        this.supportsXA = "YES".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"XA"));
        this.supportsSavepoints = "YES".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SAVEPOINTS"));
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, order=3)
    public Support getSupport() {
        return this.support;
    }

    @Property(viewable=true, order=4)
    public boolean isSupportsTransactions() {
        return this.supportsTransactions;
    }

    @Property(viewable=true, order=5)
    public boolean isSupportsXA() {
        return this.supportsXA;
    }

    @Property(viewable=true, order=6)
    public boolean isSupportsSavepoints() {
        return this.supportsSavepoints;
    }

    public static enum Support {
        YES,
        NO,
        DEFAULT,
        DISABLED;

    }
}

