/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCClientHome;
import org.jkiss.utils.IOUtils;

public class MySQLServerHome
extends JDBCClientHome {
    private static final Log log = Log.getLog(MySQLServerHome.class);
    private String name;
    private String version;

    protected MySQLServerHome(String path, String name) {
        super(path, path);
        this.name = name == null ? path : name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getProductName() throws DBException {
        return "MySQL";
    }

    public String getProductVersion() throws DBException {
        if (this.version == null) {
            this.version = this.getFullServerVersion();
            if (this.version == null) {
                this.version = "Unknown";
            }
        }
        return this.version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFullServerVersion() {
        File binPath = this.getHomePath();
        File binSubfolder = new File(binPath, "bin");
        if (binSubfolder.exists()) {
            binPath = binSubfolder;
        }
        String cmd = new File(binPath, MySQLUtils.getMySQLConsoleBinaryName()).getAbsolutePath();
        try {
            Process p = Runtime.getRuntime().exec(new String[]{cmd, "-V"});
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line;
                    int pos;
                    do {
                        if ((line = input.readLine()) != null) continue;
                        return null;
                    } while ((pos = line.indexOf("Distrib ")) == -1);
                    int pos2 = line.indexOf(",", pos += 8);
                    String string = line.substring(pos, pos2);
                    return string;
                }
                finally {
                    IOUtils.close((Closeable)input);
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error reading MySQL server version from " + cmd), (Throwable)ex);
        }
        return null;
    }
}

