/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.rules.IRule;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.mssql.model.MSSQLDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.runtime.sql.SQLRuleProvider;
import org.jkiss.utils.CommonUtils;

public class MSSQLDialect
extends GenericSQLDialect
implements SQLRuleProvider {
    private static final String[][] TSQL_BEGIN_END_BLOCK = new String[0][];
    public static final String[][] MSSQL_QUOTE_STRINGS = new String[][]{{"[", "]"}, {"\"", "\""}};
    private MSSQLDataSource dataSource;

    public MSSQLDialect() {
        super("MSSQL");
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        this.addSQLKeyword("TOP");
        this.dataSource = (MSSQLDataSource)dataSource;
    }

    public String[][] getIdentifierQuoteStrings() {
        return MSSQL_QUOTE_STRINGS;
    }

    public String[][] getBlockBoundStrings() {
        return TSQL_BEGIN_END_BLOCK;
    }

    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        if (this.dataSource.isServerVersionAtLeast(10, 0)) {
            return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
        }
        return super.getMultiValueInsertMode();
    }

    public void extendRules(@NotNull List<IRule> rules, @NotNull SQLRuleProvider.RulePosition position) {
    }

    public void generateStoredProcedureCall(StringBuilder sql, DBSProcedure proc, Collection<? extends DBSProcedureParameter> parameters) {
        ArrayList inParameters = new ArrayList();
        int maxParamLength = this.getMaxParameterLength(parameters, inParameters);
        String schemaName = proc.getParentObject().getName();
        schemaName = proc.getContainer().getParentObject().getName();
        sql.append("USE [").append(schemaName).append("]\n");
        sql.append("GO\n\n");
        sql.append("DECLARE\t@return_value int\n\n");
        sql.append("EXEC\t@return_value = [").append(proc.getContainer().getName()).append("].[").append(proc.getName()).append("]\n");
        int i = 0;
        while (i < inParameters.size()) {
            String name = ((DBSProcedureParameter)inParameters.get(i)).getName();
            sql.append("\t\t").append(name).append(" = :").append(CommonUtils.escapeIdentifier((String)name));
            if (i < inParameters.size() - 1) {
                sql.append(", ");
            } else {
                sql.append(" ");
            }
            int width = maxParamLength + 70 - name.length() / 2;
            String typeName = ((DBSProcedureParameter)inParameters.get(i)).getParameterType().getFullTypeName();
            sql.append(CommonUtils.fixedLengthString((String)("-- put the " + name + " parameter value instead of '?' (" + typeName + ")\n"), (int)width));
            ++i;
        }
        sql.append("\nSELECT\t'Return Value' = @return_value\n\n");
        sql.append("GO\n\n");
    }
}

