/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mockdata.model.MockGeneratorDescriptor;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MockGeneratorRegistry {
    static final String TAG_GENERATOR = "generator";
    private static final Log log = Log.getLog(MockGeneratorRegistry.class);
    private static MockGeneratorRegistry instance = null;
    private final List<MockGeneratorDescriptor> generators = new ArrayList<MockGeneratorDescriptor>();

    public static synchronized MockGeneratorRegistry getInstance() {
        if (instance == null) {
            instance = new MockGeneratorRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private MockGeneratorRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.mockGenerator");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_GENERATOR.equals(ext.getName())) {
                MockGeneratorDescriptor generatorDescriptor = new MockGeneratorDescriptor(ext);
                this.generators.add(generatorDescriptor);
            }
            ++n2;
        }
    }

    public void dispose() {
        this.generators.clear();
    }

    @Nullable
    public MockGeneratorDescriptor findGenerator(DBPDataSource dataSource, DBSTypedObject typedObject) {
        for (MockGeneratorDescriptor descriptor : this.generators) {
            if ((descriptor.isGlobal() || !descriptor.supportsDataSource(dataSource) || !descriptor.supportsType(typedObject)) && (!descriptor.isGlobal() || !descriptor.supportsType(typedObject))) continue;
            return descriptor;
        }
        return null;
    }

    public List<MockGeneratorDescriptor> findAllGenerators(DBPDataSource dataSource, DBSTypedObject typedObject) {
        ArrayList<MockGeneratorDescriptor> result = new ArrayList<MockGeneratorDescriptor>();
        for (MockGeneratorDescriptor descriptor : this.generators) {
            if ((descriptor.isGlobal() || !descriptor.supportsDataSource(dataSource) || !descriptor.supportsType(typedObject)) && (!descriptor.isGlobal() || !descriptor.supportsType(typedObject))) continue;
            result.add(descriptor);
        }
        return result;
    }

    public MockGeneratorDescriptor getGenerator(String id) {
        for (MockGeneratorDescriptor descriptor : this.generators) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }
}

