/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mockdata.MockDataExecuteWizard;
import org.jkiss.dbeaver.ext.mockdata.MockDataMessages;
import org.jkiss.dbeaver.ext.mockdata.MockDataSettings;
import org.jkiss.dbeaver.ext.mockdata.model.MockGeneratorDescriptor;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

public class MockDataWizardPageSettings
extends ActiveWizardPage<MockDataExecuteWizard> {
    private static final Log log = Log.getLog(MockDataWizardPageSettings.class);
    private MockDataSettings mockDataSettings;
    private CLabel noGeneratorInfoLabel;
    private Text entityNameText;
    private Button removeOldDataCheck;
    private Text rowsText;
    private PropertyTreeViewer propsEditor;
    private PropertySourceCustom propertySource;
    private TableViewer columnsTableViewer;
    private DBSAttributeBase selectedAttribute;
    private boolean firstInit = true;
    private Combo generatorCombo;
    private Combo presetCombo;
    private Label generatorDescriptionLabel;
    private Link generatorDescriptionLink;
    private Font boldFont;
    private String generatorLinkUrl;

    protected MockDataWizardPageSettings(MockDataSettings mockDataSettings) {
        super(MockDataMessages.tools_mockdata_wizard_page_settings_page_name);
        this.setTitle(MockDataMessages.tools_mockdata_wizard_page_settings_page_name);
        this.setDescription(MockDataMessages.tools_mockdata_wizard_page_settings_page_description);
        this.mockDataSettings = mockDataSettings;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        SelectionAdapter changeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MockDataWizardPageSettings.this.updateState();
            }
        };
        Composite entityPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)2);
        this.entityNameText = UIUtils.createLabelText((Composite)entityPlaceholder, (String)"Entity", (String)"", (int)8);
        GridData gd = new GridData(32);
        gd.widthHint = 230;
        gd.verticalIndent = 5;
        gd.horizontalIndent = 9;
        entityPlaceholder.setLayoutData((Object)gd);
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)MockDataMessages.tools_mockdata_wizard_page_settings_group_settings, (int)4, (int)768, (int)0);
        gd = new GridData(768);
        gd.verticalIndent = 5;
        settingsGroup.setLayoutData((Object)gd);
        this.removeOldDataCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MockDataMessages.tools_mockdata_wizard_page_settings_checkbox_remove_old_data, null, (boolean)this.mockDataSettings.isRemoveOldData(), (int)4);
        this.removeOldDataCheck.addSelectionListener((SelectionListener)changeListener);
        this.rowsText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Rows ", (String)String.valueOf(this.mockDataSettings.getRowsNumber()), (int)2048, (Object)new GridData(110, -1));
        this.rowsText.addSelectionListener((SelectionListener)changeListener);
        this.rowsText.addVerifyListener(UIUtils.getLongVerifyListener((Text)this.rowsText));
        this.rowsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MockDataWizardPageSettings.this.updateState();
            }
        });
        Group generatorsGroup = UIUtils.createControlGroup((Composite)composite, (String)"Generators", (int)5, (int)1808, (int)0);
        GridData gd2 = new GridData(1808);
        gd2.verticalIndent = 5;
        generatorsGroup.setLayoutData((Object)gd2);
        this.columnsTableViewer = new TableViewer((Composite)generatorsGroup, 67588);
        final Table table = this.columnsTableViewer.getTable();
        gd2 = new GridData(1040);
        gd2.widthHint = 230;
        table.setLayoutData((Object)gd2);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.columnsTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        final VoidProgressMonitor monitor = new VoidProgressMonitor();
        CellLabelProvider labelProvider = new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBSAttributeBase attribute = (DBSAttributeBase)cell.getElement();
                MockDataSettings.AttributeGeneratorProperties attributeGeneratorProperties = MockDataWizardPageSettings.this.mockDataSettings.getAttributeGeneratorProperties(attribute);
                if (cell.getColumnIndex() == 0) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getTypeImage((DBSTypedObject)attribute)));
                    cell.setText(attribute.getName());
                    try {
                        if (DBUtils.checkUnique((DBRProgressMonitor)monitor, (DBSEntity)MockDataWizardPageSettings.this.mockDataSettings.getEntity(), (DBSAttributeBase)attribute)) {
                            cell.setFont(MockDataWizardPageSettings.this.boldFont);
                        }
                    }
                    catch (DBException e) {
                        log.error((Object)("Error checking the attribute '" + attribute.getName() + "' properties"), (Throwable)e);
                    }
                    if (attributeGeneratorProperties != null && attributeGeneratorProperties.isEmpty()) {
                        cell.setForeground(table.getDisplay().getSystemColor(3));
                        MockDataWizardPageSettings.this.noGeneratorInfoLabel.setVisible(true);
                    }
                } else if (attributeGeneratorProperties != null && !attributeGeneratorProperties.isEmpty()) {
                    String selectedGeneratorId = attributeGeneratorProperties.getSelectedGeneratorId();
                    String label = MockDataWizardPageSettings.this.mockDataSettings.getGeneratorDescriptor(selectedGeneratorId).getLabel();
                    String presetId = attributeGeneratorProperties.getPresetId();
                    if (presetId != null) {
                        List<MockGeneratorDescriptor.Preset> presets = MockDataWizardPageSettings.this.mockDataSettings.getGeneratorDescriptor(selectedGeneratorId).getPresets();
                        for (MockGeneratorDescriptor.Preset preset : presets) {
                            if (!presetId.equals(preset.getId())) continue;
                            label = String.valueOf(label) + " [" + preset.getMnemonics() + "]";
                            break;
                        }
                    }
                    cell.setText(label);
                }
            }
        };
        TableViewerColumn attributeColumn = new TableViewerColumn(this.columnsTableViewer, 16384);
        attributeColumn.setLabelProvider(labelProvider);
        attributeColumn.getColumn().setText("Attribute");
        TableViewerColumn generatorColumn = new TableViewerColumn(this.columnsTableViewer, 16384);
        generatorColumn.setLabelProvider(labelProvider);
        generatorColumn.getColumn().setText("Generator");
        generatorColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.columnsTableViewer){

            protected CellEditor getCellEditor(Object element) {
                DBSAttributeBase attribute = (DBSAttributeBase)element;
                MockDataSettings.AttributeGeneratorProperties attributeGenerators = MockDataWizardPageSettings.this.mockDataSettings.getAttributeGeneratorProperties(attribute);
                LinkedHashSet<String> generators = new LinkedHashSet<String>();
                if (attributeGenerators.isEmpty()) {
                    MockDataWizardPageSettings.this.noGeneratorInfoLabel.setVisible(true);
                    TextCellEditor textCellEditor = new TextCellEditor((Composite)MockDataWizardPageSettings.this.columnsTableViewer.getTable());
                    textCellEditor.getControl().setEnabled(false);
                    return textCellEditor;
                }
                for (String generatorId : attributeGenerators.getGenerators()) {
                    generators.add(MockDataWizardPageSettings.this.mockDataSettings.getGeneratorDescriptor(generatorId).getLabel());
                }
                CustomComboBoxCellEditor customComboBoxCellEditor = new CustomComboBoxCellEditor((ColumnViewer)MockDataWizardPageSettings.this.columnsTableViewer, (Composite)MockDataWizardPageSettings.this.columnsTableViewer.getTable(), generators.toArray(new String[generators.size()]), 2056);
                return customComboBoxCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DBSAttributeBase attribute = (DBSAttributeBase)element;
                String selectedGenerator = MockDataWizardPageSettings.this.mockDataSettings.getAttributeGeneratorProperties(attribute).getSelectedGeneratorId();
                if (selectedGenerator != null) {
                    return MockDataWizardPageSettings.this.mockDataSettings.getGeneratorDescriptor(selectedGenerator).getLabel();
                }
                return "";
            }

            protected void setValue(Object element, Object value) {
                DBSAttributeBase attribute = (DBSAttributeBase)element;
                MockDataWizardPageSettings.this.selectGenerator(attribute, (String)value);
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MockDataWizardPageSettings.this.saveGeneratorProperties();
                MockDataWizardPageSettings.this.reloadProperties((DBSAttributeBase)e.item.getData(), null);
            }
        });
        Composite placeholder = UIUtils.createPlaceholder((Composite)generatorsGroup, (int)1);
        placeholder.setLayoutData((Object)new GridData(1808));
        Composite labelCombo = UIUtils.createPlaceholder((Composite)placeholder, (int)5);
        gd2 = new GridData(768);
        labelCombo.setLayoutData((Object)gd2);
        this.generatorCombo = new Combo(labelCombo, 12);
        gd2 = new GridData();
        gd2.widthHint = 80;
        this.generatorCombo.setLayoutData((Object)gd2);
        this.generatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MockDataWizardPageSettings.this.selectGenerator(MockDataWizardPageSettings.this.selectedAttribute, MockDataWizardPageSettings.this.generatorCombo.getText());
            }
        });
        Composite descriptionCombo = UIUtils.createPlaceholder((Composite)labelCombo, (int)2);
        gd2 = new GridData(800);
        descriptionCombo.setLayoutData((Object)gd2);
        this.generatorDescriptionLabel = new Label(descriptionCombo, 0);
        this.generatorDescriptionLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        this.generatorDescriptionLabel.setText("");
        gd2 = new GridData(800);
        gd2.horizontalIndent = 5;
        this.generatorDescriptionLabel.setLayoutData((Object)gd2);
        this.generatorDescriptionLink = UIUtils.createLink((Composite)descriptionCombo, (String)"", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CommonUtils.isEmpty((String)MockDataWizardPageSettings.this.generatorLinkUrl)) {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    try {
                        support.getExternalBrowser().openURL(new URL(MockDataWizardPageSettings.this.generatorLinkUrl));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        gd2 = new GridData(128);
        gd2.horizontalIndent = 5;
        this.generatorDescriptionLink.setLayoutData((Object)gd2);
        this.presetCombo = new Combo(labelCombo, 12);
        gd2 = new GridData();
        gd2.horizontalIndent = 5;
        this.presetCombo.setLayoutData((Object)gd2);
        this.presetCombo.setVisible(false);
        this.presetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MockDataWizardPageSettings.this.selectPreset(MockDataWizardPageSettings.this.presetCombo.getText());
            }
        });
        Button resetButton = new Button(labelCombo, 8);
        resetButton.setText("Reset");
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object key : MockDataWizardPageSettings.this.propertySource.getProperties().keySet()) {
                    MockDataWizardPageSettings.this.propertySource.resetPropertyValueToDefault(key);
                }
                MockDataWizardPageSettings.this.propsEditor.loadProperties((DBPPropertySource)MockDataWizardPageSettings.this.propertySource);
                MockDataWizardPageSettings.this.mockDataSettings.getAttributeGeneratorProperties(MockDataWizardPageSettings.this.selectedAttribute).setPresetId(null);
                if (MockDataWizardPageSettings.this.presetCombo.getItemCount() > 0) {
                    MockDataWizardPageSettings.this.presetCombo.select(0);
                }
                MockDataWizardPageSettings.this.columnsTableViewer.refresh(true, true);
            }
        });
        gd2 = new GridData();
        gd2.horizontalIndent = 5;
        resetButton.setLayoutData((Object)gd2);
        this.propsEditor = new PropertyTreeViewer(placeholder, 2048);
        gd2 = new GridData(1808);
        gd2.verticalIndent = 5;
        this.propsEditor.getControl().setLayoutData((Object)gd2);
        this.noGeneratorInfoLabel = UIUtils.createInfoLabel((Composite)composite, (String)"Generators for the red highlighted attributes aren't found. So, no data will be generated for them.");
        gd2 = new GridData(32);
        gd2.horizontalSpan = 2;
        gd2.verticalIndent = 5;
        this.noGeneratorInfoLabel.setLayoutData((Object)gd2);
        this.noGeneratorInfoLabel.setVisible(false);
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UIUtils.packColumns((Table)table);
                UIUtils.maxTableColumnsWidth((Table)table);
                table.removeControlListener((ControlListener)this);
            }
        });
        this.setControl((Control)composite);
        this.boldFont = UIUtils.makeBoldFont((Font)this.columnsTableViewer.getControl().getFont());
    }

    private void selectGenerator(DBSAttributeBase attribute, String generatorName) {
        MockGeneratorDescriptor generatorForName = this.mockDataSettings.findGeneratorForName(attribute, generatorName);
        if (generatorForName != null) {
            this.saveGeneratorProperties();
            this.reloadProperties(attribute, generatorForName.getId());
        }
        this.columnsTableViewer.refresh(true, true);
    }

    private void selectPreset(String presetName) {
        MockDataSettings.AttributeGeneratorProperties attributeGeneratorProperties = this.mockDataSettings.getAttributeGeneratorProperties(this.selectedAttribute);
        String generatorId = attributeGeneratorProperties.getSelectedGeneratorId();
        List<MockGeneratorDescriptor.Preset> presets = this.mockDataSettings.getGeneratorDescriptor(generatorId).getPresets();
        for (MockGeneratorDescriptor.Preset preset : presets) {
            if (!preset.getLabel().equals(presetName)) continue;
            this.propertySource = attributeGeneratorProperties.getGeneratorPropertySource(generatorId);
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            for (DBPPropertyDescriptor prop : preset.getProperties()) {
                this.propertySource.setPropertyValue((DBRProgressMonitor)monitor, prop.getId(), prop.getDefaultValue());
            }
            this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
            this.propsEditor.setExpandMode(PropertyTreeViewer.ExpandMode.FIRST);
            this.propsEditor.expandAll();
            attributeGeneratorProperties.setPresetId(preset.getId());
            this.columnsTableViewer.refresh(true, true);
        }
    }

    public void activatePage() {
        try {
            if (this.firstInit) {
                this.firstInit = false;
                MockDataExecuteWizard wizard = (MockDataExecuteWizard)this.getWizard();
                this.mockDataSettings.init(wizard);
                wizard.loadSettings();
                this.removeOldDataCheck.setSelection(this.mockDataSettings.isRemoveOldData());
                this.rowsText.setText(String.valueOf(this.mockDataSettings.getRowsNumber()));
                this.columnsTableViewer.setInput(this.mockDataSettings.getAttributes());
            }
            this.entityNameText.setText(DBUtils.getObjectFullName((DBPNamedObject)this.mockDataSettings.getEntity(), (DBPEvaluationContext)DBPEvaluationContext.DML));
            this.propsEditor.getControl().setFocus();
            Table table = this.columnsTableViewer.getTable();
            if (table.getItemCount() > 0) {
                int selectedItem = 0;
                String selectedAttribute = this.mockDataSettings.getSelectedAttribute();
                if (selectedAttribute != null) {
                    int i = 0;
                    while (i < table.getItemCount()) {
                        if (selectedAttribute.equals(table.getItem(i).getText())) {
                            selectedItem = i;
                            break;
                        }
                        ++i;
                    }
                }
                table.select(selectedItem);
                Event event = new Event();
                event.widget = table;
                event.display = table.getDisplay();
                event.item = table.getItem(selectedItem);
                event.type = 13;
                table.notifyListeners(13, event);
            } else {
                this.noGeneratorInfoLabel.setText("No attributes in the table");
                this.noGeneratorInfoLabel.setVisible(true);
            }
        }
        catch (DBException ex) {
            log.error((Object)"Error of initializing the Mock Data settings", (Throwable)ex);
        }
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        this.saveGeneratorProperties();
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean validateProperties() {
        Map<String, MockDataSettings.AttributeGeneratorProperties> attributeGenerators = this.mockDataSettings.getAttributeGenerators();
        for (String attr : attributeGenerators.keySet()) {
            MockDataSettings.AttributeGeneratorProperties attributeGeneratorProperties = attributeGenerators.get(attr);
            String selectedGeneratorId = attributeGeneratorProperties.getSelectedGeneratorId();
            if (CommonUtils.isEmpty((String)selectedGeneratorId)) continue;
            Map properties = attributeGeneratorProperties.getGeneratorPropertySource(selectedGeneratorId).getPropertiesWithDefaults();
            for (Object key : properties.keySet()) {
                Object value = properties.get(key);
                if (value instanceof Integer && (Integer)value < 0) {
                    return false;
                }
                if (!(value instanceof Long) || (Long)value >= 0L) continue;
                return false;
            }
        }
        return true;
    }

    private void updateState() {
        this.mockDataSettings.setRemoveOldData(this.removeOldDataCheck.getSelection());
        this.mockDataSettings.setRowsNumber(Long.parseLong(this.rowsText.getText()));
    }

    private void reloadProperties(DBSAttributeBase attribute, String generatorId) {
        String selectedGenerator;
        MockDataSettings.AttributeGeneratorProperties attributeGeneratorProperties = this.mockDataSettings.getAttributeGeneratorProperties(attribute);
        if (generatorId == null) {
            generatorId = attributeGeneratorProperties.getSelectedGeneratorId();
        }
        if (attribute == this.selectedAttribute && Objects.equals(selectedGenerator = attributeGeneratorProperties.getSelectedGeneratorId(), generatorId)) {
            return;
        }
        this.selectedAttribute = attribute;
        this.mockDataSettings.setSelectedAttribute(attribute.getName());
        generatorId = attributeGeneratorProperties.setSelectedGeneratorId(generatorId);
        this.propertySource = attributeGeneratorProperties.getGeneratorPropertySource(generatorId);
        if (this.propertySource != null) {
            this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
            this.propsEditor.setExpandMode(PropertyTreeViewer.ExpandMode.FIRST);
            this.propsEditor.expandAll();
        } else {
            this.propsEditor.clearProperties();
        }
        this.presetCombo.setVisible(false);
        ArrayList<String> generators = new ArrayList<String>();
        for (String genId : attributeGeneratorProperties.getGenerators()) {
            generators.add(this.mockDataSettings.getGeneratorDescriptor(genId).getLabel());
        }
        this.generatorDescriptionLink.setVisible(false);
        if (!generators.isEmpty()) {
            List<MockGeneratorDescriptor.Preset> presets;
            this.generatorCombo.setItems(generators.toArray(new String[generators.size()]));
            MockGeneratorDescriptor generatorDescriptor = this.mockDataSettings.getGeneratorDescriptor(generatorId);
            this.generatorCombo.setText(generatorDescriptor.getLabel());
            this.generatorCombo.setEnabled(true);
            this.generatorDescriptionLabel.setText(generatorDescriptor.getDescription());
            if (!CommonUtils.isEmpty((String)generatorDescriptor.getLink())) {
                this.generatorDescriptionLink.setText("<a>" + generatorDescriptor.getLink() + "</a>");
                this.generatorLinkUrl = generatorDescriptor.getUrl();
                this.generatorDescriptionLink.setVisible(true);
            }
            if (!(presets = generatorDescriptor.getPresets()).isEmpty()) {
                this.presetCombo.removeAll();
                this.presetCombo.add("Select preset...");
                int presetIndex = 0;
                int i = 1;
                String presetId = attributeGeneratorProperties.getPresetId();
                for (MockGeneratorDescriptor.Preset preset : presets) {
                    this.presetCombo.add(preset.getLabel());
                    if (presetId != null && preset.getId().equals(presetId)) {
                        presetIndex = i;
                    }
                    ++i;
                }
                this.presetCombo.select(presetIndex);
                this.presetCombo.setVisible(true);
            }
        } else {
            this.generatorCombo.setItems(new String[]{"Not found"});
            this.generatorCombo.setText("Not found");
            this.generatorCombo.setEnabled(false);
            this.generatorDescriptionLabel.setText("");
        }
        this.generatorDescriptionLink.getParent().layout();
    }

    private void saveGeneratorProperties() {
        MockDataSettings.AttributeGeneratorProperties attributeGeneratorProperties;
        String selectedGenerator;
        if (this.selectedAttribute != null && (selectedGenerator = (attributeGeneratorProperties = this.mockDataSettings.getAttributeGeneratorProperties(this.selectedAttribute)).getSelectedGeneratorId()) != null) {
            attributeGeneratorProperties.putGeneratorPropertySource(selectedGenerator, this.propertySource);
        }
    }
}

