/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.informix;

import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class InformixUtils {
    static final Log log = Log.getLog(InformixUtils.class);

    /*
     * Exception decompiling
     */
    private static List<String> getSource(DBRProgressMonitor monitor, String sqlStatement, String dbObjectName, GenericDataSource datasource) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String ListToString(List<String> value, String delimiter) {
        StringBuilder sbResult = new StringBuilder();
        for (String o : value) {
            sbResult.append(o.trim());
            if (delimiter == null || delimiter.isEmpty()) continue;
            sbResult.append(delimiter);
        }
        return sbResult.toString();
    }

    public static String getProcedureSource(DBRProgressMonitor monitor, GenericProcedure procedure) throws DBException {
        String sqlProcedure = String.format("select b.data from sysprocbody b join sysprocedures p on b.procid=p.procid where datakey='T' and p.procname = '%s'order by b.procid, b.seqno", procedure.getName());
        return InformixUtils.ListToString(InformixUtils.getSource(monitor, sqlProcedure, procedure.getName(), (GenericDataSource)procedure.getDataSource()), null);
    }

    public static String getViewSource(DBRProgressMonitor monitor, GenericTable view) throws DBException {
        String sqlView = String.format("select v.viewtext from informix.sysviews v join systables s on s.tabid = v.tabid where s.tabname = '%s'", view.getName());
        return InformixUtils.ListToString(InformixUtils.getSource(monitor, sqlView, view.getName(), (GenericDataSource)view.getDataSource()), null);
    }

    public static String getTriggerDDL(DBRProgressMonitor monitor, GenericTable table) throws DBException {
        String sqlTrigger = String.format("select tb.data from systables ta join systriggers tr on tr.tabid = ta.tabid join systrigbody tb on tb.trigid = tr.trigid where ta.tabname = '%s' and ta.tabtype='T' and tb.datakey IN ('A', 'D') order by tr.trigname, datakey desc, seqno ", table.getName());
        return InformixUtils.ListToString(InformixUtils.getSource(monitor, sqlTrigger, table.getName(), (GenericDataSource)table.getDataSource()), "\n");
    }

    public static String getTriggerDDL(DBRProgressMonitor monitor, GenericTrigger trigger) throws DBException {
        assert (trigger.getTable() != null);
        String sqlTrigger = String.format("select tb.data from systables ta join systriggers tr on tr.tabid = ta.tabid join systrigbody tb on tb.trigid = tr.trigid where ta.tabname = '%s' and ta.tabtype='T' and tb.datakey IN ('A', 'D') and tr.trigname = '%s'order by tr.trigname, datakey desc, seqno ", trigger.getTable().getName(), trigger.getName());
        return InformixUtils.ListToString(InformixUtils.getSource(monitor, sqlTrigger, trigger.getName(), trigger.getDataSource()), "\n");
    }
}

