/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GenericTableColumnManager
extends SQLTableColumnManager<GenericTableColumn, GenericTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericTableColumn> getObjectsCache(GenericTableColumn object) {
        return ((GenericStructContainer)((GenericTable)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((DBSObject)((GenericTable)object.getParentObject()));
    }

    protected GenericTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, GenericTable parent, Object copyFrom) {
        DBSDataType columnType = GenericTableColumnManager.findBestDataType((DBPDataSource)parent.getDataSource(), (String[])DBConstants.DEFAULT_DATATYPE_NAMES);
        GenericTableColumn column = new GenericTableColumn(parent);
        column.setName(this.getNewColumnName(monitor, context, parent));
        column.setTypeName(columnType == null ? "INTEGER" : columnType.getName());
        column.setMaxLength(columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0);
        column.setValueType(columnType == null ? 4 : columnType.getTypeID());
        column.setOrdinalPosition(-1);
        return column;
    }

    public StringBuilder getNestedDeclaration(GenericTable owner, DBECommandAbstract<GenericTableColumn> command, Map<String, Object> options) {
        String autoIncrementClause;
        StringBuilder decl = super.getNestedDeclaration((JDBCTable)owner, command, options);
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        if (column.isAutoIncrement() && (autoIncrementClause = column.getDataSource().getMetaModel().getAutoIncrementClause(column)) != null && !autoIncrementClause.isEmpty()) {
            decl.append(" ").append(autoIncrementClause);
        }
        return decl;
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(GenericTableColumn column) {
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.DefaultModifier, this.NotNullModifier};
    }

    protected long getDDLFeatures(GenericTableColumn object) {
        long features = 0L;
        Object shortDrop = object.getDataSource().getContainer().getDriver().getDriverParameter("ddl-drop-column-short");
        if (shortDrop != null && CommonUtils.toBoolean((Object)shortDrop)) {
            features |= 1L;
        }
        return features;
    }
}

