/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolFunction;
import org.jkiss.dbeaver.ext.exasol.model.ExasolGlobalObject;
import org.jkiss.dbeaver.ext.exasol.model.ExasolScript;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableCache;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableForeignKeyCache;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableUniqueKeyCache;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolViewCache;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolJDBCObjectSimpleCacheLiterals;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class ExasolSchema
extends ExasolGlobalObject
implements DBSSchema,
DBPNamedObject2,
DBPRefreshableObject,
DBPSystemObject,
DBSProcedureContainer,
DBPScriptObject {
    private static final List<String> SYSTEM_SCHEMA = Arrays.asList("SYS", "EXA_STATISTICS");
    private String name;
    private String owner;
    private Timestamp createTime;
    private String remarks;
    public final DBSObjectCache<ExasolSchema, ExasolScript> scriptCache;
    public final DBSObjectCache<ExasolSchema, ExasolFunction> functionCache;
    private ExasolViewCache viewCache = new ExasolViewCache();
    private ExasolTableCache tableCache = new ExasolTableCache();
    private final ExasolTableUniqueKeyCache constraintCache = new ExasolTableUniqueKeyCache(this.tableCache);
    private final ExasolTableForeignKeyCache associationCache = new ExasolTableForeignKeyCache(this.tableCache);

    public ExasolSchema(ExasolDataSource exasolDataSource, String name, String owner) {
        super(exasolDataSource, true);
        this.name = name;
        this.owner = owner;
        this.scriptCache = new ExasolJDBCObjectSimpleCacheLiterals(ExasolScript.class, "select script_name,script_owner,script_language,script_type,script_result_type,script_text,script_comment,b.created from EXA_ALL_SCRIPTS a inner join EXA_ALL_OBJECTS b on a.script_name = b.object_name and a.script_schema = b.root_name and b.object_type = 'SCRIPT' where a.script_schema = '%s' order by script_name", name);
        this.functionCache = new ExasolJDBCObjectSimpleCacheLiterals(ExasolFunction.class, "SELECT\n    F.*,\n    O.CREATED\nFROM\n    SYS.EXA_ALL_FUNCTIONS F\nINNER JOIN SYS.EXA_ALL_OBJECTS O ON\n    F.FUNCTION_SCHEMA = O.ROOT_NAME\n    AND F.FUNCTION_NAME = O.OBJECT_NAME and o.object_type = 'FUNCTION'\nWHERE\n    F.FUNCTION_SCHEMA = '%s' and O.OBJECT_TYPE = 'FUNCTION'\nORDER BY\n    FUNCTION_NAME\n", name);
    }

    public ExasolSchema(ExasolDataSource exasolDataSource, ResultSet dbResult) throws DBException {
        this(exasolDataSource, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"OBJECT_NAME"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER"));
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_COMMENT");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME");
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<ExasolTableBase> getChildren(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolTableBase> allChildren = new ArrayList<ExasolTableBase>();
        allChildren.addAll(this.tableCache.getAllObjects(monitor, this));
        allChildren.addAll(this.viewCache.getAllObjects(monitor, this));
        return allChildren;
    }

    public ExasolTableBase getChild(DBRProgressMonitor monitor, String childName) throws DBException {
        ExasolTableBase child = (ExasolTableBase)this.tableCache.getObject(monitor, this, childName);
        if (child == null) {
            child = (ExasolTableBase)this.viewCache.getObject(monitor, this, childName);
        }
        return child;
    }

    public Class<ExasolTableBase> getChildType(DBRProgressMonitor monitor) throws DBException {
        return ExasolTableBase.class;
    }

    public void cacheStructure(DBRProgressMonitor monitor, int scope) throws DBException {
        if ((scope & 1) != 0) {
            monitor.subTask("Cache tables");
            this.tableCache.getAllObjects(monitor, this);
            monitor.subTask("Cache Views");
            this.viewCache.getAllObjects(monitor, this);
        }
        if ((scope & 2) != 0) {
            monitor.subTask("Cache table columns");
            this.tableCache.loadChildren(monitor, this, null);
            monitor.subTask("Cache Views");
            this.viewCache.loadChildren(monitor, this, null);
        }
        if ((scope & 4) != 0) {
            monitor.subTask("Cache table unique keys");
            this.constraintCache.getObjects(monitor, this, null);
            monitor.subTask("Cache table foreign keys");
            this.associationCache.getObjects(monitor, this, null);
        }
    }

    @Association
    public Collection<ExasolTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, ExasolTable.class);
    }

    public ExasolTable getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolTable)this.tableCache.getObject(monitor, this, name, ExasolTable.class);
    }

    @Association
    public Collection<ExasolView> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.viewCache.getTypedObjects(monitor, this, ExasolView.class);
    }

    public ExasolView getView(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolView)this.viewCache.getObject(monitor, this, name, ExasolView.class);
    }

    public boolean isSystem() {
        return SYSTEM_SCHEMA.contains(this.name);
    }

    public Collection<ExasolScript> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.scriptCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolScript getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return (ExasolScript)this.scriptCache.getObject(monitor, (DBSObject)this, uniqueName);
    }

    public Collection<ExasolFunction> getFunctions(DBRProgressMonitor monitor) throws DBException {
        return this.functionCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolFunction getFunction(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolFunction)this.functionCache.getObject(monitor, (DBSObject)this, name);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((ExasolDataSource)this.getDataSource()).refreshObject(monitor);
        this.functionCache.clearCache();
        this.scriptCache.clearCache();
        this.tableCache.clearCache();
        this.viewCache.clearCache();
        this.constraintCache.clearCache();
        this.associationCache.clearCache();
        return this;
    }

    public String toString() {
        return "Schema " + this.name;
    }

    @Property(viewable=true, editable=false, order=2)
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Override
    @Property(viewable=true, editable=true, updatable=true, order=3)
    public String getDescription() {
        return this.remarks;
    }

    public void setDescription(String newRemarks) {
        this.remarks = newRemarks;
    }

    @Property(viewable=true, editable=false, updatable=true, order=4)
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ExasolTableCache getTableCache() {
        return this.tableCache;
    }

    public ExasolViewCache getViewCache() {
        return this.viewCache;
    }

    public ExasolTableUniqueKeyCache getConstraintCache() {
        return this.constraintCache;
    }

    public ExasolTableForeignKeyCache getAssociationCache() {
        return this.associationCache;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return ExasolUtils.generateDDLforSchema(monitor, this);
    }

    public Boolean isPhysicalSchema() {
        return true;
    }
}

