/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.ExasolDataSourceProvider;
import org.jkiss.dbeaver.ext.exasol.ExasolSQLDialect;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolBaseObjectGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolConnectionGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolGrantee;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolRole;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolRoleGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolSchemaGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolScriptGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolSystemGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolTableGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolTableObjectType;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolUser;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolViewGrant;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConnection;
import org.jkiss.dbeaver.ext.exasol.model.ExasolCurrentUserPrivileges;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSourceInfo;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataType;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolStructureAssistant;
import org.jkiss.dbeaver.ext.exasol.model.ExasolVirtualSchema;
import org.jkiss.dbeaver.ext.exasol.model.plan.ExasolPlanAnalyser;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class ExasolDataSource
extends JDBCDataSource
implements DBSObjectSelector,
DBCQueryPlanner,
IAdaptable {
    private static final Log LOG = Log.getLog(ExasolDataSource.class);
    private static final String GET_CURRENT_SCHEMA = "SELECT CURRENT_SCHEMA";
    private static final String SET_CURRENT_SCHEMA = "OPEN SCHEMA \"%s\"";
    private DBSObjectCache<ExasolDataSource, ExasolSchema> schemaCache;
    private DBSObjectCache<ExasolDataSource, ExasolVirtualSchema> virtualSchemaCache;
    private ExasolCurrentUserPrivileges exasolCurrentUserPrivileges;
    private DBSObjectCache<ExasolDataSource, ExasolUser> userCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolRole> roleCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolConnection> connectionCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolDataType> dataTypeCache = new JDBCObjectSimpleCache(ExasolDataType.class, "SELECT * FROM EXA_SQL_TYPES", new Object[0]);
    private DBSObjectCache<ExasolDataSource, ExasolRoleGrant> roleGrantCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolSystemGrant> systemGrantCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolConnectionGrant> connectionGrantCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolBaseObjectGrant> baseTableGrantCache = null;
    private int driverMajorVersion = 5;
    private String activeSchemaName;
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile("(.+)\\[line ([0-9]+), column ([0-9]+)\\]");

    public ExasolDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new ExasolSQLDialect());
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load data source meta info");){
                this.activeSchemaName = this.determineActiveSchema(session);
                this.exasolCurrentUserPrivileges = new ExasolCurrentUserPrivileges(monitor, session, this);
                this.driverMajorVersion = session.getMetaData().getDriverMajorVersion();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error reading active schema", (Throwable)e);
        }
        String schemaSQL = "select b.object_name,b.owner,b.created,b.object_comment from EXA_ALL_OBJECTS b  inner join EXA_SCHEMAS s on b.object_name = s.schema_name  where b.object_type = 'SCHEMA' ";
        if (this.exasolCurrentUserPrivileges.getatLeastV6().booleanValue()) {
            schemaSQL = String.valueOf(schemaSQL) + " and not schema_is_virtual ";
            this.virtualSchemaCache = new JDBCObjectSimpleCache(ExasolVirtualSchema.class, "select\tSCHEMA_NAME as OBJECT_NAME,\tSCHEMA_OWNER AS OWNER,\tADAPTER_SCRIPT,\tLAST_REFRESH,\tLAST_REFRESH_BY,\tADAPTER_NOTES,\tOBJECT_COMMENT,\tCREATED from\t\tEXA_VIRTUAL_SCHEMAS s\tINNER JOIN\t\tEXA_ALL_OBJECTS o\tON\t\to.OBJECT_NAME = s.SCHEMA_NAME AND\t\to.OBJECT_TYPE = 'SCHEMA'", new Object[0]);
        }
        schemaSQL = String.valueOf(schemaSQL) + " union all select distinct SCHEMA_NAME as \"OBJECT_NAME\", 'SYS' as owner, cast(null as timestamp) as created, '' as \"OBJECT_COMMENT\" from SYS.EXA_SYSCAT order by b.object_name";
        this.schemaCache = new JDBCObjectSimpleCache(ExasolSchema.class, schemaSQL, new Object[0]);
        try {
            this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        }
        catch (DBException e) {
            LOG.warn((Object)"Error reading types info", (Throwable)e);
            this.dataTypeCache.setCache(Collections.emptyList());
        }
        if (this.exasolCurrentUserPrivileges.getUserIsAuthorizedForUsers().booleanValue()) {
            this.userCache = new JDBCObjectSimpleCache(ExasolUser.class, "select * from EXA_DBA_USERS ORDER BY USER_NAME", new Object[0]);
        }
        if (this.exasolCurrentUserPrivileges.getUserIsAuthorizedForRoles().booleanValue()) {
            this.roleCache = new JDBCObjectSimpleCache(ExasolRole.class, "SELECT * FROM EXA_DBA_ROLES ORDER BY ROLE_NAME", new Object[0]);
        }
        this.connectionCache = this.exasolCurrentUserPrivileges.getUserIsAuthorizedForConnections() != false ? new JDBCObjectSimpleCache(ExasolConnection.class, "SELECT * FROM SYS.EXA_DBA_CONNECTIONS ORDER BY CONNECTION_NAME", new Object[0]) : new JDBCObjectSimpleCache(ExasolConnection.class, "SELECT * FROM SYS.EXA_SESSION_CONNECTIONS ORDER BY CONNECTION_NAME", new Object[0]);
        if (this.exasolCurrentUserPrivileges.getUserIsAuthorizedForConnectionPrivs().booleanValue()) {
            this.connectionGrantCache = new JDBCObjectSimpleCache(ExasolConnectionGrant.class, "SELECT c.*,P.ADMIN_OPTION,P.GRANTEE FROM SYS.EXA_DBA_CONNECTION_PRIVS P INNER JOIN SYS.EXA_DBA_CONNECTIONS C on P.GRANTED_CONNECTION = C.CONNECTION_NAME ORDER BY P.GRANTEE,C.CONNECTION_NAME ", new Object[0]);
        }
        if (this.exasolCurrentUserPrivileges.getUserIsAuthorizedForObjectPrivs().booleanValue()) {
            this.baseTableGrantCache = new JDBCObjectSimpleCache(ExasolBaseObjectGrant.class, "SELECT \tOBJECT_SCHEMA,\tOBJECT_TYPE,\tGRANTEE,\tOBJECT_NAME,\tGROUP_CONCAT(\t\tDISTINCT PRIVILEGE\tORDER BY\t\tOBJECT_SCHEMA,\t\tOBJECT_NAME\t\tSEPARATOR '|'\t) as PRIVS  FROM\tSYS.EXA_DBA_OBJ_PRIVS P GROUP BY\tOBJECT_SCHEMA,\tOBJECT_TYPE,\tGRANTEE,\tOBJECT_NAME ORDER BY GRANTEE,OBJECT_SCHEMA,OBJECT_TYPE,OBJECT_NAME", new Object[0]);
        }
        if (this.exasolCurrentUserPrivileges.getUserIsAuthorizedForSystemPrivs().booleanValue()) {
            this.systemGrantCache = new JDBCObjectSimpleCache(ExasolSystemGrant.class, "SELECT GRANTEE,PRIVILEGE,ADMIN_OPTION FROM SYS.EXA_DBA_SYS_PRIVS ORDER BY GRANTEE,PRIVILEGE", new Object[0]);
        }
        if (this.exasolCurrentUserPrivileges.getUserIsAuthorizedForRolePrivs().booleanValue()) {
            this.roleGrantCache = new JDBCObjectSimpleCache(ExasolRoleGrant.class, "select r.*,p.ADMIN_OPTION,p.GRANTEE from EXA_DBA_ROLES r INNER JOIN  EXA_DBA_ROLE_PRIVS p ON p.GRANTED_ROLE = r.ROLE_NAME ORDER BY P.GRANTEE,R.ROLE_NAME", new Object[0]);
        }
    }

    int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        while (error instanceof DBException) {
            if (error.getCause() == null) {
                return null;
            }
            error = error.getCause();
        }
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message)) {
            Matcher matcher = this.ERROR_POSITION_PATTERN.matcher(message);
            ArrayList<DBPErrorAssistant.ErrorPosition> positions = new ArrayList<DBPErrorAssistant.ErrorPosition>();
            while (matcher.find()) {
                DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                pos.info = matcher.group(1);
                pos.line = Integer.parseInt(matcher.group(2)) - 1;
                pos.position = Integer.parseInt(matcher.group(3)) - 1;
                positions.add(pos);
            }
            if (!positions.isEmpty()) {
                return positions.toArray(new DBPErrorAssistant.ErrorPosition[positions.size()]);
            }
        }
        return null;
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, boolean setActiveObject) throws DBCException {
        if (setActiveObject) {
            this.setCurrentSchema(monitor, context, this.getDefaultObject());
        }
    }

    private String determineActiveSchema(JDBCSession session) throws SQLException {
        String defSchema = JDBCUtils.queryString((JDBCSession)session, (String)GET_CURRENT_SCHEMA, (Object[])new Object[0]);
        if (defSchema == null) {
            return "";
        }
        return defSchema.trim();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new ExasolStructureAssistant(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    protected String getConnectionUserName(@NotNull DBPConnectionConfiguration connectionInfo) {
        return connectionInfo.getUserName();
    }

    @NotNull
    public ExasolDataSource getDataSource() {
        return this;
    }

    protected DBPDataSourceInfo createDataSourceInfo(@NotNull JDBCDatabaseMetaData metaData) {
        ExasolDataSourceInfo info = new ExasolDataSourceInfo(metaData);
        info.setSupportsResultSetScroll(false);
        return info;
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, String purpose) throws DBCException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(ExasolDataSourceProvider.getConnectionsProps());
        return props;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.schemaCache.clearCache();
        if (this.userCache != null) {
            this.userCache.clearCache();
        }
        this.dataTypeCache.clearCache();
        if (this.roleCache != null) {
            this.roleCache.clearCache();
        }
        if (this.connectionCache != null) {
            this.connectionCache.clearCache();
        }
        if (this.connectionGrantCache != null) {
            this.connectionGrantCache.clearCache();
        }
        if (this.baseTableGrantCache != null) {
            this.baseTableGrantCache.clearCache();
        }
        if (this.systemGrantCache != null) {
            this.systemGrantCache.clearCache();
        }
        if (this.roleCache != null) {
            this.roleCache.clearCache();
        }
        this.initialize(monitor);
        return this;
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public Class<? extends ExasolSchema> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ExasolSchema.class;
    }

    public Collection<ExasolSchema> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        Collection<ExasolSchema> totalList = this.getSchemas(monitor);
        if (this.exasolCurrentUserPrivileges.getatLeastV6().booleanValue()) {
            totalList.addAll(this.getVirtualSchemas(monitor));
        }
        return totalList;
    }

    public ExasolSchema getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        if (this.exasolCurrentUserPrivileges.getatLeastV6().booleanValue()) {
            return this.getSchema(monitor, childName) != null ? this.getSchema(monitor, childName) : this.getVirtualSchema(monitor, childName);
        }
        return this.getSchema(monitor, childName);
    }

    public ExasolSchema getDefaultObject() {
        return this.activeSchemaName == null ? null : (ExasolSchema)this.schemaCache.getCachedObject(this.activeSchemaName);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        ExasolSchema oldSelectedEntity = this.getDefaultObject();
        if (!(object instanceof ExasolSchema)) {
            throw new IllegalArgumentException("Invalid object type: " + object);
        }
        JDBCExecutionContext[] jDBCExecutionContextArray = this.getAllContexts();
        int n = jDBCExecutionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCExecutionContext context = jDBCExecutionContextArray[n2];
            this.setCurrentSchema(monitor, context, (ExasolSchema)object);
            ++n2;
        }
        this.activeSchemaName = object.getName();
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        if (this.activeSchemaName != null) {
            DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
        }
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        try {
            ExasolSchema newSchema;
            String newSchemaName = this.determineActiveSchema((JDBCSession)session);
            if (!CommonUtils.equalObjects((Object)newSchemaName, (Object)this.activeSchemaName) && (newSchema = (ExasolSchema)this.schemaCache.getCachedObject(newSchemaName)) != null) {
                this.setDefaultObject(session.getProgressMonitor(), newSchema);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)this);
        }
    }

    private void setCurrentSchema(DBRProgressMonitor monitor, JDBCExecutionContext executionContext, ExasolSchema object) throws DBCException {
        if (object == null) {
            LOG.debug((Object)"Null current schema");
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                JDBCUtils.executeSQL((Connection)session, (String)String.format(SET_CURRENT_SCHEMA, object.getName()), (Object[])new Object[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this);
        }
    }

    @Association
    public Collection<ExasolSchema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        return this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolSchema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<ExasolVirtualSchema> getVirtualSchemas(DBRProgressMonitor monitor) throws DBException {
        return this.virtualSchemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolVirtualSchema getVirtualSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolVirtualSchema)this.virtualSchemaCache.getObject(monitor, (DBSObject)this, name);
    }

    public Collection<ExasolGrantee> getAllGrantees(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolGrantee> grantees = new ArrayList<ExasolGrantee>();
        for (ExasolUser user : this.getUsers(monitor)) {
            grantees.add(user);
        }
        for (ExasolRole role : this.getRoles(monitor)) {
            grantees.add(role);
        }
        return grantees;
    }

    @Association
    public Collection<ExasolUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolUser getUser(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolUser)this.userCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<ExasolRole> getRoles(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolRole getRole(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolRole)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<ExasolConnection> getConnections(DBRProgressMonitor monitor) throws DBException {
        return this.connectionCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolConnection getConnection(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolConnection)this.connectionCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<ExasolBaseObjectGrant> getBaseTableGrants(DBRProgressMonitor monitor) throws DBException {
        return this.baseTableGrantCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<ExasolTableGrant> getTableGrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolTableGrant> grants = new ArrayList<ExasolTableGrant>();
        for (ExasolBaseObjectGrant grant : this.getBaseTableGrants(monitor)) {
            if (grant.getType() != ExasolTableObjectType.TABLE) continue;
            grants.add(new ExasolTableGrant(monitor, grant));
        }
        return grants;
    }

    public Collection<ExasolViewGrant> getViewGrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolViewGrant> grants = new ArrayList<ExasolViewGrant>();
        for (ExasolBaseObjectGrant grant : this.getBaseTableGrants(monitor)) {
            if (grant.getType() != ExasolTableObjectType.VIEW) continue;
            grants.add(new ExasolViewGrant(grant));
        }
        return grants;
    }

    public Collection<ExasolScriptGrant> getScriptGrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolScriptGrant> grants = new ArrayList<ExasolScriptGrant>();
        for (ExasolBaseObjectGrant grant : this.getBaseTableGrants(monitor)) {
            if (grant.getType() != ExasolTableObjectType.SCRIPT) continue;
            grants.add(new ExasolScriptGrant(grant));
        }
        return grants;
    }

    public Collection<ExasolSchemaGrant> getSchemaGrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolSchemaGrant> grants = new ArrayList<ExasolSchemaGrant>();
        for (ExasolBaseObjectGrant grant : this.getBaseTableGrants(monitor)) {
            if (grant.getType() != ExasolTableObjectType.SCHEMA) continue;
            grants.add(new ExasolSchemaGrant(grant));
        }
        return grants;
    }

    public Collection<ExasolConnectionGrant> getConnectionGrants(DBRProgressMonitor monitor) throws DBException {
        return this.connectionGrantCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<ExasolSystemGrant> getSystemGrants(DBRProgressMonitor monitor) throws DBException {
        return this.systemGrantCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<ExasolRoleGrant> getRoleGrants(DBRProgressMonitor monitor) throws DBException {
        return this.roleGrantCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<ExasolDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolDataType getDataType(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolDataType)this.dataTypeCache.getObject(monitor, (DBSObject)this, name);
    }

    public Boolean hasAlterUserPrivilege() {
        return this.exasolCurrentUserPrivileges.UserHasAlterUserPriv();
    }

    public boolean isAuthorizedForUsers() {
        return this.exasolCurrentUserPrivileges.getUserIsAuthorizedForUsers();
    }

    public boolean isAuthorizedForConnections() {
        return this.exasolCurrentUserPrivileges.getUserIsAuthorizedForConnections();
    }

    public boolean isAuthorizedForRoles() {
        return this.exasolCurrentUserPrivileges.getUserIsAuthorizedForRoles();
    }

    public boolean isAuthorizedForRolePrivs() {
        return this.exasolCurrentUserPrivileges.getUserIsAuthorizedForRolePrivs();
    }

    public boolean isUserAuthorizedForSessions() {
        return this.exasolCurrentUserPrivileges.isUserAuthorizedForSessions();
    }

    public boolean isatLeastV6() {
        return this.exasolCurrentUserPrivileges.getatLeastV6();
    }

    public boolean isatLeastV5() {
        return this.exasolCurrentUserPrivileges.getatLeastV5();
    }

    public boolean isAuthorizedForConnectionPrivs() {
        return this.exasolCurrentUserPrivileges.getUserIsAuthorizedForConnectionPrivs();
    }

    public boolean isAuthorizedForObjectPrivs() {
        return this.exasolCurrentUserPrivileges.getUserIsAuthorizedForObjectPrivs();
    }

    public DBSObjectCache<ExasolDataSource, ExasolConnection> getConnectionCache() {
        return this.connectionCache;
    }

    public DBSObjectCache<ExasolDataSource, ExasolUser> getUserCache() {
        return this.userCache;
    }

    public DBSObjectCache<ExasolDataSource, ExasolRole> getRoleCache() {
        return this.roleCache;
    }

    public DBSObjectCache<ExasolDataSource, ExasolSchema> getSchemaCache() {
        return this.schemaCache;
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        try {
            return this.getDataTypes((DBRProgressMonitor)new VoidProgressMonitor());
        }
        catch (DBException e) {
            LOG.error((Object)"DBException occured when reading system dataTypes: ", (Throwable)e);
            return null;
        }
    }

    public String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        Object connecttimeout;
        Object querytimeout;
        Object propClientName;
        String port = ":8563";
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            port = ":" + connectionInfo.getHostPort();
        }
        Map properties = connectionInfo.getProperties();
        StringBuilder url = new StringBuilder(128);
        url.append("jdbc:exa:").append(connectionInfo.getHostName()).append(port);
        String backupHostList = connectionInfo.getProviderProperty("@dbeaver-backupHostList");
        if (!CommonUtils.isEmpty((String)backupHostList)) {
            url.append(",").append(backupHostList).append(port);
        }
        if (!url.toString().toUpperCase().contains("CLIENTNAME")) {
            String clientName = Platform.getProduct().getName();
            propClientName = properties.get("clientname");
            if (propClientName != null) {
                clientName = propClientName.toString();
            }
            url.append(";clientname=").append(clientName);
        }
        if (!url.toString().toUpperCase().contains("CLIENTVERSION")) {
            String clientVersion = Platform.getProduct().getDefiningBundle().getVersion().toString();
            propClientName = properties.get("clientversion");
            if (propClientName != null) {
                clientVersion = propClientName.toString();
            }
            url.append(";clientversion=").append(clientVersion);
        }
        if ((querytimeout = properties.get("querytimeout")) != null) {
            url.append(";").append("querytimeout").append("=").append(querytimeout);
        }
        if ((connecttimeout = properties.get("connecttimeout")) != null) {
            url.append(";").append("connecttimeout").append("=").append(connecttimeout);
        }
        return url.toString();
    }

    public DBSDataType getLocalDataType(String typeName) {
        try {
            return this.getDataType((DBRProgressMonitor)new VoidProgressMonitor(), typeName);
        }
        catch (DBException e) {
            LOG.error((Object)("DBException occured when reading system dataType: " + typeName), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query) throws DBCException {
        ExasolPlanAnalyser plan = new ExasolPlanAnalyser(this, query);
        plan.explain(session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    DBSObjectCache<ExasolDataSource, ExasolDataType> getDataTypeCache() {
        return this.dataTypeCache;
    }

    public ExasolCurrentUserPrivileges getUserPriviliges() {
        return this.exasolCurrentUserPrivileges;
    }
}

