/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class ExasolCurrentUserPrivileges {
    private static final String C_CONNECTIONS = "SELECT CONNECTION_NAME FROM EXA_DBA_CONNECTIONS WHERE FALSE";
    private static final String C_USERS = "SELECT USER_NAME FROM EXA_DBA_USERS WHERE FALSE";
    private static final String C_OBJECT_PRIV = "SELECT OBJECT_NAME FROM EXA_DBA_OBJ_PRIVS WHERE FALSE";
    private static final String C_CONNECTION_PRIV = "SELECT GRANTEE FROM EXA_DBA_CONNECTION_PRIVS WHERE FALSE";
    private static final String C_ROLES = "SELECT ROLE_NAME FROM EXA_DBA_ROLES WHERE FALSE";
    private static final String C_ROLE_PRIVS = "SELECT ROLE_NAME FROM EXA_DBA_ROLE_PRIVS WHERE FALSE";
    private static final String C_VERSION = "select TO_NUMBER(\"VALUE\") AS VERSION from \"$ODBCJDBC\".DB_METADATA WHERE name LIKE 'databaseMajorVersion'";
    private static final String C_ALTER_USER = "SELECT\r\n\tCASE\r\n\t\tWHEN SUM( ANZAHL )> 0 THEN TRUE\r\n\t\tELSE FALSE\r\n\tEND AS HAS_ALTER_USER\r\nFROM\r\n\t(\r\n\t\tSELECT\r\n\t\t\tCOUNT(*) AS ANZAHL\r\n\t\tFROM\r\n\t\t\tsys.EXA_ROLE_SYS_PRIVS\r\n\t\tWHERE\r\n\t\t\tPRIVILEGE = 'ALTER USER'\r\n\tUNION ALL SELECT\r\n\t\t\tCOUNT(*) AS ANZAHL\r\n\t\tFROM\r\n\t\t\tSYS.EXA_USER_SYS_PRIVS\r\n\t\tWHERE\r\n\t\t\tPRIVILEGE = 'ALTER USER'\r\n\t)";
    private final Boolean userIsAuthorizedForConnections;
    private final Boolean userIsAuthorizedForUsers;
    private final Boolean userIsAuthorizedForRoles;
    private final Boolean userIsAuthorizedForRolePrivs;
    private final Boolean userIsAuthorizedForObjectPrivs;
    private final Boolean userIsAuthorizedForConnectionPrivs;
    private final Boolean userIsAuthorizedForSystemPrivs;
    private final Boolean userIsAuthorizedForSessions;
    private final Boolean userHasAlterUserPriv;
    private final int ExasolVersion;

    public ExasolCurrentUserPrivileges(DBRProgressMonitor monitor, JDBCSession session, ExasolDataSource exasolDataSource) throws DBException {
        this.userIsAuthorizedForConnections = ExasolCurrentUserPrivileges.verifyPriv(C_CONNECTIONS, session);
        this.userIsAuthorizedForUsers = ExasolCurrentUserPrivileges.verifyPriv(C_USERS, session);
        this.userIsAuthorizedForRolePrivs = ExasolCurrentUserPrivileges.verifyPriv(C_ROLE_PRIVS, session);
        this.userIsAuthorizedForRoles = ExasolCurrentUserPrivileges.verifyPriv(C_ROLES, session);
        this.userIsAuthorizedForObjectPrivs = ExasolCurrentUserPrivileges.verifyPriv(C_OBJECT_PRIV, session);
        this.userIsAuthorizedForConnectionPrivs = ExasolCurrentUserPrivileges.verifyPriv(C_CONNECTION_PRIV, session);
        this.userIsAuthorizedForSystemPrivs = ExasolCurrentUserPrivileges.verifyPriv("SELECT GRANTEE,PRIVILEGE,ADMIN_OPTION FROM SYS.EXA_DBA_SYS_PRIVS WHERE FALSE", session);
        this.userIsAuthorizedForSessions = ExasolCurrentUserPrivileges.verifyPriv("SELECT * FROM SYS.EXA_DBA_SESSIONS", session);
        this.userHasAlterUserPriv = ExasolCurrentUserPrivileges.verifyPriv(C_ALTER_USER, session);
        try {
            JDBCPreparedStatement dbStat = session.prepareStatement(C_VERSION);
            JDBCResultSet rs = dbStat.executeQuery();
            rs.next();
            this.ExasolVersion = JDBCUtils.safeGetInt((ResultSet)rs, (String)"VERSION");
            rs.close();
            dbStat.close();
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)exasolDataSource);
        }
    }

    public int getExasolVersion() {
        return this.ExasolVersion;
    }

    public Boolean getatLeastV5() {
        if (this.ExasolVersion >= 5) {
            return true;
        }
        return false;
    }

    public Boolean getatLeastV6() {
        if (this.ExasolVersion >= 6) {
            return true;
        }
        return false;
    }

    public Boolean getUserIsAuthorizedForRoles() {
        return this.userIsAuthorizedForRoles;
    }

    public Boolean getUserIsAuthorizedForRolePrivs() {
        return this.userIsAuthorizedForRolePrivs;
    }

    public Boolean getUserIsAuthorizedForSystemPrivs() {
        return this.userIsAuthorizedForSystemPrivs;
    }

    private static Boolean verifyPriv(String sql, JDBCSession session) {
        Boolean hasPriv;
        try {
            JDBCPreparedStatement dbStat = session.prepareStatement(C_CONNECTIONS);
            JDBCResultSet rs = dbStat.executeQuery();
            rs.close();
            dbStat.close();
            hasPriv = true;
        }
        catch (SQLException sQLException) {
            hasPriv = false;
        }
        return hasPriv;
    }

    public Boolean getUserIsAuthorizedForConnections() {
        return this.userIsAuthorizedForConnections;
    }

    public Boolean getUserIsAuthorizedForUsers() {
        return this.userIsAuthorizedForUsers;
    }

    public Boolean getUserIsAuthorizedForObjectPrivs() {
        return this.userIsAuthorizedForObjectPrivs;
    }

    public Boolean getUserIsAuthorizedForConnectionPrivs() {
        return this.userIsAuthorizedForConnectionPrivs;
    }

    public Boolean isUserAuthorizedForSessions() {
        return this.userIsAuthorizedForSessions;
    }

    public Boolean UserHasAlterUserPriv() {
        return this.userHasAlterUserPriv;
    }
}

