/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class ExasolTableManager
extends SQLTableManager<ExasolTable, ExasolSchema>
implements DBEObjectRenamer<ExasolTable> {
    private static final String NEW_TABLE_NAME = "NEW_TABLE";
    private static final String SQL_ALTER = "ALTER TABLE ";
    private static final String SQL_RENAME_TABLE = "RENAME TABLE %s TO %s";
    private static final String SQL_COMMENT = "COMMENT ON TABLE %s IS '%s'";
    private static final String CMD_ALTER = "Alter Table";
    private static final String CMD_COMMENT = "Comment on Table";
    private static final String CMD_RENAME = "Rename Table";
    private static final Class<?>[] CHILD_TYPES = new Class[]{ExasolTableColumn.class, ExasolTableUniqueKey.class, ExasolTableForeignKey.class};

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public DBSObjectCache<ExasolSchema, ExasolTable> getObjectsCache(ExasolTable object) {
        return object.getSchema().getTableCache();
    }

    public ExasolTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, ExasolSchema exasolSchema, Object copyFrom) {
        ExasolTable table = new ExasolTable(exasolSchema, NEW_TABLE_NAME);
        try {
            this.setTableName(monitor, (DBSObjectContainer)exasolSchema, table);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return table;
    }

    public void appendTableModifiers(ExasolTable exasolTable, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl) {
    }

    public void addStructObjectCreateActions(List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) {
        super.addStructObjectCreateActions(actions, command, options);
        DBEPersistAction commentAction = this.buildCommentAction((ExasolTable)command.getObject());
        if (commentAction != null) {
            actions.add(commentAction);
        }
    }

    public void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        DBEPersistAction commentAction;
        ExasolTable exasolTable = (ExasolTable)command.getObject();
        if (command.getProperties().size() > 1) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(SQL_ALTER);
            sb.append(exasolTable.getFullyQualifiedName(DBPEvaluationContext.DDL));
            sb.append(" ");
            this.appendTableModifiers((ExasolTable)command.getObject(), (SQLObjectEditor.NestedObjectCommand)command, sb);
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(CMD_ALTER, sb.toString()));
        }
        if ((commentAction = this.buildCommentAction(exasolTable)) != null) {
            actionList.add(commentAction);
        }
    }

    public void addObjectRenameActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        String sql = String.format(SQL_RENAME_TABLE, ((ExasolTable)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL), command.getNewName());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(CMD_RENAME, sql));
    }

    public void renameObject(DBECommandContext commandContext, ExasolTable object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    private DBEPersistAction buildCommentAction(ExasolTable exasolTable) {
        if (CommonUtils.isNotEmpty((String)exasolTable.getDescription())) {
            String commentSQL = String.format(SQL_COMMENT, exasolTable.getFullyQualifiedName(DBPEvaluationContext.DDL), exasolTable.getDescription());
            return new SQLDatabasePersistAction(CMD_COMMENT, commentSQL);
        }
        return null;
    }
}

