/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class ExasolTableColumnManager
extends SQLTableColumnManager<ExasolTableColumn, ExasolTableBase>
implements DBEObjectRenamer<ExasolTableColumn> {
    private static final String SQL_ALTER = "ALTER TABLE %s MODIFY COLUMN %s ";
    private static final String SQL_COMMENT = "COMMENT ON COLUMN %s.%s IS '%s'";
    private static final String CMD_ALTER = "Alter Column";
    private static final String CMD_COMMENT = "Comment on Column";

    @Nullable
    public DBSObjectCache<? extends DBSObject, ExasolTableColumn> getObjectsCache(ExasolTableColumn object) {
        return ((ExasolSchema)((ExasolTableBase)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((ExasolTable)object.getParentObject());
    }

    public boolean canEditObject(ExasolTableColumn object) {
        ExasolTableBase exasolTableBase = (ExasolTableBase)object.getParentObject();
        return exasolTableBase != null & exasolTableBase.getClass().equals(ExasolTable.class);
    }

    protected ExasolTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, ExasolTableBase parent, Object copyFrom) {
        ExasolTableColumn column = new ExasolTableColumn(parent);
        column.setName(this.getNewColumnName(monitor, context, parent));
        return column;
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        DBEPersistAction commentAction;
        ExasolTableColumn exasolColumn = (ExasolTableColumn)command.getObject();
        if (!command.getProperties().isEmpty()) {
            String deltaSQL;
            String nullability = "";
            if (exasolColumn.isOriRequired() != null && exasolColumn.isOriRequired().booleanValue() != exasolColumn.isRequired()) {
                nullability = exasolColumn.isRequired() ? "NOT NULL" : "NULL";
            }
            if (!(deltaSQL = String.valueOf(exasolColumn.getName()) + " " + exasolColumn.getFormatType() + " " + (exasolColumn.getDefaultValue() == null ? "" : " DEFAULT " + exasolColumn.getDefaultValue()) + " " + this.formatIdentiy(exasolColumn.isAutoGenerated(), exasolColumn.getIdentityValue()) + " " + nullability).isEmpty()) {
                String sqlAlterColumn = String.format(SQL_ALTER, ((ExasolTableBase)exasolColumn.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL), deltaSQL);
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction(CMD_ALTER, sqlAlterColumn));
            }
        }
        if ((commentAction = this.buildCommentAction(exasolColumn)) != null) {
            actionList.add(commentAction);
        }
    }

    private String formatIdentiy(Boolean isAutoGenerated, BigDecimal identityValue) {
        String ret = "";
        if (isAutoGenerated.booleanValue()) {
            ret = "IDENTITY ";
            if (identityValue != null) {
                ret = String.valueOf(ret) + identityValue.toString() + " ";
            }
        }
        return ret;
    }

    private DBEPersistAction buildCommentAction(ExasolTableColumn exasolColumn) {
        if (CommonUtils.isNotEmpty((String)exasolColumn.getDescription())) {
            String tableName = ((ExasolTableBase)exasolColumn.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
            String columnName = exasolColumn.getName();
            String comment = exasolColumn.getDescription();
            String commentSQL = String.format(SQL_COMMENT, tableName, columnName, comment);
            return new SQLDatabasePersistAction(CMD_COMMENT, commentSQL);
        }
        return null;
    }

    public void renameObject(DBECommandContext commandContext, ExasolTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }

    protected void addObjectRenameActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolTableColumn column = (ExasolTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + ((ExasolTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }
}

