/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.ext.erd.ERDConstants;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDLogicalForeignKey;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.AssociationPart;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.ext.erd.part.NodePart;
import org.jkiss.dbeaver.ext.erd.part.NotePart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiagramLoader {
    private static final Log log = Log.getLog(DiagramLoader.class);
    private static final String TAG_DIAGRAM = "diagram";
    private static final String TAG_ENTITIES = "entities";
    private static final String TAG_DATA_SOURCE = "data-source";
    private static final String TAG_ENTITY = "entity";
    private static final String TAG_PATH = "path";
    private static final String TAG_RELATIONS = "relations";
    private static final String TAG_RELATION = "relation";
    private static final String TAG_BEND = "bend";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ORDER = "order";
    private static final String ATTR_COLOR_BG = "color-bg";
    private static final String ATTR_FQ_NAME = "fq-name";
    private static final String ATTR_REF_NAME = "ref-name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PK_REF = "pk-ref";
    private static final String ATTR_FK_REF = "fk-ref";
    private static final String TAG_COLUMN = "column";
    private static final String ATTR_X = "x";
    private static final String ATTR_Y = "y";
    private static final String ATTR_W = "w";
    private static final String ATTR_H = "h";
    private static final int ERD_VERSION_1 = 1;
    private static final String BEND_ABSOLUTE = "abs";
    private static final String BEND_RELATIVE = "rel";
    private static final String TAG_NOTES = "notes";
    private static final String TAG_NOTE = "note";

    public static List<DBPDataSourceContainer> extractContainers(IFile resource) throws IOException, XMLException, DBException {
        ArrayList<DBPDataSourceContainer> containers = new ArrayList<DBPDataSourceContainer>();
        DataSourceRegistry dsRegistry = DBeaverCore.getInstance().getProjectRegistry().getDataSourceRegistry(resource.getProject());
        if (dsRegistry == null) {
            return containers;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = resource.getContents();){
                Document document = XMLUtils.parseDocument((InputStream)is);
                Element diagramElem = document.getDocumentElement();
                Element entitiesElem = XMLUtils.getChildElement((Element)diagramElem, (String)TAG_ENTITIES);
                if (entitiesElem != null) {
                    for (Element dsElem : XMLUtils.getChildElementList((Element)entitiesElem, (String)TAG_DATA_SOURCE)) {
                        DataSourceDescriptor dataSourceContainer;
                        String dsId = dsElem.getAttribute(ATTR_ID);
                        if (CommonUtils.isEmpty((String)dsId) || (dataSourceContainer = dsRegistry.getDataSource(dsId)) == null) continue;
                        containers.add((DBPDataSourceContainer)dataSourceContainer);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            throw new DBException("Error reading resource contents", (Throwable)e);
        }
        return containers;
    }

    public static void load(DBRProgressMonitor monitor, IProject project, DiagramPart diagramPart, InputStream in) throws IOException, XMLException, DBException {
        ERDEntity targetEntity;
        ERDEntity sourceEntity;
        Element notesElem;
        Element relationsElem;
        String locY;
        String locX;
        monitor.beginTask("Parse diagram", 1);
        EntityDiagram diagram = diagramPart.getDiagram();
        DataSourceRegistry dsRegistry = DBeaverCore.getInstance().getProjectRegistry().getDataSourceRegistry(project);
        if (dsRegistry == null) {
            throw new DBException("Cannot find datasource registry for project '" + project.getName() + "'");
        }
        Document document = XMLUtils.parseDocument((InputStream)in);
        Element diagramElem = document.getDocumentElement();
        monitor.done();
        String diagramVersion = diagramElem.getAttribute(ATTR_VERSION);
        if (CommonUtils.isEmpty((String)diagramVersion)) {
            throw new DBException("Diagram version not found");
        }
        if (!diagramVersion.equals(String.valueOf(1))) {
            throw new DBException("Unsupported diagram version: " + diagramVersion);
        }
        ArrayList<TableLoadInfo> tableInfos = new ArrayList<TableLoadInfo>();
        ArrayList<RelationLoadInfo> relInfos = new ArrayList<RelationLoadInfo>();
        HashMap<String, TableLoadInfo> tableMap = new HashMap<String, TableLoadInfo>();
        Element entitiesElem = XMLUtils.getChildElement((Element)diagramElem, (String)TAG_ENTITIES);
        if (entitiesElem != null) {
            for (Element dsElem : XMLUtils.getChildElementList((Element)entitiesElem, (String)TAG_DATA_SOURCE)) {
                DBPDataSource dataSource;
                String dsId = dsElem.getAttribute(ATTR_ID);
                if (CommonUtils.isEmpty((String)dsId)) {
                    log.warn((Object)"Missing datasource ID");
                    continue;
                }
                DataSourceDescriptor dataSourceDescriptor = dsRegistry.getDataSource(dsId);
                if (dataSourceDescriptor == null) {
                    log.warn((Object)("Datasource '" + dsId + "' not found"));
                    continue;
                }
                if (!dataSourceDescriptor.isConnected()) {
                    monitor.subTask("Connect to '" + dataSourceDescriptor.getName() + "'");
                    try {
                        dataSourceDescriptor.connect(monitor, true, true);
                    }
                    catch (DBException e) {
                        diagram.addErrorMessage("Can't connect to '" + dataSourceDescriptor.getName() + "': " + e.getMessage());
                        continue;
                    }
                }
                if (!((dataSource = dataSourceDescriptor.getDataSource()) instanceof DBSObjectContainer)) {
                    diagram.addErrorMessage("Datasource '" + dataSourceDescriptor.getName() + "' entities cannot be loaded - no entity container found");
                    continue;
                }
                DBSObjectContainer rootContainer = (DBSObjectContainer)dataSource;
                List entityElemList = XMLUtils.getChildElementList((Element)dsElem, (String)TAG_ENTITY);
                monitor.beginTask("Parse entities", entityElemList.size());
                for (Element entityElem : entityElemList) {
                    String orderStr;
                    String tableId = entityElem.getAttribute(ATTR_ID);
                    String tableName = entityElem.getAttribute(ATTR_NAME);
                    monitor.subTask("Load " + tableName);
                    ArrayList<String> path = new ArrayList<String>();
                    for (Element pathElem : XMLUtils.getChildElementList((Element)entityElem, (String)TAG_PATH)) {
                        path.add(0, pathElem.getAttribute(ATTR_NAME));
                    }
                    Object container = rootContainer;
                    for (String conName : path) {
                        DBSObject child = container.getChild(monitor, conName);
                        if (child == null) {
                            diagram.addErrorMessage("Container '" + conName + "' not found within '" + container.getName() + "'. Skip table '" + tableName + "'.");
                            container = null;
                            break;
                        }
                        if (child instanceof DBSObjectContainer) {
                            container = (DBSObjectContainer)child;
                            continue;
                        }
                        diagram.addErrorMessage("Object '" + child.getName() + "' is not a container");
                        container = null;
                        break;
                    }
                    if (container == null) continue;
                    DBSObject child = container.getChild(monitor, tableName);
                    if (!(child instanceof DBSEntity)) {
                        diagram.addErrorMessage("Cannot find table '" + tableName + "' in '" + container.getName() + "'");
                        continue;
                    }
                    locX = entityElem.getAttribute(ATTR_X);
                    locY = entityElem.getAttribute(ATTR_Y);
                    DBSEntity table = (DBSEntity)child;
                    EntityDiagram.NodeVisualInfo visualInfo = new EntityDiagram.NodeVisualInfo();
                    visualInfo.initBounds = new Rectangle();
                    if (CommonUtils.isEmpty((String)locX) || CommonUtils.isEmpty((String)locY)) {
                        diagram.setNeedsAutoLayout(true);
                    } else {
                        visualInfo.initBounds.x = Integer.parseInt(locX);
                        visualInfo.initBounds.y = Integer.parseInt(locY);
                    }
                    String colorBg = entityElem.getAttribute(ATTR_COLOR_BG);
                    if (!CommonUtils.isEmpty((String)colorBg)) {
                        visualInfo.bgColor = UIUtils.getSharedColor((String)colorBg);
                    }
                    if (!CommonUtils.isEmpty((String)(orderStr = entityElem.getAttribute(ATTR_ORDER)))) {
                        visualInfo.zOrder = Integer.parseInt(orderStr);
                    }
                    TableLoadInfo info = new TableLoadInfo(tableId, table, visualInfo);
                    tableInfos.add(info);
                    tableMap.put(info.objectId, info);
                    monitor.worked(1);
                }
                monitor.done();
            }
        }
        if ((relationsElem = XMLUtils.getChildElement((Element)diagramElem, (String)TAG_RELATIONS)) != null) {
            List relElemList = XMLUtils.getChildElementList((Element)relationsElem, (String)TAG_RELATION);
            monitor.beginTask("Parse relations", relElemList.size());
            for (Element relElem : relElemList) {
                String relName = relElem.getAttribute(ATTR_NAME);
                monitor.subTask("Load " + relName);
                String relType = relElem.getAttribute(ATTR_TYPE);
                String pkRefId = relElem.getAttribute(ATTR_PK_REF);
                String fkRefId = relElem.getAttribute(ATTR_FK_REF);
                if (CommonUtils.isEmpty((String)relName) || CommonUtils.isEmpty((String)pkRefId) || CommonUtils.isEmpty((String)fkRefId)) {
                    log.warn((Object)"Missing relation ID");
                    continue;
                }
                TableLoadInfo pkTable = (TableLoadInfo)tableMap.get(pkRefId);
                TableLoadInfo fkTable = (TableLoadInfo)tableMap.get(fkRefId);
                if (pkTable == null || fkTable == null) {
                    log.debug((Object)("PK (" + pkRefId + ") or FK (" + fkRefId + ") table(s) not found for relation " + relName));
                    continue;
                }
                RelationLoadInfo relationLoadInfo = new RelationLoadInfo(relName, relType, pkTable, fkTable);
                relInfos.add(relationLoadInfo);
                for (Element columnElem : XMLUtils.getChildElementList((Element)relElem, (String)TAG_COLUMN)) {
                    String name = columnElem.getAttribute(ATTR_NAME);
                    String refName = columnElem.getAttribute(ATTR_REF_NAME);
                    relationLoadInfo.columns.put(name, refName);
                }
                for (Element bendElem : XMLUtils.getChildElementList((Element)relElem, (String)TAG_BEND)) {
                    String type = bendElem.getAttribute(ATTR_TYPE);
                    if (BEND_RELATIVE.equals(type)) continue;
                    locX = bendElem.getAttribute(ATTR_X);
                    locY = bendElem.getAttribute(ATTR_Y);
                    if (CommonUtils.isEmpty((String)locX) || CommonUtils.isEmpty((String)locY)) continue;
                    relationLoadInfo.bends.add(new Point(Integer.parseInt(locX), Integer.parseInt(locY)));
                }
                monitor.worked(1);
            }
            monitor.done();
        }
        if ((notesElem = XMLUtils.getChildElement((Element)diagramElem, (String)TAG_NOTES)) != null) {
            List noteElemList = XMLUtils.getChildElementList((Element)notesElem, (String)TAG_NOTE);
            monitor.beginTask("Parse notes", noteElemList.size());
            for (Element element : noteElemList) {
                String orderStr;
                String colorBg;
                String noteText = XMLUtils.getElementBody((Element)element);
                ERDNote note = new ERDNote(noteText);
                diagram.addNote(note, false);
                String locX2 = element.getAttribute(ATTR_X);
                String locY2 = element.getAttribute(ATTR_Y);
                String locW = element.getAttribute(ATTR_W);
                String locH = element.getAttribute(ATTR_H);
                EntityDiagram.NodeVisualInfo visualInfo = new EntityDiagram.NodeVisualInfo();
                if (!(CommonUtils.isEmpty((String)locX2) || CommonUtils.isEmpty((String)locY2) || CommonUtils.isEmpty((String)locW) || CommonUtils.isEmpty((String)locH))) {
                    visualInfo.initBounds = new Rectangle(Integer.parseInt(locX2), Integer.parseInt(locY2), Integer.parseInt(locW), Integer.parseInt(locH));
                }
                if (!CommonUtils.isEmpty((String)(colorBg = element.getAttribute(ATTR_COLOR_BG)))) {
                    visualInfo.bgColor = UIUtils.getSharedColor((String)colorBg);
                }
                if (!CommonUtils.isEmpty((String)(orderStr = element.getAttribute(ATTR_ORDER)))) {
                    visualInfo.zOrder = Integer.parseInt(orderStr);
                }
                diagram.addVisualInfo(note, visualInfo);
            }
        }
        ArrayList<DBSEntity> tableList = new ArrayList<DBSEntity>();
        for (TableLoadInfo tableLoadInfo : tableInfos) {
            tableList.add(tableLoadInfo.table);
        }
        diagram.fillTables(monitor, tableList, null);
        for (TableLoadInfo tableLoadInfo : tableInfos) {
            ERDEntity erdEntity = diagram.getERDTable(tableLoadInfo.table);
            if (erdEntity == null) continue;
            diagram.addVisualInfo(erdEntity, tableLoadInfo.visualInfo);
        }
        for (RelationLoadInfo relationLoadInfo : relInfos) {
            if (!relationLoadInfo.type.equals(ERDConstants.CONSTRAINT_LOGICAL_FK.getId())) continue;
            sourceEntity = diagram.getERDTable(relationLoadInfo.pkTable.table);
            targetEntity = diagram.getERDTable(relationLoadInfo.fkTable.table);
            if (sourceEntity == null || targetEntity == null) continue;
            new ERDAssociation(targetEntity, sourceEntity, false);
        }
        for (RelationLoadInfo relationLoadInfo : relInfos) {
            if (CommonUtils.isEmpty(relationLoadInfo.bends)) continue;
            sourceEntity = diagram.getERDTable(relationLoadInfo.pkTable.table);
            if (sourceEntity == null) {
                log.warn((Object)("Source table " + relationLoadInfo.pkTable.table.getName() + " not found"));
                continue;
            }
            targetEntity = diagram.getERDTable(relationLoadInfo.fkTable.table);
            if (targetEntity == null) {
                log.warn((Object)("Target table " + relationLoadInfo.pkTable.table.getName() + " not found"));
                continue;
            }
            diagram.addInitRelationBends(sourceEntity, targetEntity, relationLoadInfo.name, relationLoadInfo.bends);
        }
    }

    public static void save(DBRProgressMonitor monitor, @Nullable DiagramPart diagramPart, EntityDiagram diagram, boolean verbose, OutputStream out) throws IOException {
        List allNodeFigures = diagramPart == null ? new ArrayList() : diagramPart.getFigure().getChildren();
        IdentityHashMap<DBPDataSourceContainer, DataSourceObjects> dsMap = new IdentityHashMap<DBPDataSourceContainer, DataSourceObjects>();
        if (diagram != null) {
            for (ERDEntity erdEntity : diagram.getEntities()) {
                DBPDataSourceContainer dsContainer = ((DBSEntity)erdEntity.getObject()).getDataSource().getContainer();
                DataSourceObjects desc = (DataSourceObjects)dsMap.get(dsContainer);
                if (desc == null) {
                    desc = new DataSourceObjects();
                    dsMap.put(dsContainer, desc);
                }
                desc.entities.add(erdEntity);
            }
        }
        IdentityHashMap<ERDEntity, TableSaveInfo> infoMap = new IdentityHashMap<ERDEntity, TableSaveInfo>();
        XMLBuilder xml = new XMLBuilder(out, "UTF-8");
        xml.setButify(true);
        if (verbose) {
            xml.addContent((CharSequence)"\n<!DOCTYPE diagram [\n<!ATTLIST diagram version CDATA #REQUIRED\n name CDATA #IMPLIED\n time CDATA #REQUIRED>\n<!ELEMENT diagram (entities, relations, notes)>\n<!ELEMENT entities (data-source*)>\n<!ELEMENT data-source (entity*)>\n<!ATTLIST data-source id CDATA #REQUIRED>\n<!ELEMENT entity (path*)>\n<!ATTLIST entity id ID #REQUIRED\n name CDATA #REQUIRED\n fq-name CDATA #REQUIRED>\n<!ELEMENT relations (relation*)>\n<!ELEMENT relation (bend*)>\n<!ATTLIST relation name CDATA #REQUIRED\n fq-name CDATA #REQUIRED\n pk-ref IDREF #REQUIRED\n fk-ref IDREF #REQUIRED>\n]>\n");
        }
        xml.startElement(TAG_DIAGRAM);
        xml.addAttribute(ATTR_VERSION, 1);
        if (diagram != null) {
            xml.addAttribute(ATTR_NAME, diagram.getName());
        }
        xml.addAttribute(ATTR_TIME, RuntimeUtils.getCurrentTimeStamp());
        if (diagram != null) {
            xml.startElement(TAG_ENTITIES);
            for (DBPDataSourceContainer dsContainer : dsMap.keySet()) {
                xml.startElement(TAG_DATA_SOURCE);
                xml.addAttribute(ATTR_ID, dsContainer.getId());
                DataSourceObjects desc = (DataSourceObjects)dsMap.get(dsContainer);
                int tableCounter = 1;
                for (ERDEntity erdEntity : desc.entities) {
                    EntityDiagram.NodeVisualInfo visualInfo;
                    DBSEntity table = (DBSEntity)erdEntity.getObject();
                    EntityPart entityPart = diagramPart == null ? null : diagramPart.getEntityPart(erdEntity);
                    TableSaveInfo info = new TableSaveInfo(erdEntity, entityPart, tableCounter++);
                    infoMap.put(erdEntity, info);
                    xml.startElement(TAG_ENTITY);
                    xml.addAttribute(ATTR_ID, info.objectId);
                    xml.addAttribute(ATTR_NAME, table.getName());
                    if (table instanceof DBPQualifiedObject) {
                        xml.addAttribute(ATTR_FQ_NAME, ((DBPQualifiedObject)table).getFullyQualifiedName(DBPEvaluationContext.UI));
                    }
                    if (entityPart != null) {
                        visualInfo = new EntityDiagram.NodeVisualInfo();
                        visualInfo.initBounds = entityPart.getBounds();
                        visualInfo.bgColor = entityPart.getCustomBackgroundColor();
                        DiagramLoader.saveColorAndOrder(allNodeFigures, xml, entityPart);
                    } else {
                        visualInfo = diagram.getVisualInfo(erdEntity);
                    }
                    if (visualInfo != null && visualInfo.initBounds != null) {
                        xml.addAttribute(ATTR_X, visualInfo.initBounds.x);
                        xml.addAttribute(ATTR_Y, visualInfo.initBounds.y);
                    }
                    DBSObject parent = table.getParentObject();
                    while (parent != null && parent != dsContainer) {
                        xml.startElement(TAG_PATH);
                        xml.addAttribute(ATTR_NAME, parent.getName());
                        xml.endElement();
                        parent = parent.getParentObject();
                    }
                    xml.endElement();
                }
                xml.endElement();
            }
            xml.endElement();
            xml.startElement(TAG_RELATIONS);
            for (ERDEntity erdEntity : diagram.getEntities()) {
                for (ERDAssociation rel : erdEntity.getPrimaryKeyRelationships()) {
                    List<Bendpoint> bendpoints;
                    AssociationPart associationPart;
                    xml.startElement(TAG_RELATION);
                    DBSEntityAssociation association = (DBSEntityAssociation)rel.getObject();
                    xml.addAttribute(ATTR_NAME, association.getName());
                    if (association instanceof DBPQualifiedObject) {
                        xml.addAttribute(ATTR_FQ_NAME, ((DBPQualifiedObject)association).getFullyQualifiedName(DBPEvaluationContext.UI));
                    }
                    xml.addAttribute(ATTR_TYPE, association.getConstraintType().getId());
                    TableSaveInfo pkInfo = (TableSaveInfo)infoMap.get(rel.getPrimaryKeyEntity());
                    if (pkInfo == null) {
                        log.error((Object)("Cannot find PK table '" + DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)rel.getPrimaryKeyEntity().getObject()), (DBPEvaluationContext)DBPEvaluationContext.UI) + "' in info map"));
                        continue;
                    }
                    TableSaveInfo fkInfo = (TableSaveInfo)infoMap.get(rel.getForeignKeyEntity());
                    if (fkInfo == null) {
                        log.error((Object)("Cannot find FK table '" + DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)rel.getForeignKeyEntity().getObject()), (DBPEvaluationContext)DBPEvaluationContext.UI) + "' in info map"));
                        continue;
                    }
                    xml.addAttribute(ATTR_PK_REF, pkInfo.objectId);
                    xml.addAttribute(ATTR_FK_REF, fkInfo.objectId);
                    if (association instanceof ERDLogicalForeignKey) {
                        for (DBSEntityAttributeRef dBSEntityAttributeRef : ((ERDLogicalForeignKey)association).getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor())) {
                            xml.startElement(TAG_COLUMN);
                            xml.addAttribute(ATTR_NAME, dBSEntityAttributeRef.getAttribute().getName());
                            try {
                                DBSEntityAttribute referenceAttribute = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)association, (DBSEntityAttribute)dBSEntityAttributeRef.getAttribute(), (boolean)false);
                                if (referenceAttribute != null) {
                                    xml.addAttribute(ATTR_REF_NAME, referenceAttribute.getName());
                                }
                            }
                            catch (DBException e) {
                                log.warn((Object)"Error getting reference attribute", (Throwable)e);
                            }
                            xml.endElement();
                        }
                    }
                    if (pkInfo.tablePart != null && (associationPart = pkInfo.tablePart.getConnectionPart(rel, false)) != null && !CommonUtils.isEmpty(bendpoints = associationPart.getBendpoints())) {
                        for (Bendpoint bendpoint : bendpoints) {
                            xml.startElement(TAG_BEND);
                            if (bendpoint instanceof AbsoluteBendpoint) {
                                xml.addAttribute(ATTR_TYPE, BEND_ABSOLUTE);
                                xml.addAttribute(ATTR_X, bendpoint.getLocation().x);
                                xml.addAttribute(ATTR_Y, bendpoint.getLocation().y);
                            } else if (bendpoint instanceof RelativeBendpoint) {
                                xml.addAttribute(ATTR_TYPE, BEND_RELATIVE);
                                xml.addAttribute(ATTR_X, bendpoint.getLocation().x);
                                xml.addAttribute(ATTR_Y, bendpoint.getLocation().y);
                            }
                            xml.endElement();
                        }
                    }
                    xml.endElement();
                }
            }
            xml.endElement();
            xml.startElement(TAG_NOTES);
            for (ERDNote note : diagram.getNotes()) {
                NotePart notePart = diagramPart == null ? null : diagramPart.getNotePart(note);
                xml.startElement(TAG_NOTE);
                if (notePart != null) {
                    DiagramLoader.saveColorAndOrder(allNodeFigures, xml, notePart);
                    Rectangle noteBounds = notePart.getBounds();
                    if (noteBounds != null) {
                        xml.addAttribute(ATTR_X, noteBounds.x);
                        xml.addAttribute(ATTR_Y, noteBounds.y);
                        xml.addAttribute(ATTR_W, noteBounds.width);
                        xml.addAttribute(ATTR_H, noteBounds.height);
                    }
                }
                xml.addText((CharSequence)note.getObject());
                xml.endElement();
            }
            xml.endElement();
        }
        xml.endElement();
        xml.flush();
    }

    private static void saveColorAndOrder(List allNodeFigures, XMLBuilder xml, NodePart nodePart) throws IOException {
        if (nodePart != null) {
            xml.addAttribute(ATTR_ORDER, allNodeFigures.indexOf(nodePart.getFigure()));
            Color color = nodePart.getCustomBackgroundColor();
            if (color != null) {
                xml.addAttribute(ATTR_COLOR_BG, StringConverter.asString((RGB)color.getRGB()));
            }
        }
    }

    private static class DataSourceObjects {
        List<ERDEntity> entities = new ArrayList<ERDEntity>();

        private DataSourceObjects() {
        }
    }

    private static class RelationLoadInfo {
        final String name;
        final String type;
        final TableLoadInfo pkTable;
        final TableLoadInfo fkTable;
        final Map<String, String> columns = new LinkedHashMap<String, String>();
        final List<Point> bends = new ArrayList<Point>();

        private RelationLoadInfo(String name, String type, TableLoadInfo pkTable, TableLoadInfo fkTable) {
            this.name = name;
            this.type = type;
            this.pkTable = pkTable;
            this.fkTable = fkTable;
        }
    }

    private static class TableLoadInfo {
        final String objectId;
        final DBSEntity table;
        final EntityDiagram.NodeVisualInfo visualInfo;

        private TableLoadInfo(String objectId, DBSEntity table, EntityDiagram.NodeVisualInfo visualInfo) {
            this.objectId = objectId;
            this.table = table;
            this.visualInfo = visualInfo;
        }
    }

    private static class TableSaveInfo {
        final ERDEntity erdEntity;
        final EntityPart tablePart;
        final int objectId;

        private TableSaveInfo(ERDEntity erdEntity, EntityPart tablePart, int objectId) {
            this.erdEntity = erdEntity;
            this.tablePart = tablePart;
            this.objectId = objectId;
        }
    }
}

