/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor;

import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jkiss.dbeaver.ext.erd.action.DiagramLayoutAction;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorPart;

public class ERDEditorContextMenuProvider
extends ContextMenuProvider {
    private ERDEditorPart editor;

    public ERDEditorContextMenuProvider(ERDEditorPart editor) {
        super((EditPartViewer)editor.getViewer());
        this.editor = editor;
    }

    public void buildContextMenu(IMenuManager menu) {
        if (this.editor.isLoaded()) {
            GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
            ISelection selection = this.editor.getGraphicalViewer().getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                this.editor.fillPartContextMenu(menu, (IStructuredSelection)selection);
            }
            menu.add((IContributionItem)new GroupMarker("navigator_additions"));
            menu.add((IContributionItem)new GroupMarker("additions"));
            menu.add((IContributionItem)new GroupMarker("additions_end"));
            menu.add((IContributionItem)new GroupMarker("tools"));
            menu.add((IContributionItem)new Separator());
            this.editor.fillAttributeVisibilityMenu(menu);
            menu.add((IAction)new DiagramLayoutAction(this.editor));
        }
    }
}

