/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.Collection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;

public class EntityAddCommand
extends Command {
    private DiagramPart diagramPart;
    private Collection<ERDEntity> entities;
    private Point location;

    public EntityAddCommand(DiagramPart diagram, Collection<ERDEntity> entities, Point location) {
        this.diagramPart = diagram;
        this.entities = entities;
        this.location = location;
    }

    public void execute() {
        Point curLocation = this.location == null ? null : new Point(this.location);
        block0: for (ERDEntity entity : this.entities) {
            this.diagramPart.getDiagram().addTable(entity, true);
            if (curLocation == null) continue;
            for (Object diagramChild : this.diagramPart.getChildren()) {
                EntityPart entityPart;
                if (!(diagramChild instanceof EntityPart) || (entityPart = (EntityPart)diagramChild).getTable() != entity) continue;
                Rectangle newBounds = new Rectangle();
                Dimension size = entityPart.getFigure().getPreferredSize();
                newBounds.x = curLocation.x;
                newBounds.y = curLocation.y;
                newBounds.width = size.width;
                newBounds.height = size.height;
                entityPart.modifyBounds(newBounds);
                curLocation.x += size.width + 20;
                continue block0;
            }
        }
    }

    public void undo() {
        for (ERDEntity entity : this.entities) {
            this.diagramPart.getDiagram().removeTable(entity, true);
        }
    }
}

