/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.office.export;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.data.office.export.StreamPOIConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StreamPOIConsumerPageOutput
extends ActiveWizardPage<DataTransferWizard> {
    private Text directoryText;
    private Text fileNameText;
    private Button showFolderCheckbox;
    private Button execProcessCheckbox;
    private Text execProcessText;

    public StreamPOIConsumerPageOutput() {
        super(CoreMessages.data_transfer_wizard_output_name);
        this.setTitle(CoreMessages.data_transfer_wizard_output_title);
        this.setDescription(CoreMessages.data_transfer_wizard_output_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final StreamPOIConsumerSettings settings = (StreamPOIConsumerSettings)((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamPOIConsumerSettings.class);
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.data_transfer_wizard_output_group_general, (int)5, (int)768, (int)0);
        this.directoryText = DialogUtils.createOutputFolderChooser((Composite)generalSettings, null, (ModifyListener)new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                settings.setOutputFolder(StreamPOIConsumerPageOutput.this.directoryText.getText());
                StreamPOIConsumerPageOutput.this.updatePageCompletion();
            }
        });
        ((GridData)this.directoryText.getParent().getLayoutData()).horizontalSpan = 4;
        UIUtils.createControlLabel((Composite)generalSettings, (String)CoreMessages.data_transfer_wizard_output_label_file_name_pattern);
        this.fileNameText = new Text((Composite)generalSettings, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        UIUtils.setContentProposalToolTip((Control)this.fileNameText, (String)"Output file name pattern", (String[])new String[]{"table", "timestamp", "project"});
        this.fileNameText.setLayoutData((Object)gd);
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                settings.setOutputFilePattern(StreamPOIConsumerPageOutput.this.fileNameText.getText());
                StreamPOIConsumerPageOutput.this.updatePageCompletion();
            }
        });
        UIUtils.installContentProposal((Control)this.fileNameText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"timestamp"), GeneralUtils.variablePattern((String)"project")}));
        new Label((Composite)generalSettings, 0);
        Group resultsSettings = UIUtils.createControlGroup((Composite)composite, (String)"Results", (int)2, (int)768, (int)0);
        this.showFolderCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, (String)CoreMessages.data_transfer_wizard_output_checkbox_open_folder, (boolean)true);
        this.showFolderCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenFolderOnFinish(StreamPOIConsumerPageOutput.this.showFolderCheckbox.getSelection());
            }
        });
        this.showFolderCheckbox.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        this.execProcessCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, (String)"Execute process on finish", (boolean)true);
        this.execProcessCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setExecuteProcessOnFinish(StreamPOIConsumerPageOutput.this.execProcessCheckbox.getSelection());
                StreamPOIConsumerPageOutput.this.toggleExecProcessControls();
                StreamPOIConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.execProcessText = new Text((Composite)resultsSettings, 2048);
        this.execProcessText.setLayoutData((Object)new GridData(768));
        this.execProcessText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                settings.setFinishProcessCommand(StreamPOIConsumerPageOutput.this.execProcessText.getText());
                StreamPOIConsumerPageOutput.this.updatePageCompletion();
            }
        });
        UIUtils.setContentProposalToolTip((Control)this.execProcessText, (String)"Process command line", (String[])new String[]{"file", "table", "timestamp", "project"});
        UIUtils.installContentProposal((Control)this.execProcessText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"timestamp"), GeneralUtils.variablePattern((String)"project"), GeneralUtils.variablePattern((String)"file")}));
        this.setControl((Control)composite);
    }

    private void toggleExecProcessControls() {
        boolean isExecCommand = this.execProcessCheckbox.getSelection();
        this.execProcessText.setEnabled(isExecCommand);
    }

    public void activatePage() {
        StreamPOIConsumerSettings settings = (StreamPOIConsumerSettings)((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamPOIConsumerSettings.class);
        this.directoryText.setText(CommonUtils.toString((Object)settings.getOutputFolder()));
        this.fileNameText.setText(CommonUtils.toString((Object)settings.getOutputFilePattern()));
        this.showFolderCheckbox.setSelection(settings.isOpenFolderOnFinish());
        this.execProcessCheckbox.setSelection(settings.isExecuteProcessOnFinish());
        this.execProcessText.setText(CommonUtils.toString((Object)settings.getFinishProcessCommand()));
        this.updatePageCompletion();
        this.toggleExecProcessControls();
    }

    protected boolean determinePageCompletion() {
        StreamPOIConsumerSettings settings = (StreamPOIConsumerSettings)((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamPOIConsumerSettings.class);
        boolean valid = true;
        if (CommonUtils.isEmpty((String)settings.getOutputFolder())) {
            valid = false;
        }
        if (CommonUtils.isEmpty((String)settings.getOutputFilePattern())) {
            valid = false;
        }
        if (settings.isExecuteProcessOnFinish() && CommonUtils.isEmpty((String)settings.getFinishProcessCommand())) {
            return false;
        }
        settings.setOutputEncodingBOM(false);
        return valid;
    }
}

