/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.office.export;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.data.office.export.Worksheet;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.impl.StreamExporterAbstract;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterXLSX
extends StreamExporterAbstract {
    private static final String PROP_HEADER = "header";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_ROWNUMBER = "rownumber";
    private static final String PROP_BORDER = "border";
    private static final String PROP_HEADER_FONT = "headerfont";
    private static final String BINARY_FIXED = "[BINARY]";
    private static final String PROP_TRUESTRING = "trueString";
    private static final String PROP_FALSESTRING = "falseString";
    private static final String PROP_EXPORT_SQL = "exportSql";
    private static final String PROP_SPLIT_SQLTEXT = "splitSqlText";
    private static final String PROP_SPLIT_BYROWCOUNT = "splitByRowCount";
    private static final String PROP_SPLIT_BYCOL = "splitByColNum";
    private static final int EXCEL2007MAXROWS = 1048575;
    private boolean showDescription;
    private static final int ROW_WINDOW = 100;
    private String nullString;
    private List<DBDAttributeBinding> columns;
    private SXSSFWorkbook wb;
    private boolean printHeader = false;
    private boolean rowNumber = false;
    private String boolTrue = "YES";
    private String boolFalse = "NO";
    private boolean exportSql = false;
    private boolean splitSqlText = false;
    private int splitByRowCount = 1048575;
    private int splitByCol = 0;
    private XSSFCellStyle style;
    private XSSFCellStyle styleHeader;
    private HashMap<Object, Worksheet> worksheets;

    public static Map<Object, Object> getDefaultProperties() {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put(PROP_ROWNUMBER, false);
        properties.put(PROP_BORDER, "THIN");
        properties.put(PROP_HEADER, true);
        properties.put(PROP_NULL_STRING, null);
        properties.put(PROP_HEADER_FONT, "BOLD");
        properties.put(PROP_TRUESTRING, "+");
        properties.put(PROP_FALSESTRING, "-");
        properties.put(PROP_EXPORT_SQL, false);
        properties.put(PROP_SPLIT_SQLTEXT, false);
        properties.put(PROP_SPLIT_BYROWCOUNT, 1048575);
        properties.put(PROP_SPLIT_BYCOL, -1);
        return properties;
    }

    public void init(IStreamDataExporterSite site) throws DBException {
        FontStyleProp fontStyle;
        BorderStyle border;
        Object nullStringProp = site.getProperties().get(PROP_NULL_STRING);
        this.nullString = nullStringProp == null ? null : nullStringProp.toString();
        try {
            this.printHeader = (Boolean)site.getProperties().get(PROP_HEADER);
        }
        catch (Exception e) {
            this.printHeader = false;
        }
        try {
            this.rowNumber = (Boolean)site.getProperties().get(PROP_ROWNUMBER);
        }
        catch (Exception e) {
            this.rowNumber = false;
        }
        try {
            this.boolTrue = (String)site.getProperties().get(PROP_TRUESTRING);
        }
        catch (Exception e) {
            this.boolTrue = "YES";
        }
        try {
            this.boolFalse = (String)site.getProperties().get(PROP_FALSESTRING);
        }
        catch (Exception e) {
            this.boolTrue = "NO";
        }
        try {
            this.exportSql = (Boolean)site.getProperties().get(PROP_EXPORT_SQL);
        }
        catch (Exception e) {
            this.exportSql = false;
        }
        try {
            this.splitSqlText = (Boolean)site.getProperties().get(PROP_SPLIT_SQLTEXT);
        }
        catch (Exception e) {
            this.splitSqlText = false;
        }
        try {
            this.splitByRowCount = (Integer)site.getProperties().get(PROP_SPLIT_BYROWCOUNT);
        }
        catch (Exception e) {
            this.splitByRowCount = 1048575;
        }
        try {
            this.splitByCol = (Integer)site.getProperties().get(PROP_SPLIT_BYCOL);
        }
        catch (Exception e) {
            this.splitByCol = -1;
        }
        this.wb = new SXSSFWorkbook(100);
        this.worksheets = new HashMap(1);
        this.styleHeader = (XSSFCellStyle)this.wb.createCellStyle();
        try {
            border = BorderStyle.valueOf((String)((String)site.getProperties().get(PROP_BORDER)));
        }
        catch (Exception e) {
            border = BorderStyle.NONE;
        }
        try {
            fontStyle = FontStyleProp.valueOf((String)site.getProperties().get(PROP_HEADER_FONT));
        }
        catch (Exception e) {
            fontStyle = FontStyleProp.NONE;
        }
        this.styleHeader.setBorderTop(border);
        this.styleHeader.setBorderBottom(border);
        this.styleHeader.setBorderLeft(border);
        this.styleHeader.setBorderRight(border);
        XSSFFont fontBold = (XSSFFont)this.wb.createFont();
        switch (fontStyle) {
            case BOLD: {
                fontBold.setBold(true);
                break;
            }
            case ITALIC: {
                fontBold.setItalic(true);
                break;
            }
            case STRIKEOUT: {
                fontBold.setStrikeout(true);
                break;
            }
            case UNDERLINE: {
                fontBold.setUnderline((byte)3);
                break;
            }
        }
        this.styleHeader.setFont((Font)fontBold);
        this.style = (XSSFCellStyle)this.wb.createCellStyle();
        this.style.setBorderTop(border);
        this.style.setBorderBottom(border);
        this.style.setBorderLeft(border);
        this.style.setBorderRight(border);
        super.init(site);
    }

    public void dispose() {
        try {
            if (this.exportSql) {
                try {
                    SXSSFSheet sh = this.wb.createSheet();
                    if (this.splitSqlText) {
                        String[] sqlText = this.getSite().getSource().getName().split("\n", this.wb.getSpreadsheetVersion().getMaxRows());
                        int sqlRownum = 0;
                        String[] stringArray = sqlText;
                        int n = sqlText.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            Row row = sh.createRow(sqlRownum);
                            Cell newcell = row.createCell(0);
                            newcell.setCellValue(s);
                            ++sqlRownum;
                            ++n2;
                        }
                    } else {
                        Row row = sh.createRow(0);
                        Cell newcell = row.createCell(0);
                        newcell.setCellValue(this.getSite().getSource().getName());
                    }
                    sh = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.wb.write(this.getSite().getOutputStream());
            this.wb.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.wb = null;
        for (Worksheet w : this.worksheets.values()) {
            w.dispose();
        }
        super.dispose();
    }

    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.showDescription = session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.show.columnDescription");
        if (this.showDescription) {
            boolean bindingsOk = true;
            DBDAttributeBindingMeta[] bindings = new DBDAttributeBindingMeta[this.columns.size()];
            int i = 0;
            while (i < this.columns.size()) {
                if (!(this.columns.get(i) instanceof DBDAttributeBindingMeta)) {
                    bindingsOk = false;
                    break;
                }
                bindings[i] = (DBDAttributeBindingMeta)this.columns.get(i);
                ++i;
            }
            if (bindingsOk) {
                ResultSetUtils.bindAttributes((DBCSession)session, null, (DBDAttributeBindingMeta[])bindings, null);
            }
        }
    }

    private void printHeader(Worksheet wsh) {
        Row row = wsh.getSh().createRow(wsh.getCurrentRow());
        int startCol = this.rowNumber ? 1 : 0;
        int i = 0;
        int columnsSize = this.columns.size();
        while (i < columnsSize) {
            String description;
            DBDAttributeBinding column = this.columns.get(i);
            String colName = column.getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = column.getName();
            }
            if (this.showDescription && !CommonUtils.isEmpty((String)(description = column.getDescription()))) {
                colName = String.valueOf(colName) + "\n" + description;
            }
            Cell cell = row.createCell(i + startCol, CellType.STRING);
            cell.setCellValue(colName);
            cell.setCellStyle((CellStyle)this.styleHeader);
            ++i;
        }
        wsh.incRow();
    }

    private void writeCellValue(Cell cell, Reader reader) throws IOException {
        try {
            int count;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[2000];
            while ((count = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, count);
            }
            if (sb.length() > 0) {
                cell.setCellValue(sb.toString());
            }
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    private Worksheet createSheet(Object colValue) {
        Worksheet w = new Worksheet((Sheet)this.wb.createSheet(), colValue, 0);
        if (this.printHeader) {
            this.printHeader(w);
        }
        return w;
    }

    private Worksheet getWsh(Object[] row) {
        Object colValue = this.splitByCol < 0 || this.splitByCol >= this.columns.size() ? "" : row[this.splitByCol];
        Worksheet w = this.worksheets.get(colValue);
        if (w == null) {
            w = this.createSheet(colValue);
            this.worksheets.put(w.getColumnVal(), w);
        } else if (w.getCurrentRow() >= this.splitByRowCount) {
            w = this.createSheet(colValue);
            this.worksheets.put(w.getColumnVal(), w);
        }
        return w;
    }

    public void exportRow(DBCSession session, Object[] row) throws DBException, IOException {
        Worksheet wsh = this.getWsh(row);
        Row rowX = wsh.getSh().createRow(wsh.getCurrentRow());
        int startCol = 0;
        if (this.rowNumber) {
            Cell cell = rowX.createCell(startCol, CellType.NUMERIC);
            cell.setCellStyle((CellStyle)this.style);
            cell.setCellValue(String.valueOf(wsh.getCurrentRow()));
            ++startCol;
        }
        int i = 0;
        while (i < row.length) {
            DBDAttributeBinding column = this.columns.get(i);
            Cell cell = rowX.createCell(i + startCol, this.getCellType(column));
            cell.setCellStyle((CellStyle)this.style);
            if (DBUtils.isNullValue((Object)row[i])) {
                if (!CommonUtils.isEmpty((String)this.nullString)) {
                    cell.setCellValue(this.nullString);
                }
            } else if (row[i] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) {
                        cell.setCellValue("[NULL]");
                    }
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        this.writeCellValue(cell, cs.getContentReader());
                    }
                    cell.setCellValue(BINARY_FIXED);
                }
                finally {
                    content.release();
                }
            } else if (row[i] instanceof Boolean) {
                cell.setCellValue(((Boolean)row[i]).booleanValue());
            } else if (row[i] instanceof Number) {
                cell.setCellValue(((Number)row[i]).doubleValue());
            } else {
                String stringValue = super.getValueDisplayString(column, row[i]);
                cell.setCellValue(stringValue);
            }
            ++i;
        }
        wsh.incRow();
    }

    private CellType getCellType(DBDAttributeBinding column) {
        switch (column.getDataKind()) {
            case NUMERIC: {
                return CellType.NUMERIC;
            }
            case BOOLEAN: {
                return CellType.BOOLEAN;
            }
            case STRING: {
                return CellType.STRING;
            }
        }
        return CellType.BLANK;
    }

    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
    }

    static enum FontStyleProp {
        NONE,
        BOLD,
        ITALIC,
        STRIKEOUT,
        UNDERLINE;

    }
}

