/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views.session;

import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.autorefresh.AutoRefreshControl;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.dbeaver.ui.views.session.SessionTable;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SessionManagerViewer<SESSION_TYPE extends DBAServerSession> {
    private SessionListControl sessionTable;
    private IEditorSite subSite;
    private SQLEditorBase sqlViewer;
    private Font boldFont;
    private PropertyTreeViewer sessionProps;
    private DBAServerSession curSession;
    private AutoRefreshControl refreshControl;

    public void dispose() {
        this.sessionTable.disposeControl();
        UIUtils.dispose((Resource)this.boldFont);
    }

    protected SessionManagerViewer(IWorkbenchPart part, Composite parent, final DBAServerSessionManager<SESSION_TYPE> sessionManager) {
        this.subSite = new SubEditorSite(part.getSite());
        this.boldFont = UIUtils.makeBoldFont(parent.getFont());
        Composite composite = UIUtils.createPlaceholder(parent, 1);
        SashForm sash = UIUtils.createPartDivider(part, composite, 66048);
        sash.setLayoutData((Object)new GridData(1808));
        this.refreshControl = new AutoRefreshControl((Control)sash, sessionManager.getClass().getSimpleName(), monitor -> DBeaverUI.syncExec(this::refreshSessions));
        this.sessionTable = new SessionListControl(sash, (IWorkbenchSite)part.getSite(), sessionManager);
        this.sessionTable.getItemsViewer().addSelectionChangedListener(event -> this.onSessionSelect(this.getSelectedSession()));
        this.sessionTable.setLayoutData(new GridData(768));
        this.sessionTable.createProgressPanel(composite);
        SashForm infoSash = UIUtils.createPartDivider(part, (Composite)sash, 65792);
        infoSash.setLayoutData((Object)new GridData(1808));
        this.sqlViewer = new SQLEditorBase(){

            @Override
            public DBCExecutionContext getExecutionContext() {
                return sessionManager.getDataSource().getDefaultContext(false);
            }

            @Override
            public boolean isFoldingEnabled() {
                return false;
            }
        };
        this.updateSQL();
        this.sqlViewer.createPartControl((Composite)infoSash);
        Control text = this.sqlViewer.getAdapter(Control.class);
        if (text instanceof StyledText) {
            ((StyledText)text).setWordWrap(true);
        }
        this.sqlViewer.reloadSyntaxRules();
        parent.addDisposeListener(e -> this.sqlViewer.dispose());
        this.sessionProps = new PropertyTreeViewer((Composite)infoSash, 2048);
        sash.setWeights(new int[]{50, 50});
        sash.setWeights(new int[]{70, 30});
    }

    protected void onSessionSelect(DBAServerSession session) {
        if (this.curSession == session) {
            return;
        }
        this.curSession = session;
        this.updateSQL();
        if (session == null) {
            this.sessionProps.clearProperties();
        } else {
            PropertyCollector propCollector = new PropertyCollector(session, true);
            propCollector.collectProperties();
            this.sessionProps.loadProperties(propCollector);
        }
    }

    protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
    }

    public DBAServerSession getSelectedSession() {
        ISelection selection = this.sessionTable.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return (DBAServerSession)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public void refreshSessions() {
        this.sessionTable.loadData();
        this.onSessionSelect(null);
        this.refreshControl.scheduleAutoRefresh(false);
    }

    public void alterSession(SESSION_TYPE session, Map<String, Object> options) {
        this.sessionTable.createAlterService(session, options).schedule();
    }

    private void updateSQL() {
        String text = this.curSession == null ? "" : CommonUtils.notEmpty((String)this.curSession.getActiveQuery());
        StringEditorInput sqlInput = new StringEditorInput(this.sessionTable.getShell().getText(), text, true, GeneralUtils.getDefaultFileEncoding());
        if (this.sqlViewer.getSite() == null) {
            try {
                this.sqlViewer.init(this.subSite, sqlInput);
            }
            catch (PartInitException e) {
                DBUserInterface.getInstance().showError(this.sessionTable.getShell().getText(), null, (Throwable)e);
            }
        } else {
            this.sqlViewer.setInput(sqlInput);
        }
        if (this.sqlViewer.getTextViewer() != null) {
            this.sqlViewer.reloadSyntaxRules();
        }
    }

    public Composite getControl() {
        return this.sessionTable.getControl();
    }

    public Map<String, Object> getSessionOptions() {
        return null;
    }

    private class SessionListControl
    extends SessionTable<SESSION_TYPE> {
        SessionListControl(SashForm sash, IWorkbenchSite site, DBAServerSessionManager<SESSION_TYPE> sessionManager) {
            super((Composite)sash, 0x10000000, site, sessionManager);
        }

        @Override
        protected void fillCustomActions(IContributionManager contributionManager) {
            SessionManagerViewer.this.contributeToToolbar(this.getSessionManager(), contributionManager);
            SessionManagerViewer.this.refreshControl.populateRefreshButton(contributionManager);
            contributionManager.add((IAction)new Action("Refresh sessions", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH)){

                public void run() {
                    SessionManagerViewer.this.refreshSessions();
                }
            });
        }

        @Override
        protected final Map<String, Object> getSessionOptions() {
            return SessionManagerViewer.this.getSessionOptions();
        }
    }
}

