/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;
import org.jkiss.dbeaver.ui.resources.ResourceUtils;

public class ScriptsHandlerImpl
extends AbstractResourceHandler {
    private static final Log log = Log.getLog(ScriptsHandlerImpl.class);

    @Override
    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        return super.getFeatures(resource);
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        if (resource instanceof IFolder) {
            return "script folder";
        }
        return "script";
    }

    @Override
    public String getResourceDescription(@NotNull IResource resource) {
        return ResourceUtils.getResourceDescription(resource);
    }

    @Override
    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        DBNResource node = super.makeNavigatorNode(parentNode, resource);
        this.updateNavigatorNode(node, resource);
        return node;
    }

    @Override
    public void updateNavigatorNode(@NotNull DBNResource node, @NotNull IResource resource) {
        super.updateNavigatorNode(node, resource);
        if (resource instanceof IFolder) {
            if (resource.getParent() instanceof IProject) {
                node.setResourceImage((DBPImage)UIIcon.SCRIPTS);
            }
        } else {
            node.setResourceImage((DBPImage)UIIcon.SQL_SCRIPT);
        }
    }

    @Override
    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        if (resource instanceof IFile) {
            FileEditorInput sqlInput = new FileEditorInput((IFile)resource);
            DBeaverUI.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)sqlInput, SQLEditor.class.getName());
        } else {
            super.openResource(resource);
        }
    }

    @Override
    @Nullable
    public Collection<DBPDataSourceContainer> getAssociatedDataSources(IResource resource) {
        if (resource instanceof IFile) {
            DBPDataSourceContainer dataSource = EditorUtils.getFileDataSource((IFile)resource);
            return dataSource == null ? null : Collections.singleton(dataSource);
        }
        return null;
    }

    @Override
    @NotNull
    public String getResourceNodeName(@NotNull IResource resource) {
        return super.getResourceNodeName(resource);
    }
}

