/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.language.PlatformLanguageDescriptor;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseGeneral
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.common";
    private Button automaticUpdateCheck;
    private Combo workspaceLanguage;
    private Button longOperationsCheck;
    private Spinner longOperationsTimeout;
    private Button logsDebugEnabled;
    private TextWithOpenFile logsDebugLocation;

    public PrefPageDatabaseGeneral() {
        this.setPreferenceStore(new PreferenceStoreDelegate(DBeaverCore.getGlobalPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 1, 5);
        Group groupObjects = UIUtils.createControlGroup(composite, CoreMessages.pref_page_ui_general_group_general, 2, 2, 0);
        this.automaticUpdateCheck = UIUtils.createCheckbox((Composite)groupObjects, CoreMessages.pref_page_ui_general_checkbox_automatic_updates, null, false, 2);
        Group groupLanguage = UIUtils.createControlGroup(composite, CoreMessages.pref_page_ui_general_group_language, 2, 2, 0);
        this.workspaceLanguage = UIUtils.createLabelCombo((Composite)groupLanguage, CoreMessages.pref_page_ui_general_combo_language, CoreMessages.pref_page_ui_general_combo_language_tip, 12);
        this.workspaceLanguage.setLayoutData((Object)new GridData(32));
        List<PlatformLanguageDescriptor> languages = PlatformLanguageRegistry.getInstance().getLanguages();
        DBPPlatformLanguage pLanguage = DBeaverCore.getInstance().getLanguage();
        int i = 0;
        while (i < languages.size()) {
            PlatformLanguageDescriptor lang = languages.get(i);
            this.workspaceLanguage.add(lang.getLabel());
            if (CommonUtils.equalObjects((Object)pLanguage, (Object)((Object)lang))) {
                this.workspaceLanguage.select(i);
            }
            ++i;
        }
        if (this.workspaceLanguage.getSelectionIndex() < 0) {
            this.workspaceLanguage.select(0);
        }
        Label tipLabel = UIUtils.createLabel((Composite)groupLanguage, CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart);
        tipLabel.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        Group agentGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_ui_general_group_task_bar, 2, 770, 0);
        this.longOperationsCheck = UIUtils.createCheckbox((Composite)agentGroup, CoreMessages.pref_page_ui_general_label_enable_long_operations, CoreMessages.pref_page_ui_general_label_enable_long_operations_tip, false, 2);
        this.longOperationsTimeout = UIUtils.createLabelSpinner((Composite)agentGroup, CoreMessages.pref_page_ui_general_label_long_operation_timeout, 0, 0, Integer.MAX_VALUE);
        if (RuntimeUtils.isPlatformMacOS()) {
            ControlEnableState.disable((Control)agentGroup);
        }
        Group groupLogs = UIUtils.createControlGroup(composite, CoreMessages.pref_page_ui_general_group_debug_logs, 2, 770, 0);
        this.logsDebugEnabled = UIUtils.createCheckbox((Composite)groupLogs, CoreMessages.pref_page_ui_general_label_enable_debug_logs, CoreMessages.pref_page_ui_general_label_enable_debug_logs_tip, false, 2);
        UIUtils.createControlLabel((Composite)groupLogs, CoreMessages.pref_page_ui_general_label_log_file_location);
        this.logsDebugLocation = new TextWithOpenFile((Composite)groupLogs, CoreMessages.pref_page_ui_general_label_open_file_text, new String[]{"*.log", "*.txt"});
        UIUtils.installContentProposal((Control)this.logsDebugLocation.getTextControl(), (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"workspace"), GeneralUtils.variablePattern((String)"home")}));
        this.logsDebugLocation.setLayoutData(new GridData(768));
        Label tipLabel2 = UIUtils.createLabel((Composite)groupLogs, CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart);
        tipLabel2.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        new PreferenceLinkArea(composite, 0, "org.jkiss.dbeaver.preferences.main.entityeditor", "<a>''{0}''</a> " + CoreMessages.pref_page_ui_general_label_settings, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        new PreferenceLinkArea(composite, 0, "org.jkiss.dbeaver.preferences.main.sqleditor", "<a>''{0}''</a>" + CoreMessages.pref_page_ui_general_label_settings, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        this.automaticUpdateCheck.setSelection(store.getBoolean("ui.auto.update.check"));
        this.longOperationsCheck.setSelection(store.getBoolean("agent.long.operation.notify"));
        this.longOperationsTimeout.setSelection(store.getInt("agent.long.operation.timeout"));
        this.logsDebugEnabled.setSelection(store.getBoolean("logs.debug.enabled"));
        this.logsDebugLocation.setText(store.getString("logs.debug.location"));
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        store.setValue("ui.auto.update.check", this.automaticUpdateCheck.getSelection());
        store.setValue("agent.long.operation.notify", this.longOperationsCheck.getSelection());
        store.setValue("agent.long.operation.timeout", this.longOperationsTimeout.getSelection());
        store.setValue("logs.debug.enabled", this.logsDebugEnabled.getSelection());
        store.setValue("logs.debug.location", this.logsDebugLocation.getText());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        if (this.workspaceLanguage.getSelectionIndex() >= 0) {
            PlatformLanguageDescriptor language = PlatformLanguageRegistry.getInstance().getLanguages().get(this.workspaceLanguage.getSelectionIndex());
            try {
                DBPPlatformLanguage curLanguage = DBeaverCore.getInstance().getLanguage();
                if (curLanguage != language) {
                    DBeaverCore.getInstance().setPlatformLanguage(language);
                    if (UIUtils.confirmAction(this.getShell(), "Restart " + GeneralUtils.getProductName(), "You need to restart " + GeneralUtils.getProductName() + " to perform actual language change.\nDo you want to restart?")) {
                        DBeaverUI.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PlatformUI.getWorkbench().restart();
                            }
                        });
                    }
                }
            }
            catch (DBException e) {
                DBeaverUI.getInstance().showError("Change language", "Can't switch language to " + (Object)((Object)language), e);
            }
        }
        return true;
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

