/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax.rules;

import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SQLVariableRule
implements IRule {
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{[^\\s]+\\}");
    private final IToken parameterToken;

    public SQLVariableRule(IToken parameterToken) {
        this.parameterToken = parameterToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c == 36) {
            c = scanner.read();
            if (c == 123) {
                int varLength = 0;
                while ((c = scanner.read()) != 125 && !Character.isWhitespace(c) && c != -1) {
                    ++varLength;
                }
                if (varLength > 0 && c == 125) {
                    return this.parameterToken;
                }
                scanner.unread();
                int i = varLength - 1;
                while (i >= 0) {
                    scanner.unread();
                    --i;
                }
            }
            scanner.unread();
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

