/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.ui.editors.sql.generator.GenerateSQLContributor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenObjectConsoleHandler;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class RunProcedureConsoleHandler
extends OpenObjectConsoleHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        DBPDataSourceContainer ds = null;
        String procName = null;
        List<DBSObject> selectedObjects = NavigatorUtils.getSelectedObjects(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        ArrayList<DBSProcedure> entities = new ArrayList<DBSProcedure>();
        for (DBSObject object : selectedObjects) {
            if (!(object instanceof DBSProcedure)) continue;
            DBSProcedure proc = (DBSProcedure)object;
            procName = proc.getName();
            entities.add(proc);
            ds = object.getDataSource().getContainer();
        }
        GenerateSQLContributor.SQLGenerator<DBSProcedure> generator = GenerateSQLContributor.CALL_GENERATOR(entities);
        String title = "Stored procedures call";
        if (entities.size() == 1 && !CommonUtils.isEmpty(procName)) {
            title = String.valueOf(procName) + " call";
        }
        this.openConsole(workbenchWindow, generator, ds, title, false);
        return null;
    }
}

