/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.properties;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.properties.ILazyPropertyLoadListener;
import org.jkiss.dbeaver.runtime.properties.PropertiesContributor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IProgressControlProvider;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderPage;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

public class TabbedFolderPageProperties
extends TabbedFolderPage
implements IRefreshablePart,
DBPEventListener {
    protected IWorkbenchPart part;
    protected IDatabaseEditorInput input;
    private Font boldFont;
    private UIJob refreshJob = null;
    private PropertyTreeViewer propertyTree;
    private DBPPropertySource curPropertySource;
    private PropertiesPageControl progressControl;
    private boolean attached;
    private boolean activated;

    public TabbedFolderPageProperties(IWorkbenchPart part, IDatabaseEditorInput input) {
        this.part = part;
        this.input = input;
        this.attached = !DBeaverCore.getGlobalPreferenceStore().getBoolean("entity.editor.info.detach");
    }

    @Override
    public void createControl(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont(parent.getFont());
        ProgressPageControl ownerProgressControl = null;
        if (this.part instanceof IProgressControlProvider) {
            ownerProgressControl = ((IProgressControlProvider)this.part).getProgressControl();
        }
        this.progressControl = new PropertiesPageControl(parent);
        if (parent.getLayout() instanceof GridLayout) {
            this.progressControl.setLayoutData(new GridData(1808));
        }
        if (ownerProgressControl != null) {
            this.progressControl.substituteProgressPanel(ownerProgressControl);
        } else {
            this.progressControl.createProgressPanel();
        }
        this.propertyTree.getTree().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TabbedFolderPageProperties.this.progressControl.activate(true);
            }

            public void focusLost(FocusEvent e) {
                TabbedFolderPageProperties.this.progressControl.activate(false);
            }
        });
        this.progressControl.addDisposeListener(e -> this.dispose());
    }

    @Override
    public void setFocus() {
        this.propertyTree.getControl().setFocus();
    }

    @Override
    public void dispose() {
        if (this.curPropertySource != null && this.curPropertySource.getEditableValue() instanceof DBSObject) {
            DBUtils.getObjectRegistry((DBSObject)((DBSObject)this.curPropertySource.getEditableValue())).removeDataSourceListener((DBPEventListener)this);
            this.curPropertySource = null;
        }
        UIUtils.dispose((Resource)this.boldFont);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshProperties() {
        TabbedFolderPageProperties tabbedFolderPageProperties = this;
        synchronized (tabbedFolderPageProperties) {
            if (this.refreshJob == null) {
                this.refreshJob = new RefreshJob();
                this.refreshJob.schedule(100L);
            }
        }
    }

    public void handleDataSourceEvent(DBPEvent event) {
        if (this.input.getDatabaseObject() == event.getObject() && !Boolean.FALSE.equals(event.getEnabled()) && !this.propertyTree.getControl().isDisposed()) {
            this.refreshProperties();
        }
    }

    @Override
    public void refreshPart(Object source, boolean force) {
        if (force) {
            this.curPropertySource = this.input.getPropertySource();
            if (this.propertyTree != null) {
                this.propertyTree.loadProperties(this.curPropertySource);
                this.refreshProperties();
            }
        }
    }

    @Override
    public void aboutToBeShown() {
        if (!this.activated) {
            this.activated = true;
            this.propertyTree.repackColumns();
        }
    }

    private boolean isAttached() {
        return this.attached;
    }

    private void detachPropertiesPanel() {
        String title;
        boolean attached = this.isAttached();
        String string = title = attached ? "Detach properties to top panel" : "Move properties to tab";
        if (UIUtils.confirmAction(this.part.getSite().getShell(), title, String.valueOf(title) + " will require to reopen editor.\nAre you sure?")) {
            DBPPreferenceStore prefs = DBeaverCore.getGlobalPreferenceStore();
            prefs.setValue("entity.editor.info.detach", attached);
            Object editor = this.part.getSite() instanceof MultiPageEditorSite ? ((MultiPageEditorSite)this.part.getSite()).getMultiPageEditor() : (IEditorPart)this.part;
            if (editor != null) {
                DBNNode node = null;
                if (editor.getEditorInput() instanceof DatabaseEditorInput) {
                    node = (DBNNode)((DatabaseEditorInput)editor.getEditorInput()).getNavigatorNode();
                }
                DBeaverUI.getActiveWorkbenchWindow().getActivePage().closeEditor(editor, false);
                if (node != null) {
                    NavigatorHandlerObjectOpen.openEntityEditor(node, null, DBeaverUI.getActiveWorkbenchWindow());
                }
            }
        }
    }

    private class PropertiesPageControl
    extends ProgressPageControl
    implements ILazyPropertyLoadListener {
        PropertiesPageControl(Composite parent) {
            super(parent, 0x10000000);
            TabbedFolderPageProperties.this.propertyTree = new PropertyTreeViewer(this, 0){

                @Override
                protected void contributeContextMenu(IMenuManager manager, Object node, String category, DBPPropertyDescriptor property) {
                    PropertiesPageControl.this.fillCustomActions((IContributionManager)manager);
                }
            };
            TabbedFolderPageProperties.this.propertyTree.setExtraLabelProvider((IBaseLabelProvider)new PropertyLabelProvider());
            TabbedFolderPageProperties.this.propertyTree.setExpandMode(PropertyTreeViewer.ExpandMode.FIRST);
            TabbedFolderPageProperties.this.propertyTree.addSelectionChangedListener(event -> {
                IWorkbenchPartSite site = TabbedFolderPageProperties.this.part.getSite();
                IActionBars actionBars = null;
                if (site instanceof IEditorSite) {
                    actionBars = ((IEditorSite)site).getActionBars();
                } else if (site instanceof IViewSite) {
                    actionBars = ((IViewSite)site).getActionBars();
                }
                if (actionBars != null) {
                    String statusText = null;
                    ISelection propsSelection = TabbedFolderPageProperties.this.propertyTree.getSelection();
                    Object selection = propsSelection instanceof IStructuredSelection ? ((IStructuredSelection)propsSelection).getFirstElement() : null;
                    DBPPropertyDescriptor prop = TabbedFolderPageProperties.this.propertyTree.getPropertyFromElement(selection);
                    if (prop != null && CommonUtils.isEmpty((String)(statusText = prop.getDescription()))) {
                        statusText = prop.getDisplayName();
                    }
                    if (CommonUtils.isEmpty(statusText)) {
                        statusText = CommonUtils.toString((Object)selection);
                    }
                    actionBars.getStatusLineManager().setMessage(CommonUtils.notEmpty((String)statusText));
                }
            });
            PropertiesContributor.getInstance().addLazyListener(this);
            TabbedFolderPageProperties.this.curPropertySource = TabbedFolderPageProperties.this.input.getPropertySource();
            TabbedFolderPageProperties.this.propertyTree.loadProperties(TabbedFolderPageProperties.this.curPropertySource);
            if (TabbedFolderPageProperties.this.input.getDatabaseObject() != null) {
                DBUtils.getObjectRegistry((DBSObject)((DBSObject)TabbedFolderPageProperties.this.curPropertySource.getEditableValue())).addDataSourceListener((DBPEventListener)TabbedFolderPageProperties.this);
            }
            TabbedFolderPageProperties.this.propertyTree.getControl().addDisposeListener(e -> {
                this.dispose();
                PropertiesContributor.getInstance().removeLazyListener(this);
            });
        }

        @Override
        protected void fillCustomActions(IContributionManager contributionManager) {
            super.fillCustomActions(contributionManager);
            contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)DBeaverUI.getActiveWorkbenchWindow(), "org.eclipse.ui.file.refresh"));
            contributionManager.add((IAction)new Action(TabbedFolderPageProperties.this.isAttached() ? "Detach properties to top panel" : "Move properties to tab", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ASTERISK)){

                public void run() {
                    TabbedFolderPageProperties.this.detachPropertiesPanel();
                }
            });
        }

        @Override
        public void handlePropertyLoad(Object object, DBPPropertyDescriptor property, Object propertyValue, boolean completed) {
            if (TabbedFolderPageProperties.this.curPropertySource.getEditableValue() == object && !TabbedFolderPageProperties.this.propertyTree.getControl().isDisposed()) {
                TabbedFolderPageProperties.this.refreshProperties();
            }
        }
    }

    private class PropertyLabelProvider
    extends ColumnLabelProvider
    implements IFontProvider {
        private PropertyLabelProvider() {
        }

        public Font getFont(Object element) {
            if (element instanceof DBPPropertyDescriptor && TabbedFolderPageProperties.this.curPropertySource != null && ((DBPPropertyDescriptor)element).isEditable(TabbedFolderPageProperties.this.curPropertySource.getEditableValue())) {
                return TabbedFolderPageProperties.this.boldFont;
            }
            return null;
        }
    }

    private class RefreshJob
    extends UIJob {
        RefreshJob() {
            super("Refresh properties");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!TabbedFolderPageProperties.this.propertyTree.getControl().isDisposed()) {
                TabbedFolderPageProperties.this.propertyTree.refresh();
                TabbedFolderPageProperties.this.propertyTree.getControl().redraw();
            }
            TabbedFolderPageProperties tabbedFolderPageProperties = TabbedFolderPageProperties.this;
            synchronized (tabbedFolderPageProperties) {
                TabbedFolderPageProperties.this.refreshJob = null;
            }
            return Status.OK_STATUS;
        }
    }
}

