/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.ui.editors.binary.BinaryContent;
import org.jkiss.dbeaver.ui.editors.binary.HexEditControl;
import org.jkiss.dbeaver.ui.editors.binary.HexStatusLine;
import org.jkiss.dbeaver.ui.editors.binary.dialogs.FindReplaceDialog;
import org.jkiss.dbeaver.ui.editors.binary.dialogs.GoToDialog;

public class HexManager {
    private BinaryContent content = null;
    private FontData fontData = null;
    private Font fontText = null;
    private List<Listener> listOfStatusChangedListeners = null;
    private List<SelectionListener> listOfLongListeners = null;
    private FindReplaceDialog findDialog = null;
    private GoToDialog goToDialog = null;
    private HexEditControl hexEditControl = null;
    private HexStatusLine statusLine = null;
    private Composite textsParent = null;
    private IMenuListener menuListener;
    private String defWidth;

    public HexEditControl getControl() {
        return this.hexEditControl;
    }

    public static void blockUntilFinished(Runnable task) {
        Thread thread = new Thread(task);
        thread.start();
        Display display = Display.getCurrent();
        final boolean[] pollerEnabled = new boolean[1];
        while (thread.isAlive() && !display.isDisposed()) {
            if (display.readAndDispatch()) continue;
            if (!pollerEnabled[0]) {
                pollerEnabled[0] = true;
                display.timerExec(300, new Runnable(){

                    @Override
                    public void run() {
                        pollerEnabled[0] = false;
                    }
                });
            }
            display.sleep();
        }
    }

    public static void reduceDistance(Shell fixedShell, Shell movingShell) {
        Rectangle fixed = fixedShell.getBounds();
        Rectangle moving = movingShell.getBounds();
        int[] fixedLower = new int[]{fixed.x, fixed.y};
        int[] fixedHigher = new int[]{fixed.x + fixed.width, fixed.y + fixed.height};
        int[] movingLower = new int[]{moving.x, moving.y};
        int[] movingSpan = new int[]{moving.width, moving.height};
        int i = 0;
        while (i < 2) {
            if (movingLower[i] + movingSpan[i] < fixedLower[i]) {
                movingLower[i] = fixedLower[i] - movingSpan[i] + 10;
            } else if (fixedHigher[i] < movingLower[i]) {
                movingLower[i] = fixedHigher[i] - 10;
            }
            ++i;
        }
        movingShell.setLocation(movingLower[0], movingLower[1]);
    }

    public Composite createEditorPart(Composite parent, int style) {
        if (this.hexEditControl != null) {
            throw new IllegalStateException("Editor part exists already");
        }
        if (parent == null) {
            throw new NullPointerException("Null parent");
        }
        this.textsParent = parent;
        this.hexEditControl = new HexEditControl(this.textsParent, style);
        this.hexEditControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HexManager.this.fontText != null && !HexManager.this.fontText.isDisposed()) {
                    HexManager.this.fontText.dispose();
                }
            }
        });
        if (this.fontData != null) {
            this.fontText = new Font((Device)Display.getCurrent(), this.fontData);
            this.hexEditControl.setFont(this.fontText);
        }
        if (this.defWidth != null) {
            this.hexEditControl.setDefWidth(Integer.valueOf(this.defWidth));
        }
        this.hexEditControl.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (HexManager.this.statusLine != null) {
                    HexManager.this.statusLine.updateInsertModeText(HexManager.this.hexEditControl == null || !HexManager.this.hexEditControl.isOverwriteMode());
                }
            }
        });
        if (this.listOfStatusChangedListeners != null) {
            for (Listener listOfStatusChangedListener : this.listOfStatusChangedListeners) {
                this.hexEditControl.addListener(24, listOfStatusChangedListener);
            }
            this.listOfStatusChangedListeners = null;
        }
        if (this.listOfLongListeners != null) {
            for (SelectionListener listOfLongListener : this.listOfLongListeners) {
                this.hexEditControl.addLongSelectionListener(listOfLongListener);
            }
            this.listOfLongListeners = null;
        }
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (HexManager.this.menuListener != null) {
                    HexManager.this.menuListener.menuAboutToShow(manager);
                }
            }
        });
        Menu contextMenu = menuManager.createContextMenu((Control)this.hexEditControl.getHexText());
        this.hexEditControl.getHexText().setMenu(contextMenu);
        contextMenu = menuManager.createContextMenu((Control)this.hexEditControl.getPreviewText());
        this.hexEditControl.getPreviewText().setMenu(contextMenu);
        return this.hexEditControl;
    }

    void dispose() {
        if (this.content != null) {
            this.content.dispose();
        }
    }

    public void addListener(Listener aListener) {
        if (aListener == null) {
            return;
        }
        if (this.hexEditControl == null) {
            if (this.listOfStatusChangedListeners == null) {
                this.listOfStatusChangedListeners = new ArrayList<Listener>();
            }
            this.listOfStatusChangedListeners.add(aListener);
        } else {
            this.hexEditControl.addListener(24, aListener);
        }
    }

    public void addLongSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.hexEditControl == null) {
            if (this.listOfLongListeners == null) {
                this.listOfLongListeners = new ArrayList<SelectionListener>();
            }
            this.listOfLongListeners.add(listener);
        } else {
            this.hexEditControl.addLongSelectionListener(listener);
        }
    }

    public boolean canRedo() {
        return this.hexEditControl != null && this.hexEditControl.canRedo();
    }

    public boolean canUndo() {
        return this.hexEditControl != null && this.hexEditControl.canUndo();
    }

    public void doCopy() {
        if (this.hexEditControl == null) {
            return;
        }
        this.hexEditControl.copy();
    }

    public void doCut() {
        if (this.hexEditControl == null) {
            return;
        }
        this.hexEditControl.cut();
    }

    public void doDelete() {
        this.hexEditControl.deleteSelected();
    }

    public void doFind() {
        if (this.findDialog == null) {
            this.findDialog = new FindReplaceDialog(this.textsParent.getShell());
        }
        this.findDialog.setTarget(this.hexEditControl);
        this.findDialog.open();
    }

    public void doGoTo() {
        long location;
        if (this.content.length() < 1L) {
            return;
        }
        if (this.goToDialog == null) {
            this.goToDialog = new GoToDialog(this.textsParent.getShell());
        }
        if ((location = this.goToDialog.open(this.content.length() - 1L)) >= 0L) {
            long button = this.goToDialog.getButtonPressed();
            if (button == 1L) {
                this.hexEditControl.showMark(location);
            } else {
                this.hexEditControl.selectBlock(location, location);
            }
        }
    }

    public void doPaste() {
        if (this.hexEditControl == null) {
            return;
        }
        this.hexEditControl.paste();
    }

    public void doSelectAll() {
        if (this.hexEditControl == null) {
            return;
        }
        this.hexEditControl.selectAll();
    }

    public void doRedo() {
        this.hexEditControl.redo();
    }

    public void doUndo() {
        this.hexEditControl.undo();
    }

    public BinaryContent getContent() {
        return this.content;
    }

    public long[] getSelection() {
        if (this.hexEditControl == null) {
            return new long[2];
        }
        return this.hexEditControl.getSelection();
    }

    public boolean isDirty() {
        return this.content != null && this.content.isDirty();
    }

    public boolean isOverwriteMode() {
        return this.hexEditControl == null || this.hexEditControl.isOverwriteMode();
    }

    public boolean isTextSelected() {
        if (this.hexEditControl == null) {
            return false;
        }
        long[] selection = this.hexEditControl.getSelection();
        return selection[0] != selection[1];
    }

    public void openFile(File aFile, String charset) throws IOException {
        if (this.content != null) {
            this.content.dispose();
            this.content = null;
        }
        this.content = new BinaryContent(aFile);
        this.hexEditControl.setCharset(charset);
        this.hexEditControl.setContentProvider(this.content);
    }

    public void setFocus() {
        if (this.hexEditControl != null) {
            this.hexEditControl.setFocus();
        }
        if (this.statusLine != null) {
            this.statusLine.updateInsertModeText(this.hexEditControl == null || !this.hexEditControl.isOverwriteMode());
            if (this.hexEditControl != null) {
                if (this.hexEditControl.isSelected()) {
                    this.statusLine.updateSelectionValueText(this.hexEditControl.getSelection(), this.hexEditControl.getActualValue());
                } else {
                    this.statusLine.updatePositionValueText(this.hexEditControl.getCaretPos(), this.hexEditControl.getActualValue());
                }
            } else {
                this.statusLine.updatePositionValueText(0L, (byte)0);
            }
        }
    }

    public void setSelection(long start, long end) {
        this.hexEditControl.setSelection(start, end);
    }

    public void setTextFont(FontData aFont) {
        this.fontData = aFont;
        if (HexEditControl.DEFAULT_FONT_DATA.equals((Object)this.fontData)) {
            this.fontData = null;
        }
        Font fontToDispose = this.fontText;
        this.fontText = null;
        if (this.hexEditControl != null) {
            if (this.fontData != null) {
                this.fontText = new Font((Device)Display.getCurrent(), this.fontData);
            }
            this.hexEditControl.setFont(this.fontText);
        }
        if (fontToDispose != null && !fontToDispose.isDisposed()) {
            fontToDispose.dispose();
        }
    }

    public void setMenuListener(IMenuListener menuListener) {
        this.menuListener = menuListener;
    }

    public void setDefWidth(String defValue) {
        this.defWidth = defValue;
    }

    public String getDefaultWidth() {
        return this.defWidth;
    }
}

