/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceUser;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;

public class DatabaseEditorListener
implements INavigatorListener {
    private final IDatabaseEditor databaseEditor;
    private DBPDataSourceContainer dataSourceContainer;

    DatabaseEditorListener(IDatabaseEditor databaseEditor) {
        this.databaseEditor = databaseEditor;
        IDatabaseEditorInput editorInput = databaseEditor.getEditorInput();
        if (editorInput.getDatabaseObject() instanceof DBPDataSourceContainer) {
            this.dataSourceContainer = (DBPDataSourceContainer)editorInput.getDatabaseObject();
        } else if (editorInput.getNavigatorNode() != null) {
            this.dataSourceContainer = editorInput.getNavigatorNode().getDataSourceContainer();
        }
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.acquire((DBPDataSourceUser)databaseEditor);
        }
        DBeaverCore.getInstance().getNavigatorModel().addListener((INavigatorListener)this);
    }

    public void dispose() {
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.release((DBPDataSourceUser)this.databaseEditor);
            this.dataSourceContainer = null;
        }
        DBeaverCore.getInstance().getNavigatorModel().removeListener((INavigatorListener)this);
    }

    public DBNNode getTreeNode() {
        return this.databaseEditor.getEditorInput().getNavigatorNode();
    }

    public void nodeChanged(DBNEvent event) {
        if (this.isValuableNode(event.getNode())) {
            Object runner = null;
            boolean closeEditor = false;
            if (event.getAction() == DBNEvent.Action.REMOVE) {
                closeEditor = true;
            } else if (event.getAction() == DBNEvent.Action.UPDATE) {
                if (event.getNodeChange() == DBNEvent.NodeChange.REFRESH || event.getNodeChange() == DBNEvent.NodeChange.LOAD) {
                    if (this.getTreeNode() == event.getNode()) {
                        this.databaseEditor.refreshPart(event, event.getNodeChange() == DBNEvent.NodeChange.REFRESH && event.getSource() == DBNEvent.FORCE_REFRESH);
                    }
                } else if (event.getNodeChange() == DBNEvent.NodeChange.UNLOAD) {
                    closeEditor = true;
                }
            }
            if (closeEditor) {
                if (DBeaverCore.isClosing()) {
                    this.dispose();
                    return;
                }
                IWorkbenchPage workbenchPage = this.databaseEditor.getSite().getWorkbenchWindow().getActivePage();
                if (workbenchPage != null) {
                    workbenchPage.closeEditor((IEditorPart)this.databaseEditor, false);
                }
            }
        }
    }

    protected boolean isValuableNode(DBNNode node) {
        DBNNode editorNode = this.getTreeNode();
        return node == editorNode || editorNode != null && editorNode.isChildOf(node);
    }
}

