/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.tools;

import java.io.File;
import java.util.Collection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizard;

public abstract class AbstractScriptExecuteWizard<BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends AbstractToolWizard<BASE_OBJECT, PROCESS_ARG>
implements IImportWizard {
    protected File inputFile = null;

    public AbstractScriptExecuteWizard(Collection<BASE_OBJECT> dbObject, String task) {
        super(dbObject, task);
    }

    @Override
    protected boolean isSingleTimeWizard() {
        return false;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.task);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.logPage);
    }

    @Override
    public void onSuccess(long workTime) {
        UIUtils.showMessageBox(this.getShell(), this.task, NLS.bind((String)CoreMessages.tools_script_execute_wizard_task_completed, (Object)this.task, (Object)this.getObjectsName()), 2);
    }

    @Override
    protected void startProcessHandler(DBRProgressMonitor monitor, PROCESS_ARG arg, ProcessBuilder processBuilder, Process process) {
        this.logPage.startLogReader(processBuilder, process.getInputStream());
        new AbstractToolWizard.TextFileTransformerJob(monitor, this.inputFile, process.getOutputStream(), this.getInputCharset(), this.getOutputCharset()).start();
    }

    @Override
    protected boolean isMergeProcessStreams() {
        return true;
    }

    protected String getInputCharset() {
        return "UTF-8";
    }

    protected String getOutputCharset() {
        return "UTF-8";
    }
}

