/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverClassFindJob;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.dbeaver.ui.dialogs.StandardErrorDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesPanel;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPropertiesControl;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverLibraryDetailsDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.EditMavenArtifactDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.ViewClasspathDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DriverEditDialog
extends HelpEnabledDialog {
    private static final Log log = Log.getLog(DriverEditDialog.class);
    private static final String DIALOG_ID = "DBeaver.DriverEditDialog";
    private static int dialogCount;
    private final boolean newDriver;
    private DataSourceProviderDescriptor provider;
    private DriverDescriptor driver;
    private String defaultCategory;
    private String curFolder = null;
    private TreeViewer libTable;
    private Button deleteButton;
    private Button updateVersionButton;
    private Button detailsButton;
    private Combo classListCombo;
    private Button findClassButton;
    private Combo driverCategoryCombo;
    private Text driverNameText;
    private Text driverDescText;
    private Text driverClassText;
    private Text driverURLText;
    private Text driverPortText;
    private PropertyTreeViewer parametersEditor;
    private ConnectionPropertiesControl connectionPropertiesEditor;
    private final List<DBPDriverLibrary> origLibList;
    private PropertySourceCustom driverPropertySource;
    private PropertySourceCustom connectionPropertySource;
    private ClientHomesPanel clientHomesPanel;
    private Button embeddedDriverCheck;
    private boolean showAddFiles = false;

    public static int getDialogCount() {
        return dialogCount;
    }

    public DriverEditDialog(Shell shell, DriverDescriptor driver) {
        super(shell, "driver-editor");
        this.driver = driver;
        this.provider = driver.getProviderDescriptor();
        this.defaultCategory = driver.getCategory();
        this.newDriver = false;
        this.origLibList = new ArrayList<DBPDriverLibrary>(driver.getDriverLibraries());
    }

    public DriverEditDialog(Shell shell, DataSourceProviderDescriptor provider, String category) {
        super(shell, "driver-editor");
        this.provider = provider;
        this.driver = provider.createDriver();
        this.defaultCategory = category;
        this.newDriver = true;
        this.origLibList = new ArrayList<DBPDriverLibrary>();
    }

    public DriverEditDialog(Shell shell, DataSourceProviderDescriptor provider, DriverDescriptor driver) {
        super(shell, "driver-editor");
        this.provider = provider;
        this.driver = provider.createDriver(driver);
        this.driver.setName(String.valueOf(this.driver.getName()) + " Copy");
        this.defaultCategory = driver.getCategory();
        this.newDriver = true;
        this.origLibList = new ArrayList<DBPDriverLibrary>();
    }

    public DriverDescriptor getDriver() {
        return this.driver;
    }

    public int open(boolean addFiles) {
        this.showAddFiles = addFiles;
        return this.open();
    }

    public int open() {
        try {
            ++dialogCount;
            int n = super.open();
            return n;
        }
        finally {
            --dialogCount;
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    @Override
    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        this.onChangeProperty();
        return ctl;
    }

    protected Control createDialogArea(Composite parent) {
        String license;
        if (this.newDriver) {
            this.getShell().setText(CoreMessages.dialog_edit_driver_title_create_driver);
        } else {
            this.getShell().setText(String.valueOf(CoreMessages.dialog_edit_driver_title_edit_driver) + this.driver.getName() + "'");
            this.getShell().setImage(DBeaverIcons.getImage(this.driver.getPlainIcon()));
        }
        boolean isReadOnly = !this.provider.isDriversManagable();
        int advStyle = isReadOnly ? 8 : 0;
        Composite group = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        group.setLayoutData((Object)gd);
        Group propsGroup = UIUtils.createControlGroup(group, CoreMessages.dialog_edit_driver_setting, 4, -1, -1);
        propsGroup.setLayoutData((Object)new GridData(768));
        if (!this.newDriver) {
            gd = new GridData(32);
            gd.horizontalSpan = 3;
            Text idText = UIUtils.createLabelText((Composite)propsGroup, "ID", this.driver.getId(), 2056, gd);
            idText.setToolTipText("Internal driver ID.\nCan be used in connections configurations and CLI commands.");
        }
        gd = new GridData(768);
        this.driverNameText = UIUtils.createLabelText((Composite)propsGroup, String.valueOf(CoreMessages.dialog_edit_driver_label_driver_name) + "*", this.driver.getName(), 0x800 | advStyle, gd);
        this.driverNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DriverEditDialog.this.onChangeProperty();
            }
        });
        UIUtils.createControlLabel((Composite)propsGroup, CoreMessages.dialog_edit_driver_type_label);
        final CSmartCombo providerCombo = new CSmartCombo((Composite)propsGroup, 2060, (ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return DBeaverIcons.getImage(((DataSourceProviderDescriptor)((Object)element)).getIcon());
            }

            public String getText(Object element) {
                return ((DataSourceProviderDescriptor)((Object)element)).getName();
            }
        });
        providerCombo.setLayoutData(new GridData(768));
        if (this.newDriver) {
            for (DataSourceProviderDescriptor provider : DataSourceProviderRegistry.getInstance().getDataSourceProviders()) {
                if (!provider.isDriversManagable()) continue;
                providerCombo.addItem(provider);
            }
            providerCombo.select(this.provider);
            providerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DriverEditDialog.this.provider = (DataSourceProviderDescriptor)((Object)providerCombo.getItem(providerCombo.getSelectionIndex()));
                    DriverEditDialog.this.driver = DriverEditDialog.this.provider.createDriver();
                }
            });
        } else {
            providerCombo.addItem(this.provider);
            providerCombo.select(this.provider);
        }
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.driverClassText = UIUtils.createLabelText((Composite)propsGroup, String.valueOf(CoreMessages.dialog_edit_driver_label_class_name) + "*", CommonUtils.notEmpty((String)this.driver.getDriverClassName()), 0x800 | advStyle, gd);
        this.driverClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DriverEditDialog.this.onChangeProperty();
            }
        });
        this.driverURLText = UIUtils.createLabelText((Composite)propsGroup, CoreMessages.dialog_edit_driver_label_sample_url, CommonUtils.notEmpty((String)this.driver.getSampleURL()), 0x800 | advStyle, gd);
        this.driverURLText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DriverEditDialog.this.onChangeProperty();
            }
        });
        gd = new GridData(768);
        this.driverPortText = UIUtils.createLabelText((Composite)propsGroup, CoreMessages.dialog_edit_driver_label_default_port, this.driver.getDefaultPort() == null ? "" : this.driver.getDefaultPort(), 0x800 | advStyle, gd);
        this.driverPortText.setLayoutData((Object)new GridData(0));
        this.driverPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DriverEditDialog.this.onChangeProperty();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.embeddedDriverCheck = UIUtils.createCheckbox((Composite)propsGroup, CoreMessages.dialog_edit_driver_embedded_label, this.driver.isEmbedded());
        this.embeddedDriverCheck.setLayoutData((Object)gd);
        Group infoGroup = UIUtils.createControlGroup(group, CoreMessages.dialog_edit_driver_description, 2, -1, -1);
        infoGroup.setLayoutData((Object)new GridData(768));
        this.driverCategoryCombo = UIUtils.createLabelCombo((Composite)infoGroup, CoreMessages.dialog_edit_driver_label_category, 0x804 | advStyle);
        this.driverCategoryCombo.setLayoutData((Object)new GridData(32));
        if (isReadOnly) {
            this.driverCategoryCombo.setEnabled(false);
        }
        TreeSet<String> categories = new TreeSet<String>();
        for (DataSourceProviderDescriptor provider : DataSourceProviderRegistry.getInstance().getDataSourceProviders()) {
            for (DriverDescriptor drv : provider.getEnabledDrivers()) {
                if (CommonUtils.isEmpty((String)drv.getCategory())) continue;
                categories.add(drv.getCategory());
            }
        }
        for (String category : categories) {
            this.driverCategoryCombo.add(category);
        }
        if (!CommonUtils.isEmpty((String)this.driver.getCategory())) {
            this.driverCategoryCombo.setText(this.driver.getCategory());
        } else if (!CommonUtils.isEmpty((String)this.defaultCategory)) {
            this.driverCategoryCombo.setText(this.defaultCategory);
        }
        this.driverDescText = UIUtils.createLabelText((Composite)infoGroup, CoreMessages.dialog_edit_driver_label_description, CommonUtils.notEmpty((String)this.driver.getDescription()), 0x800 | advStyle);
        if (!CommonUtils.isEmpty((String)this.driver.getWebURL())) {
            UIUtils.createControlLabel((Composite)infoGroup, CoreMessages.dialog_edit_driver_label_website);
            Link urlLabel = UIUtils.createLink((Composite)infoGroup, "<a>" + this.driver.getWebURL() + "</a>", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.launchProgram(DriverEditDialog.this.driver.getWebURL());
                }
            });
            urlLabel.setLayoutData((Object)new GridData(768));
        }
        TabFolder tabFolder = new TabFolder(group, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        if (this.provider.isDriversManagable()) {
            this.createLibrariesTab(tabFolder);
        }
        this.createConnectionPropertiesTab(tabFolder);
        this.createParametersTab(tabFolder);
        if (this.driver.getClientManager() != null) {
            this.createClientHomesTab(tabFolder);
        }
        if ((license = this.driver.getLicense()) != null) {
            this.createLicenseTab(tabFolder, license);
        }
        tabFolder.setSelection(0);
        this.loadSettings(false);
        if (this.showAddFiles) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DriverEditDialog.this.addLibraryFiles();
                }
            });
        }
        this.driverNameText.setFocus();
        return group;
    }

    private void createLibrariesTab(TabFolder group) {
        Composite libsGroup = new Composite((Composite)group, 0);
        libsGroup.setLayout((Layout)new GridLayout(2, false));
        Composite libsListGroup = new Composite(libsGroup, 0);
        GridData gd = new GridData(1808);
        libsListGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        libsListGroup.setLayout((Layout)layout);
        this.libTable = new TreeViewer(libsListGroup, 2818);
        this.libTable.setContentProvider((IContentProvider)new LibContentProvider());
        this.libTable.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof DBPDriverLibrary) {
                    DBPDriverLibrary lib = (DBPDriverLibrary)element;
                    String displayName = lib.getDisplayName();
                    if (lib.getPreferredVersion() != null) {
                        displayName = String.valueOf(displayName) + " [" + lib.getPreferredVersion() + "]";
                    }
                    cell.setText(displayName);
                    File localFile = lib.getLocalFile();
                    if (localFile != null && !localFile.exists()) {
                        cell.setForeground(Display.getDefault().getSystemColor(3));
                    } else if (!DriverEditDialog.this.driver.isLibraryResolved(lib)) {
                        cell.setForeground(Display.getDefault().getSystemColor(9));
                    } else {
                        cell.setForeground(null);
                    }
                    cell.setImage(DBeaverIcons.getImage((DBPImage)lib.getIcon()));
                } else {
                    cell.setText(element.toString());
                    cell.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.JAR));
                }
            }
        });
        this.libTable.getControl().setLayoutData((Object)new GridData(1808));
        this.libTable.getControl().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DriverEditDialog.this.changeLibSelection();
            }
        });
        boolean isReadOnly = !this.provider.isDriversManagable();
        Composite findClassGroup = new Composite(libsListGroup, 128);
        findClassGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        findClassGroup.setLayout((Layout)layout);
        UIUtils.createControlLabel(findClassGroup, CoreMessages.dialog_edit_driver_label_driver_class);
        this.classListCombo = new Combo(findClassGroup, 12);
        this.classListCombo.setLayoutData((Object)new GridData(768));
        this.classListCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = DriverEditDialog.this.classListCombo.getSelectionIndex();
                if (selIndex >= 0) {
                    DriverEditDialog.this.driverClassText.setText(DriverEditDialog.this.classListCombo.getItem(selIndex));
                }
            }
        });
        this.classListCombo.setEnabled(!isReadOnly);
        this.findClassButton = new Button(findClassGroup, 8);
        this.findClassButton.setText(CoreMessages.dialog_edit_driver_button_bind_class);
        this.findClassButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    DriverClassFindJob classFinder = new DriverClassFindJob(DriverEditDialog.this.driver, "java/sql/Driver", true);
                    new ProgressMonitorDialog(DriverEditDialog.this.getShell()).run(true, true, (IRunnableWithProgress)classFinder);
                    if (DriverEditDialog.this.classListCombo != null && !DriverEditDialog.this.classListCombo.isDisposed()) {
                        List<String> classNames = classFinder.getDriverClassNames();
                        DriverEditDialog.this.classListCombo.setItems(classNames.toArray(new String[classNames.size()]));
                        DriverEditDialog.this.classListCombo.setListVisible(true);
                    }
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getTargetException());
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            }
        });
        this.findClassButton.setEnabled(!isReadOnly);
        Composite libsControlGroup = new Composite(libsGroup, 128);
        libsControlGroup.setLayout((Layout)new GridLayout(1, true));
        libsControlGroup.setLayoutData((Object)new GridData(2));
        UIUtils.createToolButton(libsControlGroup, CoreMessages.dialog_edit_driver_button_add_file, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverEditDialog.this.addLibraryFiles();
            }
        });
        UIUtils.createToolButton(libsControlGroup, CoreMessages.dialog_edit_driver_button_add_folder, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverEditDialog.this.addLibraryFolder();
            }
        });
        UIUtils.createToolButton(libsControlGroup, CoreMessages.dialog_edit_driver_button_add_artifact, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverEditDialog.this.addMavenArtifact();
            }
        });
        this.updateVersionButton = UIUtils.createToolButton(libsControlGroup, CoreMessages.dialog_edit_driver_button_update_version, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverEditDialog.this.driver.updateFiles();
                DriverEditDialog.this.changeLibContent();
            }
        });
        this.detailsButton = UIUtils.createToolButton(libsControlGroup, CoreMessages.dialog_edit_driver_button_details, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new DriverLibraryDetailsDialog(DriverEditDialog.this.getShell(), DriverEditDialog.this.driver, DriverEditDialog.this.getSelectedLibrary()).open();
            }
        });
        this.detailsButton.setEnabled(false);
        this.deleteButton = UIUtils.createToolButton(libsControlGroup, CoreMessages.dialog_edit_driver_button_delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DriverEditDialog.this.libTable.getSelection();
                if (selection != null && !selection.isEmpty() && UIUtils.confirmAction(DriverEditDialog.this.getShell(), "Delete library", "Are you sure you want to delete selected libraries?")) {
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof DriverLibraryAbstract) {
                            DriverEditDialog.this.driver.removeDriverLibrary((DriverLibraryAbstract)obj);
                        }
                        ++n2;
                    }
                }
                DriverEditDialog.this.changeLibContent();
            }
        });
        this.deleteButton.setEnabled(false);
        UIUtils.createHorizontalLine(libsControlGroup);
        UIUtils.createToolButton(libsControlGroup, CoreMessages.dialog_edit_driver_button_classpath, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewClasspathDialog cpDialog = new ViewClasspathDialog(DriverEditDialog.this.getShell());
                cpDialog.open();
            }
        });
        this.changeLibContent();
        TabItem libsTab = new TabItem(group, 0);
        libsTab.setText(CoreMessages.dialog_edit_driver_tab_name_driver_libraries);
        libsTab.setToolTipText(CoreMessages.dialog_edit_driver_tab_tooltip_driver_libraries);
        libsTab.setControl((Control)libsGroup);
    }

    private void addMavenArtifact() {
        EditMavenArtifactDialog fd = new EditMavenArtifactDialog(this.getShell(), null);
        if (fd.open() == 0) {
            this.driver.addDriverLibrary(DriverLibraryAbstract.createFromPath(this.driver, DBPDriverLibrary.FileType.jar, "maven:/" + fd.getArtifact().getPath(), null));
            this.changeLibContent();
        }
    }

    private void addLibraryFolder() {
        DirectoryDialog fd = new DirectoryDialog(this.getShell(), 2);
        fd.setText(CoreMessages.dialog_edit_driver_dialog_open_driver_directory);
        fd.setFilterPath(this.curFolder);
        String selected = fd.open();
        if (selected != null) {
            this.curFolder = fd.getFilterPath();
            this.driver.addDriverLibrary(DriverLibraryAbstract.createFromPath(this.driver, DBPDriverLibrary.FileType.jar, selected, null));
            this.changeLibContent();
        }
    }

    private void addLibraryFiles() {
        FileDialog fd = new FileDialog(this.getShell(), 4098);
        fd.setText(CoreMessages.dialog_edit_driver_dialog_open_driver_library);
        fd.setFilterPath(this.curFolder);
        String[] filterExt = new String[]{"*.jar;*.zip", "*.dll;*.so", "*", "*.*"};
        fd.setFilterExtensions(filterExt);
        String selected = fd.open();
        if (selected != null) {
            this.curFolder = fd.getFilterPath();
            Object[] fileNames = fd.getFileNames();
            if (!ArrayUtils.isEmpty((Object[])fileNames)) {
                File folderFile = new File(this.curFolder);
                Object[] objectArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object fileName = objectArray[n2];
                    this.driver.addDriverLibrary(DriverLibraryAbstract.createFromPath(this.driver, ((String)fileName).endsWith(".jar") || ((String)fileName).endsWith(".zip") ? DBPDriverLibrary.FileType.jar : DBPDriverLibrary.FileType.lib, new File(folderFile, (String)fileName).getAbsolutePath(), null));
                    ++n2;
                }
                this.changeLibContent();
            }
        }
    }

    private void createParametersTab(TabFolder group) {
        Composite paramsGroup = new Composite((Composite)group, 0);
        paramsGroup.setLayout((Layout)new GridLayout(1, false));
        this.parametersEditor = new PropertyTreeViewer(paramsGroup, 2048);
        this.driverPropertySource = new PropertySourceCustom(this.driver.getProviderDescriptor().getDriverProperties(), this.driver.getDriverParameters());
        this.driverPropertySource.addDefaultValues(this.driver.getDefaultDriverParameters());
        this.parametersEditor.loadProperties(this.driverPropertySource);
        TabItem paramsTab = new TabItem(group, 0);
        paramsTab.setText(CoreMessages.dialog_edit_driver_tab_name_advanced_parameters);
        paramsTab.setToolTipText(CoreMessages.dialog_edit_driver_tab_tooltip_advanced_parameters);
        paramsTab.setControl((Control)paramsGroup);
    }

    private void createConnectionPropertiesTab(TabFolder group) {
        Composite paramsGroup = new Composite((Composite)group, 0);
        paramsGroup.setLayout((Layout)new GridLayout(1, false));
        this.connectionPropertiesEditor = new ConnectionPropertiesControl(paramsGroup, 2048);
        this.connectionPropertySource = this.connectionPropertiesEditor.makeProperties(this.driver, this.driver.getConnectionProperties());
        this.connectionPropertiesEditor.loadProperties(this.connectionPropertySource);
        TabItem paramsTab = new TabItem(group, 0);
        paramsTab.setText(CoreMessages.dialog_edit_driver_tab_name_connection_properties);
        paramsTab.setToolTipText(CoreMessages.dialog_edit_driver_tab_tooltip_connection_properties);
        paramsTab.setControl((Control)paramsGroup);
    }

    private void createClientHomesTab(TabFolder group) {
        this.clientHomesPanel = new ClientHomesPanel((Composite)group, 0);
        this.clientHomesPanel.loadHomes(this.driver);
        this.clientHomesPanel.setLayoutData(new GridData(1808));
        TabItem paramsTab = new TabItem(group, 0);
        paramsTab.setText(CoreMessages.dialog_edit_driver_tab_name_client_homes);
        paramsTab.setToolTipText(CoreMessages.dialog_edit_driver_tab_name_client_homes);
        paramsTab.setControl((Control)this.clientHomesPanel);
    }

    private void createLicenseTab(TabFolder group, String license) {
        Composite paramsGroup = new Composite((Composite)group, 0);
        paramsGroup.setLayout((Layout)new GridLayout(1, false));
        Text licenseText = new Text(paramsGroup, 2626);
        licenseText.setText(license);
        licenseText.setEditable(false);
        licenseText.setMessage(CoreMessages.dialog_edit_driver_text_driver_license);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        licenseText.setLayoutData((Object)gd);
        TabItem paramsTab = new TabItem(group, 0);
        paramsTab.setText(CoreMessages.dialog_edit_driver_tab_name_license);
        paramsTab.setToolTipText(CoreMessages.dialog_edit_driver_tab_tooltip_license);
        paramsTab.setControl((Control)paramsGroup);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button resetButton = this.createButton(parent, 8, CoreMessages.dialog_edit_driver_button_reset_to_defaults, false);
        if (this.driver.isCustom()) {
            resetButton.setEnabled(false);
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private DriverLibraryAbstract getSelectedLibrary() {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)this.libTable.getSelection();
        if (selection != null && !selection.isEmpty() && (element = selection.getFirstElement()) instanceof DriverLibraryAbstract) {
            return (DriverLibraryAbstract)element;
        }
        return null;
    }

    private void changeLibContent() {
        this.libTable.setInput(this.driver.getEnabledDriverLibraries());
        boolean hasFiles = false;
        boolean hasDownloads = false;
        for (DBPDriverLibrary dBPDriverLibrary : this.driver.getDriverLibraries()) {
            Collection<DriverDescriptor.DriverFileInfo> files;
            File localFile = dBPDriverLibrary.getLocalFile();
            boolean bl = hasFiles = hasFiles || !dBPDriverLibrary.isDisabled() && localFile != null && localFile.exists();
            if (!hasFiles && !dBPDriverLibrary.isDisabled() && (files = this.driver.getLibraryFiles(dBPDriverLibrary)) != null) {
                for (DriverDescriptor.DriverFileInfo file : files) {
                    if (file.getFile() == null || !file.getFile().exists()) continue;
                    hasFiles = true;
                }
            }
            if (dBPDriverLibrary.isDisabled() || !dBPDriverLibrary.isDownloadable()) continue;
            hasDownloads = true;
        }
        this.findClassButton.setEnabled(this.provider.isDriversManagable() && hasFiles);
        this.updateVersionButton.setEnabled(hasDownloads);
    }

    private void changeLibSelection() {
        DriverLibraryAbstract selectedLib = this.getSelectedLibrary();
        this.detailsButton.setEnabled(selectedLib != null);
        this.deleteButton.setEnabled(selectedLib != null);
    }

    private void onChangeProperty() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(!CommonUtils.isEmpty((String)this.driverNameText.getText()) && !CommonUtils.isEmpty((String)this.driverClassText.getText()));
        }
    }

    private void loadSettings(boolean original) {
        this.driverNameText.setText(original ? CommonUtils.notEmpty((String)this.driver.getOrigName()) : CommonUtils.notEmpty((String)this.driver.getName()));
        this.driverDescText.setText(original ? CommonUtils.notEmpty((String)this.driver.getOrigDescription()) : CommonUtils.notEmpty((String)this.driver.getDescription()));
        this.driverClassText.setText(original ? CommonUtils.notEmpty((String)this.driver.getOrigClassName()) : CommonUtils.notEmpty((String)this.driver.getDriverClassName()));
        this.driverURLText.setText(original ? CommonUtils.notEmpty((String)this.driver.getOrigSampleURL()) : CommonUtils.notEmpty((String)this.driver.getSampleURL()));
        this.driverPortText.setText(original ? (this.driver.getOrigDefaultPort() == null ? "" : this.driver.getOrigDefaultPort()) : (this.driver.getDefaultPort() == null ? "" : this.driver.getDefaultPort()));
        this.embeddedDriverCheck.setSelection(this.driver.isEmbedded());
        if (original) {
            this.resetLibraries(true);
        }
        if (this.libTable != null) {
            this.libTable.setInput(this.driver.getEnabledDriverLibraries());
            this.changeLibContent();
            this.changeLibSelection();
        }
        this.parametersEditor.loadProperties(this.driverPropertySource);
        this.connectionPropertiesEditor.loadProperties(this.connectionPropertySource);
        if (this.clientHomesPanel != null) {
            this.clientHomesPanel.loadHomes(this.driver);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 8) {
            this.loadSettings(true);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void cancelPressed() {
        this.resetLibraries(false);
        super.cancelPressed();
    }

    private void resetLibraries(boolean original) {
        List newLibList = CommonUtils.copyList(original ? this.driver.getOrigFiles() : this.origLibList);
        for (DBPDriverLibrary lib : newLibList) {
            lib.setDisabled(false);
            this.driver.addDriverLibrary(lib);
        }
        for (DBPDriverLibrary lib : CommonUtils.copyList(this.driver.getDriverLibraries())) {
            if (newLibList.contains(lib)) continue;
            this.driver.removeDriverLibrary(lib);
        }
    }

    protected void okPressed() {
        DriverDescriptor oldDriver;
        this.driver.setName(this.driverNameText.getText());
        this.driver.setCategory(this.driverCategoryCombo.getText());
        this.driver.setDescription(CommonUtils.notEmpty((String)this.driverDescText.getText()));
        this.driver.setDriverClassName(this.driverClassText.getText());
        this.driver.setSampleURL(this.driverURLText.getText());
        this.driver.setDriverDefaultPort(this.driverPortText.getText());
        this.driver.setEmbedded(this.embeddedDriverCheck.getSelection());
        this.driver.setModified(true);
        this.driver.setDriverParameters(this.driverPropertySource.getProperties());
        this.driver.setConnectionProperties(this.connectionPropertySource.getProperties());
        if (this.clientHomesPanel != null) {
            this.driver.setClientHomeIds(this.clientHomesPanel.getHomeIds());
        }
        if ((oldDriver = this.provider.getDriverByName(this.driver.getCategory(), this.driver.getName())) != null && oldDriver != this.driver) {
            UIUtils.showMessageBox(this.getShell(), "Driver create", "Driver '" + this.driver.getName() + "' already exists. Change driver name", 1);
            return;
        }
        if (this.provider.getDriver(this.driver.getId()) == null) {
            this.provider.addDriver(this.driver);
        }
        this.provider.getRegistry().saveDrivers();
        super.okPressed();
    }

    public static void showBadConfigDialog(final Shell shell, final String message, final DBException error) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DBPDataSource dataSource = error.getDataSource();
                String title = "Bad driver [" + dataSource.getContainer().getDriver().getName() + "] configuration";
                new BadDriverConfigDialog(shell, title, message == null ? title : message, error).open();
            }
        };
        DBeaverUI.syncExec(runnable);
    }

    private static class BadDriverConfigDialog
    extends StandardErrorDialog {
        private final DBPDataSource dataSource;

        public BadDriverConfigDialog(Shell shell, String title, String message, DBException error) {
            super(shell == null ? DBeaverUI.getActiveWorkbenchShell() : shell, title, message, RuntimeUtils.stripStack((IStatus)GeneralUtils.makeExceptionStatus((Throwable)error)), 4);
            this.dataSource = error.getDataSource();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 8, "Open Driver &Configuration", true);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.createDetailsButton(parent);
        }

        protected void buttonPressed(int id) {
            if (id == 8) {
                DBeaverUI.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DriverEditDialog dialog = new DriverEditDialog(DBeaverUI.getActiveWorkbenchShell(), (DriverDescriptor)dataSource.getContainer().getDriver());
                        dialog.open();
                    }
                });
                super.buttonPressed(0);
            }
            super.buttonPressed(id);
        }
    }

    private class LibContentProvider
    implements ITreeContentProvider {
        private LibContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DBPDriverLibrary) {
                Collection<DriverDescriptor.DriverFileInfo> files = DriverEditDialog.this.driver.getLibraryFiles((DBPDriverLibrary)parentElement);
                if (CommonUtils.isEmpty(files)) {
                    return null;
                }
                return files.toArray(new Object[files.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof DBPDriverLibrary) {
                return !CommonUtils.isEmpty(DriverEditDialog.this.driver.getLibraryFiles((DBPDriverLibrary)element));
            }
            return false;
        }
    }
}

