/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;

public class SelectDataSourceDialog
extends Dialog {
    private static final String PARAM_SHOW_CONNECTED = "showConnected";
    private static final String PARAM_SHOW_ALL_PROJECTS = "showAllProjects";
    @Nullable
    private final IProject project;
    private DBPDataSourceContainer dataSource = null;
    private static final String DIALOG_ID = "DBeaver.SelectDataSourceDialog";
    private boolean showConnected;
    private boolean showAllProjects;
    private DBNNode projectNode;
    private DBNNode rootNode;

    public SelectDataSourceDialog(@NotNull Shell parentShell, @Nullable IProject project, DBPDataSourceContainer selection) {
        super(parentShell);
        this.project = project;
        this.dataSource = selection;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        DBNDatabaseNode dsNode;
        DBNProject projectBaseNode;
        this.getShell().setText(CoreMessages.dialog_select_datasource_title);
        this.showConnected = this.getDialogBoundsSettings().getBoolean(PARAM_SHOW_CONNECTED);
        this.showAllProjects = this.getDialogBoundsSettings().getBoolean(PARAM_SHOW_ALL_PROJECTS);
        Composite group = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        DBeaverCore core = DBeaverCore.getInstance();
        this.rootNode = core.getNavigatorModel().getRoot();
        this.projectNode = null;
        if (this.project != null && (projectBaseNode = core.getNavigatorModel().getRoot().getProject(this.project)) != null) {
            this.projectNode = projectBaseNode.getDatabases();
        }
        IFilter dsFilter = element -> element instanceof DBNProject || element instanceof DBNProjectDatabases || element instanceof DBNLocalFolder;
        final DatabaseNavigatorTree dataSourceTree = new DatabaseNavigatorTree(group, this.getTreeRootNode(), 2052, false, dsFilter);
        gd = new GridData(1808);
        gd.heightHint = 500;
        gd.minimumHeight = 100;
        gd.minimumWidth = 100;
        dataSourceTree.setLayoutData(gd);
        Text descriptionText = new Text(group, 8);
        descriptionText.setLayoutData((Object)new GridData(768));
        final Button showConnectedCheck = new Button(group, 32);
        showConnectedCheck.setText("Show connected databases only");
        showConnectedCheck.setSelection(this.showConnected);
        showConnectedCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDataSourceDialog.this.showConnected = showConnectedCheck.getSelection();
                dataSourceTree.getViewer().getControl().setRedraw(false);
                try {
                    dataSourceTree.getViewer().refresh();
                    if (SelectDataSourceDialog.this.showConnected) {
                        dataSourceTree.getViewer().expandAll();
                    }
                }
                finally {
                    dataSourceTree.getViewer().getControl().setRedraw(true);
                }
                SelectDataSourceDialog.this.getDialogBoundsSettings().put(SelectDataSourceDialog.PARAM_SHOW_CONNECTED, SelectDataSourceDialog.this.showConnected);
            }
        });
        final Button showAllProjectsCheck = new Button(group, 32);
        showAllProjectsCheck.setText("Show all projects");
        showAllProjectsCheck.setSelection(this.showAllProjects);
        showAllProjectsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDataSourceDialog.this.showAllProjects = showAllProjectsCheck.getSelection();
                dataSourceTree.getViewer().getControl().setRedraw(false);
                try {
                    dataSourceTree.reloadTree(SelectDataSourceDialog.this.getTreeRootNode());
                    if (SelectDataSourceDialog.this.showAllProjects) {
                        dataSourceTree.getViewer().expandToLevel(3);
                    }
                }
                finally {
                    dataSourceTree.getViewer().getControl().setRedraw(true);
                }
                SelectDataSourceDialog.this.getDialogBoundsSettings().put(SelectDataSourceDialog.PARAM_SHOW_ALL_PROJECTS, SelectDataSourceDialog.this.showAllProjects);
            }
        });
        if (this.dataSource != null && (dsNode = core.getNavigatorModel().getNodeByObject((DBSObject)this.dataSource)) != null) {
            dataSourceTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)dsNode), true);
        }
        dataSourceTree.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (SelectDataSourceDialog.this.showConnected) {
                    if (element instanceof DBNDataSource) {
                        return ((DBNDataSource)element).getDataSource() != null;
                    }
                    if (element instanceof DBNLocalFolder) {
                        return ((DBNLocalFolder)element).hasConnected();
                    }
                }
                return element instanceof DBNProject || element instanceof DBNProjectDatabases || element instanceof DBNLocalFolder || element instanceof DBNDataSource;
            }
        });
        dataSourceTree.getViewer().addSelectionChangedListener(event -> {
            Object selNode;
            IStructuredSelection structSel = (IStructuredSelection)event.getSelection();
            Object object = selNode = structSel.isEmpty() ? null : structSel.getFirstElement();
            if (selNode instanceof DBNDataSource) {
                this.dataSource = ((DBNDataSource)selNode).getObject();
                this.getButton(0).setEnabled(true);
                String description = this.dataSource.getDescription();
                if (description == null) {
                    description = this.dataSource.getName();
                }
                descriptionText.setText(description);
            } else {
                this.dataSource = null;
                this.getButton(0).setEnabled(false);
            }
        });
        dataSourceTree.getViewer().addDoubleClickListener(event -> {
            if (this.getButton(0).isEnabled()) {
                this.okPressed();
            }
        });
        DBeaverUI.asyncExec(() -> {
            dataSourceTree.getViewer().getControl().setFocus();
            if (this.showConnected) {
                dataSourceTree.getViewer().expandAll();
            }
        });
        return group;
    }

    private DBNNode getTreeRootNode() {
        return this.showAllProjects || this.projectNode == null ? this.rootNode : this.projectNode;
    }

    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        if (this.dataSource == null) {
            this.getButton(0).setEnabled(false);
        }
        return ctl;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(132);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.createButton(composite, 0, "Select", true);
        this.createButton(composite, 9, "None", false);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 9) {
            this.dataSource = null;
            buttonId = 0;
        }
        super.buttonPressed(buttonId);
    }

    public DBPDataSourceContainer getDataSource() {
        return this.dataSource;
    }
}

