/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.utils.CommonUtils;

public class EditObjectFilterDialog
extends HelpEnabledDialog {
    public static final int SHOW_GLOBAL_FILTERS_ID = 1000;
    private static final String NULL_FILTER_NAME = "";
    private final DBPDataSourceRegistry dsRegistry;
    private String objectTitle;
    private DBSObjectFilter filter;
    private boolean globalFilter;
    private Composite blockControl;
    private ControlEnableState blockEnableState;
    private Table includeTable;
    private Table excludeTable;
    private Combo namesCombo;
    private Button enableButton;

    public EditObjectFilterDialog(Shell shell, DBPDataSourceRegistry dsRegistry, String objectTitle, DBSObjectFilter filter, boolean globalFilter) {
        super(shell, "object-filters");
        this.dsRegistry = dsRegistry;
        this.objectTitle = objectTitle;
        this.filter = new DBSObjectFilter(filter);
        this.globalFilter = globalFilter;
    }

    public DBSObjectFilter getFilter() {
        return this.filter;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(NLS.bind((String)CoreMessages.dialog_filter_title, (Object)this.objectTitle));
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite topPanel = UIUtils.createPlaceholder(composite, this.globalFilter ? 1 : 2);
        topPanel.setLayoutData((Object)new GridData(768));
        this.enableButton = UIUtils.createCheckbox(topPanel, CoreMessages.dialog_filter_button_enable, false);
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditObjectFilterDialog.this.filter.setEnabled(EditObjectFilterDialog.this.enableButton.getSelection());
                EditObjectFilterDialog.this.enableFiltersContent();
            }
        });
        this.enableButton.setLayoutData((Object)new GridData(768));
        this.enableButton.setSelection(this.filter.isEnabled());
        if (!this.globalFilter) {
            Link globalLink = UIUtils.createLink(topPanel, CoreMessages.dialog_filter_global_link, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditObjectFilterDialog.this.setReturnCode(1000);
                    EditObjectFilterDialog.this.close();
                }
            });
            globalLink.setLayoutData((Object)new GridData(128));
        }
        this.blockControl = UIUtils.createPlaceholder(composite, 1);
        this.blockControl.setLayoutData((Object)new GridData(1808));
        this.includeTable = this.createEditableList(CoreMessages.dialog_filter_list_include, this.filter.getInclude());
        this.excludeTable = this.createEditableList(CoreMessages.dialog_filter_list_exclude, this.filter.getExclude());
        UIUtils.createInfoLabel(this.blockControl, CoreMessages.dialog_connection_edit_wizard_general_filter_hint_text);
        Group sfGroup = UIUtils.createControlGroup(composite, CoreMessages.dialog_connection_edit_wizard_general_filter_save_label, 4, 768, 0);
        this.namesCombo = UIUtils.createLabelCombo((Composite)sfGroup, CoreMessages.dialog_connection_edit_wizard_general_filter_name_label, 4);
        this.namesCombo.setLayoutData((Object)new GridData(768));
        this.namesCombo.add(NULL_FILTER_NAME);
        ArrayList<String> sfNames = new ArrayList<String>();
        for (DBSObjectFilter sf : this.dsRegistry.getSavedFilters()) {
            sfNames.add(sf.getName());
        }
        Collections.sort(sfNames);
        for (String sfName : sfNames) {
            this.namesCombo.add(sfName);
        }
        this.namesCombo.setText(CommonUtils.notEmpty((String)this.filter.getName()));
        this.namesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditObjectFilterDialog.this.changeSavedFilter();
            }
        });
        Button saveButton = UIUtils.createPushButton((Composite)sfGroup, CoreMessages.dialog_connection_edit_wizard_general_filter_save_button, null);
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditObjectFilterDialog.this.saveConfigurations();
            }
        });
        Button removeButton = UIUtils.createPushButton((Composite)sfGroup, CoreMessages.dialog_connection_edit_wizard_general_filter_remove_button, null);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditObjectFilterDialog.this.dsRegistry.removeSavedFilter(EditObjectFilterDialog.this.namesCombo.getText());
                EditObjectFilterDialog.this.namesCombo.setText(EditObjectFilterDialog.NULL_FILTER_NAME);
            }
        });
        this.enableFiltersContent();
        return composite;
    }

    private void changeSavedFilter() {
        String filterName = this.namesCombo.getText();
        if (CommonUtils.equalObjects((Object)filterName, (Object)this.filter.getName())) {
            return;
        }
        if (CommonUtils.isEmpty((String)filterName)) {
            this.fillFilterValues(this.includeTable, null);
            this.fillFilterValues(this.excludeTable, null);
        } else {
            DBSObjectFilter savedFilter = this.dsRegistry.getSavedFilter(filterName);
            if (savedFilter != null) {
                this.fillFilterValues(this.includeTable, savedFilter.getInclude());
                this.fillFilterValues(this.excludeTable, savedFilter.getExclude());
            }
        }
        this.filter.setName(filterName);
    }

    private Table createEditableList(String name, List<String> values) {
        Group group = UIUtils.createControlGroup(this.blockControl, name, 2, 1808, 0);
        final Table valueTable = new Table((Composite)group, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        valueTable.setLayoutData((Object)gd);
        valueTable.setLinesVisible(true);
        TableColumn valueColumn = UIUtils.createTableColumn(valueTable, 16384, CoreMessages.dialog_filter_table_column_value);
        valueColumn.setWidth(300);
        this.fillFilterValues(valueTable, values);
        final CustomTableEditor tableEditor = new CustomTableEditor(valueTable){

            @Override
            protected Control createEditor(Table table, int index, TableItem item) {
                Text editor = new Text((Composite)table, 2048);
                editor.setText(item.getText());
                return editor;
            }

            @Override
            protected void saveEditorValue(Control control, int index, TableItem item) {
                item.setText(((Text)control).getText());
            }
        };
        Composite buttonsGroup = UIUtils.createPlaceholder((Composite)group, 1, 5);
        buttonsGroup.setLayoutData((Object)new GridData(2));
        Button addButton = new Button(buttonsGroup, 8);
        addButton.setText(CoreMessages.dialog_filter_button_add);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem newItem = new TableItem(valueTable, 16384);
                valueTable.setSelection(newItem);
                tableEditor.closeEditor();
                tableEditor.showEditor(newItem);
            }
        });
        final Button removeButton = new Button(buttonsGroup, 8);
        removeButton.setText(CoreMessages.dialog_filter_button_remove);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = valueTable.getSelectionIndex();
                if (selectionIndex >= 0) {
                    tableEditor.closeEditor();
                    valueTable.remove(selectionIndex);
                    removeButton.setEnabled(valueTable.getSelectionIndex() >= 0);
                }
            }
        });
        removeButton.setEnabled(false);
        Button clearButton = new Button(buttonsGroup, 8);
        clearButton.setText(CoreMessages.dialog_filter_button_clear);
        clearButton.setLayoutData((Object)new GridData(768));
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableEditor.closeEditor();
                valueTable.removeAll();
                removeButton.setEnabled(false);
            }
        });
        valueTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = valueTable.getSelectionIndex();
                removeButton.setEnabled(selectionIndex >= 0);
            }
        });
        return valueTable;
    }

    private void fillFilterValues(Table valueTable, List<String> values) {
        valueTable.removeAll();
        if (!CommonUtils.isEmpty(values)) {
            for (String value : values) {
                new TableItem(valueTable, 16384).setText(value);
            }
        }
    }

    private void enableFiltersContent() {
        if (this.filter.isEnabled()) {
            if (this.blockEnableState != null) {
                this.blockEnableState.restore();
                this.blockEnableState = null;
            }
        } else if (this.blockEnableState == null) {
            this.blockEnableState = ControlEnableState.disable((Control)this.blockControl);
        }
    }

    private void saveConfigurations() {
        this.filter.setEnabled(this.enableButton.getSelection());
        this.filter.setInclude(this.collectValues(this.includeTable));
        this.filter.setExclude(this.collectValues(this.excludeTable));
        this.filter.setName(this.namesCombo.getText());
        if (!CommonUtils.isEmpty((String)this.filter.getName())) {
            this.dsRegistry.updateSavedFilter(this.filter);
        }
    }

    private List<String> collectValues(Table table) {
        ArrayList<String> values = new ArrayList<String>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String value = item.getText().trim();
            if (!value.isEmpty() && !value.equals("%")) {
                values.add(value);
            }
            ++n2;
        }
        return values;
    }

    protected void okPressed() {
        this.saveConfigurations();
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }
}

